/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.entities.management.GroupVO;
import org.infoglue.cms.entities.management.RoleVO;
import org.infoglue.cms.entities.management.SystemUserVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.AuthorizationModule;
import org.infoglue.cms.security.InfoGlueGroup;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.InfoGlueRole;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.sorters.ReflectionComparator;

public class GenericCombinedAuthorizationModule
implements AuthorizationModule,
Serializable {
    private static final Logger logger = Logger.getLogger((String)GenericCombinedAuthorizationModule.class.getName());
    protected Properties extraProperties = null;
    private Database transactionObject = null;
    private List authorizationModules = new ArrayList();

    /*
     * WARNING - void declaration
     */
    private AuthorizationModule getAuthorizationModule(String authorizationModuleClassName, int index) throws SystemException {
        AuthorizationModule authorizationModule = null;
        try {
            Properties localProperties = new Properties();
            for (String string : this.extraProperties.keySet()) {
                void var6_7;
                String value = this.extraProperties.getProperty(string);
                if (string.startsWith(index + ".")) {
                    String string2 = string.substring(2);
                }
                localProperties.setProperty((String)var6_7, value);
            }
            localProperties.setProperty("authorizerIndex", "" + index);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("InfoGlueAuthenticationFilter.authorizerClass:" + authorizationModuleClassName));
            }
            authorizationModule = (AuthorizationModule)Class.forName(authorizationModuleClassName).newInstance();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("authorizationModule:" + authorizationModule));
            }
            authorizationModule.setExtraProperties(localProperties);
            authorizationModule.setTransactionObject(this.getTransactionObject());
        }
        catch (Exception e) {
            logger.error((Object)("There was an error initializing the authorizerClass:" + e.getMessage()), (Throwable)e);
            throw new SystemException("There was an error initializing the authorizerClass:" + e.getMessage(), e);
        }
        return authorizationModule;
    }

    public InfoGluePrincipal getAuthorizedInfoGluePrincipal(String userName) throws Exception {
        InfoGluePrincipal infogluePrincipal = null;
        int i = 0;
        String authorizerClassName = this.extraProperties.getProperty(i + ".authorizerClassName");
        while (authorizerClassName != null && !authorizerClassName.equals("") && infogluePrincipal == null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("getAuthorizedInfoGluePrincipal in " + authorizerClassName));
            }
            try {
                infogluePrincipal = this.getAuthorizationModule(authorizerClassName, i).getAuthorizedInfoGluePrincipal(userName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            authorizerClassName = this.extraProperties.getProperty(++i + ".authorizerClassName");
        }
        return infogluePrincipal;
    }

    public InfoGlueRole getAuthorizedInfoGlueRole(String roleName) throws Exception {
        InfoGlueRole role = null;
        int i = 0;
        String authorizerClassName = this.extraProperties.getProperty(i + ".authorizerClassName");
        while (authorizerClassName != null && !authorizerClassName.equals("") && role == null) {
            try {
                role = this.getAuthorizationModule(authorizerClassName, i).getAuthorizedInfoGlueRole(roleName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            authorizerClassName = this.extraProperties.getProperty(++i + ".authorizerClassName");
        }
        return role;
    }

    public InfoGlueGroup getAuthorizedInfoGlueGroup(String groupName) throws Exception {
        InfoGlueGroup group = null;
        int i = 0;
        String authorizerClassName = this.extraProperties.getProperty(i + ".authorizerClassName");
        while (authorizerClassName != null && !authorizerClassName.equals("") && group == null) {
            try {
                group = this.getAuthorizationModule(authorizerClassName, i).getAuthorizedInfoGlueGroup(groupName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            authorizerClassName = this.extraProperties.getProperty(++i + ".authorizerClassName");
        }
        return group;
    }

    public List authorizeUser(String userName) throws Exception {
        ArrayList roles = new ArrayList();
        int i = 0;
        String authorizerClassName = this.extraProperties.getProperty(i + ".authorizerClassName");
        while (authorizerClassName != null && !authorizerClassName.equals("")) {
            try {
                roles.addAll(this.getAuthorizationModule(authorizerClassName, i).authorizeUser(userName));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            authorizerClassName = this.extraProperties.getProperty(++i + ".authorizerClassName");
        }
        return roles;
    }

    public List getRoles() throws Exception {
        ArrayList roles = new ArrayList();
        int i = 0;
        String authorizerClassName = this.extraProperties.getProperty(i + ".authorizerClassName");
        while (authorizerClassName != null && !authorizerClassName.equals("")) {
            try {
                List systemRoles = this.getAuthorizationModule(authorizerClassName, i).getRoles();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("\nFound:" + systemRoles.size() + " roles in " + i));
                }
                roles.addAll(systemRoles);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            authorizerClassName = this.extraProperties.getProperty(++i + ".authorizerClassName");
        }
        Collections.sort(roles, new ReflectionComparator("displayName"));
        return roles;
    }

    public List getGroups() throws Exception {
        ArrayList groups = new ArrayList();
        int i = 0;
        String authorizerClassName = this.extraProperties.getProperty(i + ".authorizerClassName");
        while (authorizerClassName != null && !authorizerClassName.equals("")) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Looking for user in " + authorizerClassName));
            }
            try {
                groups.addAll(this.getAuthorizationModule(authorizerClassName, i).getGroups());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            authorizerClassName = this.extraProperties.getProperty(++i + ".authorizerClassName");
        }
        Collections.sort(groups, new ReflectionComparator("displayName"));
        return groups;
    }

    public List getUsers() throws Exception {
        ArrayList users = new ArrayList();
        int i = 0;
        String authorizerClassName = this.extraProperties.getProperty(i + ".authorizerClassName");
        while (authorizerClassName != null && !authorizerClassName.equals("")) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Looking for users in " + authorizerClassName));
            }
            try {
                users.addAll(this.getAuthorizationModule(authorizerClassName, i).getUsers());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            authorizerClassName = this.extraProperties.getProperty(++i + ".authorizerClassName");
        }
        Collections.sort(users, new ReflectionComparator("displayName"));
        return users;
    }

    public List getUsers(String roleName) throws Exception {
        return this.getRoleUsers(roleName);
    }

    public List getRoleUsers(String roleName) throws Exception {
        ArrayList users = new ArrayList();
        InfoGlueRole role = this.getAuthorizedInfoGlueRole(roleName);
        users.addAll(role.getAutorizationModule().getRoleUsers(roleName));
        return users;
    }

    public List getGroupUsers(String groupName) throws Exception {
        ArrayList users = new ArrayList();
        InfoGlueGroup group = this.getAuthorizedInfoGlueGroup(groupName);
        users.addAll(group.getAutorizationModule().getGroupUsers(groupName));
        return users;
    }

    public void createInfoGluePrincipal(SystemUserVO systemUserVO) throws Exception {
        int i = 0;
        String authorizerClassName = this.extraProperties.getProperty(i + ".authorizerClassName");
        while (authorizerClassName != null && !authorizerClassName.equals("")) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Creating user in " + authorizerClassName));
            }
            try {
                this.getAuthorizationModule(authorizerClassName, i).createInfoGluePrincipal(systemUserVO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            authorizerClassName = this.extraProperties.getProperty(++i + ".authorizerClassName");
        }
    }

    public void updateInfoGluePrincipal(SystemUserVO systemUserVO, String[] roleNames, String[] groupNames) throws Exception {
        InfoGluePrincipal principal = this.getAuthorizedInfoGluePrincipal(systemUserVO.getUserName());
        principal.getAutorizationModule().updateInfoGluePrincipal(systemUserVO, roleNames, groupNames);
    }

    public void updateInfoGluePrincipalPassword(String userName) throws Exception {
        InfoGluePrincipal principal = this.getAuthorizedInfoGluePrincipal(userName);
        principal.getAutorizationModule().updateInfoGluePrincipalPassword(userName);
    }

    public void updateInfoGlueAnonymousPrincipalPassword() throws Exception {
        InfoGluePrincipal principal = this.getAuthorizedInfoGluePrincipal(CmsPropertyHandler.getAnonymousUser());
        principal.getAutorizationModule().updateInfoGlueAnonymousPrincipalPassword();
    }

    public void updateInfoGluePrincipalPassword(String userName, String oldPassword, String newPassword) throws Exception {
        InfoGluePrincipal principal = this.getAuthorizedInfoGluePrincipal(userName);
        principal.getAutorizationModule().updateInfoGluePrincipalPassword(userName, oldPassword, newPassword);
    }

    public void deleteInfoGluePrincipal(String userName) throws Exception {
        InfoGluePrincipal principal = this.getAuthorizedInfoGluePrincipal(userName);
        principal.getAutorizationModule().deleteInfoGluePrincipal(userName);
    }

    public void createInfoGlueRole(RoleVO roleVO) throws Exception {
        int i = 0;
        String authorizerClassName = this.extraProperties.getProperty(i + ".authorizerClassName");
        while (authorizerClassName != null && !authorizerClassName.equals("")) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Creating role in " + authorizerClassName));
            }
            try {
                this.getAuthorizationModule(authorizerClassName, i).createInfoGlueRole(roleVO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            authorizerClassName = this.extraProperties.getProperty(++i + ".authorizerClassName");
        }
    }

    public void deleteInfoGlueRole(String roleName) throws Exception {
        InfoGlueRole role = this.getAuthorizedInfoGlueRole(roleName);
        role.getAutorizationModule().deleteInfoGlueRole(roleName);
    }

    public void updateInfoGlueRole(RoleVO roleVO, String[] userNames) throws Exception {
        InfoGlueRole role = this.getAuthorizedInfoGlueRole(roleVO.getRoleName());
        role.getAutorizationModule().updateInfoGlueRole(roleVO, userNames);
    }

    public void createInfoGlueGroup(GroupVO groupVO) throws Exception {
        int i = 0;
        String authorizerClassName = this.extraProperties.getProperty(i + ".authorizerClassName");
        while (authorizerClassName != null && !authorizerClassName.equals("")) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Creating Group in " + authorizerClassName));
            }
            try {
                this.getAuthorizationModule(authorizerClassName, i).createInfoGlueGroup(groupVO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            authorizerClassName = this.extraProperties.getProperty(++i + ".authorizerClassName");
        }
    }

    public void deleteInfoGlueGroup(String groupName) throws Exception {
        InfoGlueGroup group = this.getAuthorizedInfoGlueGroup(groupName);
        group.getAutorizationModule().deleteInfoGlueGroup(groupName);
    }

    public void updateInfoGlueGroup(GroupVO groupVO, String[] userNames) throws Exception {
        InfoGlueGroup group = this.getAuthorizedInfoGlueGroup(groupVO.getGroupName());
        group.getAutorizationModule().updateInfoGlueGroup(groupVO, userNames);
    }

    public boolean getSupportUpdate() {
        return true;
    }

    public boolean getSupportDelete() {
        return true;
    }

    public boolean getSupportCreate() {
        return true;
    }

    public List getFilteredUsers(String firstName, String lastName, String userName, String email, String[] roleIds) throws Exception {
        return null;
    }

    public Properties getExtraProperties() {
        return this.extraProperties;
    }

    public void setExtraProperties(Properties properties) {
        this.extraProperties = properties;
    }

    public void setTransactionObject(Object transactionObject) {
        this.transactionObject = (Database)transactionObject;
    }

    public Object getTransactionObject() {
        return this.transactionObject;
    }
}

