/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.security;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.infoglue.cms.entities.management.GroupVO;
import org.infoglue.cms.entities.management.RoleVO;
import org.infoglue.cms.entities.management.SystemUserVO;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.io.FileHelper;
import org.infoglue.cms.security.AuthorizationModule;
import org.infoglue.cms.security.InfoGlueGroup;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.InfoGlueRole;
import org.infoglue.cms.util.dom.DOMBuilder;
import org.infoglue.deliver.util.CacheController;

public class DummyAuthorizationModule
implements AuthorizationModule,
Serializable {
    private static final Logger logger = Logger.getLogger((String)DummyAuthorizationModule.class.getName());
    private static final DOMBuilder domHelper = new DOMBuilder();
    protected Properties extraProperties = null;

    public boolean getSupportUpdate() {
        return false;
    }

    public boolean getSupportDelete() {
        return false;
    }

    public boolean getSupportCreate() {
        return false;
    }

    public InfoGluePrincipal getAuthorizedInfoGluePrincipal(String userName) throws Exception {
        throw new Exception("Error....");
    }

    public InfoGlueRole getAuthorizedInfoGlueRole(String roleName) throws Exception {
        InfoGlueRole infoglueRole = null;
        List roles = this.getRoles();
        for (InfoGlueRole infoglueRoleCandidate : roles) {
            if (!infoglueRoleCandidate.getName().equals(roleName)) continue;
            infoglueRole = infoglueRoleCandidate;
            break;
        }
        return infoglueRole;
    }

    public InfoGlueGroup getAuthorizedInfoGlueGroup(String groupName) throws Exception {
        InfoGlueGroup infoglueGroup = null;
        List groups = this.getGroups();
        for (InfoGlueGroup infoglueGroupCandidate : groups) {
            if (!infoglueGroupCandidate.getName().equals(groupName)) continue;
            infoglueGroup = infoglueGroupCandidate;
            break;
        }
        return infoglueGroup;
    }

    public List authorizeUser(String userName) throws Exception {
        return this.getRoles(userName);
    }

    protected List getRoles(String userName) throws Exception {
        List roles = new ArrayList();
        InfoGluePrincipal principal = this.getAuthorizedInfoGluePrincipal(userName);
        if (principal != null && principal.getRoles() != null) {
            roles = principal.getRoles();
        }
        return roles;
    }

    protected List getGroups(String userName) throws Exception {
        List groups = new ArrayList();
        InfoGluePrincipal principal = this.getAuthorizedInfoGluePrincipal(userName);
        if (principal != null && principal.getRoles() != null) {
            groups = principal.getGroups();
        }
        return groups;
    }

    public List getRoles() throws Exception {
        logger.info((Object)"getRoles start....");
        ArrayList<InfoGlueRole> roles = new ArrayList<InfoGlueRole>();
        String xml = FileHelper.getFileAsString(new File("c:\\temp\\roles.xml"));
        if (logger.isDebugEnabled()) {
            logger.info((Object)("Roles xml:" + xml));
        }
        if (xml != null && !xml.equals("")) {
            Document document = domHelper.getDocument(xml);
            List roleNodes = document.selectNodes("/roles/role");
            for (Element roleElement : roleNodes) {
                String name;
                Element nameElement = (Element)roleElement.selectSingleNode("name");
                Element displayNameElement = (Element)roleElement.selectSingleNode("displayName");
                Element descriptionElement = (Element)roleElement.selectSingleNode("description");
                String displayName = name = nameElement.getText();
                if (displayNameElement != null && !displayNameElement.getText().equals("")) {
                    displayName = displayNameElement.getText();
                }
                String description = "No description";
                if (descriptionElement != null && !descriptionElement.getText().equals("")) {
                    description = descriptionElement.getText();
                }
                InfoGlueRole infoglueRole = new InfoGlueRole(name, displayName, description, this);
                roles.add(infoglueRole);
            }
        }
        return roles;
    }

    public List getUsers() throws Exception {
        logger.info((Object)"*******************");
        logger.info((Object)"* getUsers start  *");
        logger.info((Object)"*******************");
        ArrayList<InfoGluePrincipal> users = new ArrayList<InfoGluePrincipal>();
        String xml = FileHelper.getFileAsString(new File("c:\\temp\\users.xml"));
        if (logger.isDebugEnabled()) {
            logger.info((Object)("Users xml:" + xml));
        }
        if (xml != null && !xml.equals("")) {
            try {
                Document document = domHelper.getDocument(xml);
                List usersNodes = document.selectNodes("/users");
                List userNodes = document.selectNodes("/users/user");
                for (Element userElement : userNodes) {
                    Element userNameElement = (Element)userElement.selectSingleNode("userName");
                    if (userNameElement == null) {
                        userNameElement = (Element)userElement.selectSingleNode("username");
                    }
                    Element firstNameElement = (Element)userElement.selectSingleNode("firstName");
                    Element lastNameElement = (Element)userElement.selectSingleNode("lastName");
                    Element emailElement = (Element)userElement.selectSingleNode("email");
                    String userName = userNameElement.getText();
                    if (logger.isDebugEnabled()) {
                        logger.info((Object)("userName:" + userName));
                    }
                    String firstName = firstNameElement.getText();
                    String lastName = lastNameElement.getText();
                    String email = emailElement.getText();
                    HashMap<String, String> metaMap = new HashMap<String, String>();
                    Element metaElement = (Element)document.selectSingleNode("/user/meta");
                    List metaChildNodes = metaElement.elements();
                    for (Element valueElement : metaChildNodes) {
                        String name = valueElement.getName();
                        String value = valueElement.getText();
                        metaMap.put(name, value);
                    }
                    ArrayList<InfoGlueRole> roles = new ArrayList<InfoGlueRole>();
                    ArrayList<InfoGlueGroup> groups = new ArrayList<InfoGlueGroup>();
                    List rolesElementList = userElement.selectNodes("roles/role");
                    for (Element roleElement : rolesElementList) {
                        String name;
                        Element nameElement = (Element)roleElement.selectSingleNode("name");
                        Element displayNameElement = (Element)roleElement.selectSingleNode("displayName");
                        Element descriptionElement = (Element)roleElement.selectSingleNode("description");
                        String displayName = name = nameElement.getText();
                        if (displayNameElement != null && !displayNameElement.getText().equals("")) {
                            displayName = displayNameElement.getText();
                        }
                        String description = "No description";
                        if (descriptionElement != null && !descriptionElement.getText().equals("")) {
                            description = descriptionElement.getText();
                        }
                        InfoGlueRole infoglueRole = new InfoGlueRole(name, displayName, description, this);
                        roles.add(infoglueRole);
                        List groupsElementList = roleElement.selectNodes("groups/group");
                        for (Element groupElement : groupsElementList) {
                            String groupName;
                            Element groupNameElement = (Element)groupElement.selectSingleNode("name");
                            Element groupDisplayNameElement = (Element)groupElement.selectSingleNode("displayName");
                            Element groupDescriptionElement = (Element)groupElement.selectSingleNode("description");
                            String groupDisplayName = groupName = nameElement.getText();
                            if (groupDisplayNameElement != null && !groupDisplayNameElement.getText().equals("")) {
                                groupDisplayName = groupDisplayNameElement.getText();
                            }
                            String groupDescription = "No description";
                            if (groupDescriptionElement != null && !groupDescriptionElement.getText().equals("")) {
                                groupDescription = groupDescriptionElement.getText();
                            }
                            InfoGlueGroup infoglueGroup = new InfoGlueGroup(groupName, groupDisplayName, groupDescription, this);
                            groups.add(infoglueGroup);
                        }
                    }
                    List groupsElementList = userElement.selectNodes("groups/group");
                    for (Element groupElement : groupsElementList) {
                        String name;
                        Element nameElement = (Element)groupElement.selectSingleNode("name");
                        Element displayNameElement = (Element)groupElement.selectSingleNode("displayName");
                        Element descriptionElement = (Element)groupElement.selectSingleNode("description");
                        String displayName = name = nameElement.getText();
                        if (displayNameElement != null && !displayNameElement.getText().equals("")) {
                            displayName = displayNameElement.getText();
                        }
                        String description = "No description";
                        if (descriptionElement != null && !descriptionElement.getText().equals("")) {
                            description = descriptionElement.getText();
                        }
                        InfoGlueGroup infoglueGroup = new InfoGlueGroup(name, displayName, description, this);
                        groups.add(infoglueGroup);
                    }
                    InfoGluePrincipal infogluePrincipal = new InfoGluePrincipal(userName, firstName, lastName, email, roles, groups, false, this);
                    users.add(infogluePrincipal);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return users;
    }

    public List getFilteredUsers(String firstName, String lastName, String userName, String email, String[] roleIds) throws SystemException, Bug {
        ArrayList users = new ArrayList();
        return users;
    }

    public List getUsers(String roleName) throws Exception {
        return this.getRoleUsers(roleName);
    }

    public List getRoleUsers(String roleName) throws Exception {
        ArrayList<InfoGluePrincipal> users = new ArrayList<InfoGluePrincipal>();
        List allUsers = this.getUsers();
        for (InfoGluePrincipal userCandidate : allUsers) {
            if (!userCandidate.getRoles().contains(this.getAuthorizedInfoGlueRole(roleName))) continue;
            users.add(userCandidate);
        }
        return users;
    }

    public Properties getExtraProperties() {
        return this.extraProperties;
    }

    public void setExtraProperties(Properties properties) {
        this.extraProperties = properties;
    }

    public void setTransactionObject(Object transactionObject) {
    }

    public Object getTransactionObject() {
        return null;
    }

    public List getGroups() throws Exception {
        String key;
        ArrayList<InfoGlueGroup> groups;
        logger.info((Object)"getGroups start....");
        String groupCacheTimeout = this.extraProperties.getProperty("groupCacheTimeout", "1800");
        String authorizerIndex = this.extraProperties.getProperty("authorizerIndex");
        if (authorizerIndex == null) {
            authorizerIndex = "";
        }
        if ((groups = (ArrayList<InfoGlueGroup>)CacheController.getCachedObjectFromAdvancedCache("JNDIAuthorizationCache", key = "allGroups" + authorizerIndex, new Integer(groupCacheTimeout))) != null) {
            return groups;
        }
        groups = new ArrayList<InfoGlueGroup>();
        String xml = FileHelper.getFileAsString(new File("c:\\temp\\groups.xml"));
        if (logger.isDebugEnabled()) {
            logger.info((Object)("Groups xml:" + xml));
        }
        Document document = domHelper.getDocument(xml);
        List groupNodes = document.selectNodes("/groups/group");
        for (Element groupElement : groupNodes) {
            String name;
            Element nameElement = (Element)groupElement.selectSingleNode("name");
            Element displayNameElement = (Element)groupElement.selectSingleNode("displayName");
            Element descriptionElement = (Element)groupElement.selectSingleNode("description");
            String displayName = name = nameElement.getText();
            if (displayNameElement != null && !displayNameElement.getText().equals("")) {
                displayName = displayNameElement.getText();
            }
            String description = "No description";
            if (descriptionElement != null && !descriptionElement.getText().equals("")) {
                description = descriptionElement.getText();
            }
            InfoGlueGroup infoglueGroup = new InfoGlueGroup(name, displayName, description, this);
            groups.add(infoglueGroup);
        }
        if (groups != null) {
            CacheController.cacheObjectInAdvancedCache("JNDIAuthorizationCache", key, groups, null, false);
        }
        return groups;
    }

    public List getGroupUsers(String groupName) throws Exception {
        ArrayList<InfoGluePrincipal> users = new ArrayList<InfoGluePrincipal>();
        List allUsers = this.getUsers();
        for (InfoGluePrincipal userCandidate : allUsers) {
            if (!userCandidate.getGroups().contains(this.getAuthorizedInfoGlueGroup(groupName))) continue;
            users.add(userCandidate);
        }
        return users;
    }

    public void createInfoGluePrincipal(SystemUserVO systemUserVO) throws Exception {
        throw new SystemException("The WebService Authorization module does not support creation of users yet...");
    }

    public void updateInfoGluePrincipalPassword(String userName) throws Exception {
        throw new SystemException("The WebService Authorization module does not support updates of users yet...");
    }

    public void updateInfoGlueAnonymousPrincipalPassword() throws Exception {
        throw new SystemException("The WebService Authorization module does not support updates of user password yet....");
    }

    public void updateInfoGluePrincipalPassword(String userName, String oldPassword, String newPassword) throws Exception {
        throw new SystemException("The WebService Authorization module does not support updates of user password yet...");
    }

    public void deleteInfoGluePrincipal(String userName) throws Exception {
        throw new SystemException("The WebService Authorization module does not support deletion of users yet...");
    }

    public void createInfoGlueRole(RoleVO roleVO) throws Exception {
        throw new SystemException("The WebService Authorization module does not support creation of users yet...");
    }

    public void updateInfoGlueRole(RoleVO roleVO, String[] userNames) throws Exception {
    }

    public void deleteInfoGlueRole(String roleName) throws Exception {
        throw new SystemException("The WebService Authorization module does not support deletion of roles yet...");
    }

    public void updateInfoGluePrincipal(SystemUserVO systemUserVO, String[] roleNames, String[] groupNames) throws Exception {
    }

    public void createInfoGlueGroup(GroupVO groupVO) throws Exception {
        throw new SystemException("The WebService Authorization module does not support creation of groups yet...");
    }

    public void updateInfoGlueGroup(GroupVO roleVO, String[] userNames) throws Exception {
    }

    public void deleteInfoGlueGroup(String groupName) throws Exception {
        throw new SystemException("The WebService Authorization module does not support deletion of groups yet...");
    }
}

