/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.security;

import java.security.Principal;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.AuthenticationModule;
import org.infoglue.cms.security.InfoGlueAuthenticationFilter;
import org.infoglue.cms.security.InfoGlueBasicAuthenticationModule;
import org.infoglue.cms.security.JNDIBasicAuthenticationModule;

public class CombinedJNDIBasicAuthenticationModule
extends JNDIBasicAuthenticationModule {
    private static final Logger logger = Logger.getLogger((String)CombinedJNDIBasicAuthenticationModule.class.getName());

    public static AuthenticationModule getFallbackAuthenticationModule(Object transactionObject, String successLoginUrl) throws SystemException {
        InfoGlueBasicAuthenticationModule authenticationModule = null;
        try {
            String authorizerClass = InfoGlueAuthenticationFilter.authorizerClass;
            String invalidLoginUrl = InfoGlueAuthenticationFilter.invalidLoginUrl;
            String loginUrl = InfoGlueAuthenticationFilter.loginUrl;
            String logoutUrl = InfoGlueAuthenticationFilter.logoutUrl;
            String serverName = InfoGlueAuthenticationFilter.serverName;
            Properties extraProperties = InfoGlueAuthenticationFilter.extraProperties;
            String casRenew = InfoGlueAuthenticationFilter.casRenew;
            String casServiceUrl = InfoGlueAuthenticationFilter.casServiceUrl;
            String casValidateUrl = InfoGlueAuthenticationFilter.casValidateUrl;
            String casProxyValidateUrl = InfoGlueAuthenticationFilter.casProxyValidateUrl;
            String casLogoutUrl = InfoGlueAuthenticationFilter.casLogoutUrl;
            authenticationModule = new InfoGlueBasicAuthenticationModule();
            ((AuthenticationModule)authenticationModule).setAuthenticatorClass(InfoGlueBasicAuthenticationModule.class.getName());
            ((AuthenticationModule)authenticationModule).setAuthorizerClass(authorizerClass);
            ((AuthenticationModule)authenticationModule).setInvalidLoginUrl(invalidLoginUrl);
            ((AuthenticationModule)authenticationModule).setLoginUrl(loginUrl);
            ((AuthenticationModule)authenticationModule).setLogoutUrl(logoutUrl);
            ((AuthenticationModule)authenticationModule).setServerName(serverName);
            ((AuthenticationModule)authenticationModule).setExtraProperties(extraProperties);
            ((AuthenticationModule)authenticationModule).setCasRenew(casRenew);
            if (successLoginUrl != null && successLoginUrl.length() > 0) {
                int index = successLoginUrl.indexOf("&ticket=");
                if (index > -1) {
                    successLoginUrl = successLoginUrl.substring(0, index);
                }
                logger.info((Object)("successLoginUrl:" + successLoginUrl));
                ((AuthenticationModule)authenticationModule).setCasServiceUrl(successLoginUrl);
                ((AuthenticationModule)authenticationModule).setSuccessLoginUrl(successLoginUrl);
            } else {
                ((AuthenticationModule)authenticationModule).setCasServiceUrl(casServiceUrl);
            }
            ((AuthenticationModule)authenticationModule).setCasValidateUrl(casValidateUrl);
            ((AuthenticationModule)authenticationModule).setCasProxyValidateUrl(casProxyValidateUrl);
            ((AuthenticationModule)authenticationModule).setCasLogoutUrl(casLogoutUrl);
            ((AuthenticationModule)authenticationModule).setTransactionObject(transactionObject);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to get an authenticationModule:" + e), (Throwable)e);
            throw new SystemException("An error occurred when we tried to get an authenticationModule: " + e.getMessage(), e);
        }
        return authenticationModule;
    }

    public String authenticateUser(HttpServletRequest request, HttpServletResponse response, FilterChain fc) throws Exception {
        String authenticatedUserName = null;
        try {
            logger.info((Object)"authenticateUser 1");
            request.setAttribute("disableRedirect", (Object)"true");
            authenticatedUserName = super.authenticateUser(request, response, fc);
            logger.info((Object)("authenticatedUserName from JNDI:" + authenticatedUserName));
            if (authenticatedUserName == null) {
                authenticatedUserName = CombinedJNDIBasicAuthenticationModule.getFallbackAuthenticationModule(null, null).authenticateUser(request, response, fc);
                logger.info((Object)("authenticatedUserName from BASIC:" + authenticatedUserName));
            }
        }
        catch (Exception e) {
            logger.info((Object)"NO authenticatedUserName from JNDI");
            authenticatedUserName = CombinedJNDIBasicAuthenticationModule.getFallbackAuthenticationModule(null, null).authenticateUser(request, response, fc);
            logger.info((Object)("authenticatedUserName from BASIC:" + authenticatedUserName));
        }
        return authenticatedUserName;
    }

    public String authenticateUser(Map request) throws Exception {
        String authenticatedUserName = null;
        try {
            logger.info((Object)"authenticateUser 2");
            request.put("disableRedirect", "true");
            authenticatedUserName = super.authenticateUser(request);
            logger.info((Object)("authenticatedUserName from JNDI:" + authenticatedUserName));
            if (authenticatedUserName == null) {
                authenticatedUserName = CombinedJNDIBasicAuthenticationModule.getFallbackAuthenticationModule(null, null).authenticateUser(request);
                logger.info((Object)("authenticatedUserName from BASIC:" + authenticatedUserName));
            }
        }
        catch (Exception e) {
            logger.info((Object)"NO authenticatedUserName from JNDI");
            authenticatedUserName = CombinedJNDIBasicAuthenticationModule.getFallbackAuthenticationModule(null, null).authenticateUser(request);
            logger.info((Object)("authenticatedUserName from BASIC:" + authenticatedUserName));
        }
        return authenticatedUserName;
    }

    public String getLoginDialogUrl(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.getLoginDialogUrl(request, response);
    }

    public Principal loginUser(HttpServletRequest request, HttpServletResponse response, Map status) throws Exception {
        return null;
    }

    public boolean logoutUser(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return false;
    }
}

