/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.entities.management.GroupVO;
import org.infoglue.cms.entities.management.RoleVO;
import org.infoglue.cms.entities.management.SystemUserVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.AuthorizationModule;
import org.infoglue.cms.security.InfoGlueBasicAuthorizationModule;
import org.infoglue.cms.security.InfoGlueGroup;
import org.infoglue.cms.security.InfoGlueJDBCAuthorizationModule;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.InfoGlueRole;
import org.infoglue.cms.util.CmsPropertyHandler;

public class CombinedJDBCBasicAuthorizationModule
implements AuthorizationModule,
Serializable {
    private static final Logger logger = Logger.getLogger((String)CombinedJDBCBasicAuthorizationModule.class.getName());
    protected Properties extraProperties = null;
    private Database transactionObject = null;
    private AuthorizationModule mainAuthorizationModule = null;
    private AuthorizationModule authorizationModule = null;

    private AuthorizationModule getMainAuthorizationModule() throws SystemException {
        try {
            logger.info((Object)("InfoGlueAuthenticationFilter.authorizerClass:" + InfoGlueJDBCAuthorizationModule.class.getName()));
            this.authorizationModule = (AuthorizationModule)Class.forName(InfoGlueJDBCAuthorizationModule.class.getName()).newInstance();
            logger.info((Object)("authorizationModule:" + this.authorizationModule));
            this.authorizationModule.setExtraProperties(this.extraProperties);
            this.authorizationModule.setTransactionObject(this.getTransactionObject());
        }
        catch (Exception e) {
            logger.error((Object)("There was an error initializing the authorizerClass:" + e.getMessage()), (Throwable)e);
            throw new SystemException("There was an error initializing the authorizerClass:" + e.getMessage(), e);
        }
        return this.authorizationModule;
    }

    private AuthorizationModule getFallbackAuthorizationModule() throws SystemException {
        try {
            logger.info((Object)("InfoGlueAuthenticationFilter.authorizerClass:" + InfoGlueBasicAuthorizationModule.class.getName()));
            this.authorizationModule = (AuthorizationModule)Class.forName(InfoGlueBasicAuthorizationModule.class.getName()).newInstance();
            logger.info((Object)("authorizationModule:" + this.authorizationModule));
            this.authorizationModule.setExtraProperties(this.extraProperties);
            this.authorizationModule.setTransactionObject(this.getTransactionObject());
        }
        catch (Exception e) {
            logger.error((Object)("There was an error initializing the authorizerClass:" + e.getMessage()), (Throwable)e);
            throw new SystemException("There was an error initializing the authorizerClass:" + e.getMessage(), e);
        }
        return this.authorizationModule;
    }

    public InfoGluePrincipal getAuthorizedInfoGluePrincipal(String userName) throws Exception {
        InfoGluePrincipal infogluePrincipal = null;
        try {
            infogluePrincipal = this.getMainAuthorizationModule().getAuthorizedInfoGluePrincipal(userName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (infogluePrincipal == null) {
            infogluePrincipal = this.getFallbackAuthorizationModule().getAuthorizedInfoGluePrincipal(userName);
        }
        return infogluePrincipal;
    }

    public InfoGlueRole getAuthorizedInfoGlueRole(String roleName) throws Exception {
        InfoGlueRole role = null;
        try {
            role = this.getMainAuthorizationModule().getAuthorizedInfoGlueRole(roleName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (role == null) {
            role = this.getFallbackAuthorizationModule().getAuthorizedInfoGlueRole(roleName);
        }
        return role;
    }

    public InfoGlueGroup getAuthorizedInfoGlueGroup(String groupName) throws Exception {
        InfoGlueGroup group = null;
        try {
            group = this.getMainAuthorizationModule().getAuthorizedInfoGlueGroup(groupName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (group == null) {
            group = this.getFallbackAuthorizationModule().getAuthorizedInfoGlueGroup(groupName);
        }
        return group;
    }

    public List authorizeUser(String userName) throws Exception {
        ArrayList roles = new ArrayList();
        try {
            roles.addAll(this.getMainAuthorizationModule().authorizeUser(userName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            roles.addAll(this.getFallbackAuthorizationModule().authorizeUser(userName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return roles;
    }

    public List getRoles() throws Exception {
        ArrayList roles = new ArrayList();
        try {
            roles.addAll(this.getMainAuthorizationModule().getRoles());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            roles.addAll(this.getFallbackAuthorizationModule().getRoles());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return roles;
    }

    public List getGroups() throws Exception {
        ArrayList groups = new ArrayList();
        try {
            groups.addAll(this.getMainAuthorizationModule().getGroups());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            groups.addAll(this.getFallbackAuthorizationModule().getGroups());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return groups;
    }

    public List getUsers() throws Exception {
        ArrayList users = new ArrayList();
        try {
            users.addAll(this.getMainAuthorizationModule().getUsers());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            users.addAll(this.getFallbackAuthorizationModule().getUsers());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return users;
    }

    public List getUsers(String roleName) throws Exception {
        return this.getRoleUsers(roleName);
    }

    public List getRoleUsers(String roleName) throws Exception {
        ArrayList users = new ArrayList();
        InfoGlueRole role = this.getAuthorizedInfoGlueRole(roleName);
        users.addAll(role.getAutorizationModule().getRoleUsers(roleName));
        return users;
    }

    public List getGroupUsers(String groupName) throws Exception {
        ArrayList users = new ArrayList();
        InfoGlueGroup group = this.getAuthorizedInfoGlueGroup(groupName);
        users.addAll(group.getAutorizationModule().getGroupUsers(groupName));
        return users;
    }

    public void createInfoGluePrincipal(SystemUserVO systemUserVO) throws Exception {
        this.getFallbackAuthorizationModule().createInfoGluePrincipal(systemUserVO);
    }

    public void updateInfoGluePrincipal(SystemUserVO systemUserVO, String[] roleNames, String[] groupNames) throws Exception {
        InfoGluePrincipal principal = this.getAuthorizedInfoGluePrincipal(systemUserVO.getUserName());
        principal.getAutorizationModule().updateInfoGluePrincipal(systemUserVO, roleNames, groupNames);
    }

    public void updateInfoGluePrincipalPassword(String userName) throws Exception {
        InfoGluePrincipal principal = this.getAuthorizedInfoGluePrincipal(userName);
        principal.getAutorizationModule().updateInfoGluePrincipalPassword(userName);
    }

    public void updateInfoGlueAnonymousPrincipalPassword() throws Exception {
        InfoGluePrincipal principal = this.getAuthorizedInfoGluePrincipal(CmsPropertyHandler.getAnonymousUser());
        principal.getAutorizationModule().updateInfoGlueAnonymousPrincipalPassword();
    }

    public void updateInfoGluePrincipalPassword(String userName, String oldPassword, String newPassword) throws Exception {
        InfoGluePrincipal principal = this.getAuthorizedInfoGluePrincipal(userName);
        principal.getAutorizationModule().updateInfoGluePrincipalPassword(userName, oldPassword, newPassword);
    }

    public void deleteInfoGluePrincipal(String userName) throws Exception {
        InfoGluePrincipal principal = this.getAuthorizedInfoGluePrincipal(userName);
        principal.getAutorizationModule().deleteInfoGluePrincipal(userName);
    }

    public void createInfoGlueRole(RoleVO roleVO) throws Exception {
        this.getFallbackAuthorizationModule().createInfoGlueRole(roleVO);
    }

    public void deleteInfoGlueRole(String roleName) throws Exception {
        InfoGlueRole role = this.getAuthorizedInfoGlueRole(roleName);
        role.getAutorizationModule().deleteInfoGlueRole(roleName);
    }

    public void updateInfoGlueRole(RoleVO roleVO, String[] userNames) throws Exception {
        InfoGlueRole role = this.getAuthorizedInfoGlueRole(roleVO.getRoleName());
        role.getAutorizationModule().updateInfoGlueRole(roleVO, userNames);
    }

    public void createInfoGlueGroup(GroupVO groupVO) throws Exception {
        this.getFallbackAuthorizationModule().createInfoGlueGroup(groupVO);
    }

    public void deleteInfoGlueGroup(String groupName) throws Exception {
        InfoGlueGroup group = this.getAuthorizedInfoGlueGroup(groupName);
        group.getAutorizationModule().deleteInfoGlueGroup(groupName);
    }

    public void updateInfoGlueGroup(GroupVO groupVO, String[] userNames) throws Exception {
        InfoGlueGroup group = this.getAuthorizedInfoGlueGroup(groupVO.getGroupName());
        group.getAutorizationModule().updateInfoGlueGroup(groupVO, userNames);
    }

    public boolean getSupportUpdate() {
        return true;
    }

    public boolean getSupportDelete() {
        return true;
    }

    public boolean getSupportCreate() {
        return true;
    }

    public List getFilteredUsers(String firstName, String lastName, String userName, String email, String[] roleIds) throws Exception {
        return null;
    }

    public Properties getExtraProperties() {
        return this.extraProperties;
    }

    public void setExtraProperties(Properties properties) {
        this.extraProperties = properties;
    }

    public void setTransactionObject(Object transactionObject) {
        this.transactionObject = (Database)transactionObject;
    }

    public Object getTransactionObject() {
        return this.transactionObject;
    }
}

