/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.security;

import edu.yale.its.tp.cas.client.ProxyTicketValidator;
import edu.yale.its.tp.cas.client.Util;
import java.net.URLEncoder;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.AuthenticationModule;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;

public class CASBasicAuthenticationModule
extends AuthenticationModule {
    private static final Logger logger = Logger.getLogger((String)CASBasicAuthenticationModule.class.getName());
    private String loginUrl = null;
    private String logoutUrl = null;
    private String invalidLoginUrl = null;
    private String authenticatorClass = null;
    private String authorizerClass = null;
    private String successLoginUrl = null;
    private String serverName = null;
    private String casValidateUrl = null;
    private String casProxyValidateUrl = null;
    private String casServiceUrl = null;
    private String casLogoutUrl = null;
    private String casAuthorizedProxy = null;
    private String casRenew = null;
    private Properties extraProperties = null;

    public String authenticateUser(HttpServletRequest request, HttpServletResponse response, FilterChain fc) throws Exception {
        String authenticatedUserName = null;
        HttpSession session = request.getSession();
        String ticket = request.getParameter("ticket");
        logger.info((Object)("ticket:" + ticket));
        if (ticket == null || ticket.equals("")) {
            if (this.loginUrl == null) {
                throw new ServletException("When InfoGlueFilter protects pages that do not receive a 'userName' parameter, it needs a org.infoglue.cms.security.loginUrl filter parameter");
            }
            String requestURI = request.getRequestURI();
            String queryString = request.getQueryString();
            logger.info((Object)("requestURI:" + requestURI));
            String redirectUrl = "";
            if (CmsPropertyHandler.getApplicationName() == null || CmsPropertyHandler.getApplicationName().equalsIgnoreCase("deliver") || requestURI.indexOf("ViewCMSTool.action") > -1 || requestURI.indexOf("standalone") > -1 || requestURI.indexOf("workflows") > -1 || requestURI.indexOf("ViewDigitalAsset") > -1 || requestURI.indexOf("Editor") > -1 || requestURI.indexOf("binding") > -1 || queryString.indexOf("directView") > -1) {
                redirectUrl = requestURI.indexOf("?") > 0 ? String.valueOf(this.loginUrl) + "&service=" + this.getService(request) + (this.casRenew != null && !this.casRenew.equals("") ? "&renew=" + this.casRenew : "") : String.valueOf(this.loginUrl) + "?service=" + this.getService(request) + (this.casRenew != null && !this.casRenew.equals("") ? "&renew=" + this.casRenew : "");
                logger.info((Object)("redirectUrl 1:" + redirectUrl));
                response.sendRedirect(redirectUrl);
            } else {
                response.sendRedirect("index-cms.html");
            }
            return null;
        }
        authenticatedUserName = this.authenticate(ticket);
        logger.info((Object)("authenticatedUserName:" + authenticatedUserName));
        if (authenticatedUserName == null) {
            String requestURI = request.getRequestURI();
            logger.info((Object)("requestURI:" + requestURI));
            String redirectUrl = "";
            redirectUrl = requestURI.indexOf("?") > 0 ? String.valueOf(this.loginUrl) + "&service=" + this.getService(request) + (this.casRenew != null && !this.casRenew.equals("") ? "&renew=" + this.casRenew : "") : String.valueOf(this.loginUrl) + "?service=" + this.getService(request) + (this.casRenew != null && !this.casRenew.equals("") ? "&renew=" + this.casRenew : "");
            logger.info((Object)("redirectUrl 2:" + redirectUrl));
            response.sendRedirect(redirectUrl);
            return null;
        }
        return authenticatedUserName;
    }

    public String authenticateUser(Map request) throws Exception {
        String authenticatedUserName;
        block7: {
            authenticatedUserName = null;
            String j_userName = (String)request.get("j_username");
            String j_password = (String)request.get("j_password");
            if (j_userName != null && j_password != null) {
                String userName = CmsPropertyHandler.getAdministratorUserName();
                boolean matchesRootPassword = CmsPropertyHandler.getMatchesAdministratorPassword(j_password);
                if (j_userName.equals(userName) && matchesRootPassword) {
                    return j_userName;
                }
                String anonymousUserName = CmsPropertyHandler.getAnonymousUser();
                String anonymousPassword = CmsPropertyHandler.getAnonymousPassword();
                if (j_userName.equals(anonymousUserName) && j_password.equals(anonymousPassword)) {
                    return j_userName;
                }
            }
            String ticket = (String)request.get("ticket");
            logger.info((Object)("ticket:" + ticket));
            if (ticket == null || ticket.equals("")) {
                return null;
            }
            authenticatedUserName = this.authenticate(ticket);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("authenticatedUserName:" + authenticatedUserName));
                try {
                    throw new Exception("CAS was called from authenticateUser:" + authenticatedUserName);
                }
                catch (Exception e) {
                    if (!logger.isInfoEnabled()) break block7;
                    logger.info((Object)("DEBUG:" + e.getMessage()), (Throwable)e);
                }
            }
        }
        return authenticatedUserName;
    }

    public String getSSOUserName(HttpServletRequest request) throws Exception {
        String authenticatedUserName = null;
        String ticket = request.getParameter("ticket");
        logger.info((Object)("ticket:" + ticket));
        if (ticket != null) {
            authenticatedUserName = this.authenticate(ticket);
            logger.info((Object)("authenticatedUserName:" + authenticatedUserName));
        }
        return authenticatedUserName;
    }

    public String getLoginDialogUrl(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String url = null;
        HttpSession session = request.getSession();
        String ticket = request.getParameter("ticket");
        logger.info((Object)("ticket:" + ticket));
        if (ticket == null || ticket.equals("")) {
            if (this.loginUrl == null) {
                throw new ServletException("When InfoGlueFilter protects pages that do not receive a 'userName' parameter, it needs a org.infoglue.cms.security.loginUrl filter parameter");
            }
            String requestURI = request.getRequestURI();
            logger.info((Object)("requestURI:" + requestURI));
            String redirectUrl = "";
            redirectUrl = requestURI.indexOf("?") > 0 ? String.valueOf(this.loginUrl) + "&service=" + this.getService(request) + (this.casRenew != null && !this.casRenew.equals("") ? "&renew=" + this.casRenew : "") : String.valueOf(this.loginUrl) + "?service=" + this.getService(request) + (this.casRenew != null && !this.casRenew.equals("") ? "&renew=" + this.casRenew : "");
            logger.info((Object)("redirectUrl 3:" + redirectUrl));
            return redirectUrl;
        }
        String authenticatedUserName = this.authenticate(ticket);
        logger.info((Object)("authenticatedUserName:" + authenticatedUserName));
        if (authenticatedUserName == null) {
            String requestURI = request.getRequestURI();
            logger.info((Object)("requestURI:" + requestURI));
            String redirectUrl = "";
            redirectUrl = requestURI.indexOf("?") > 0 ? String.valueOf(this.loginUrl) + "&service=" + this.getService(request) + (this.casRenew != null && !this.casRenew.equals("") ? "&renew=" + this.casRenew : "") : String.valueOf(this.loginUrl) + "?service=" + this.getService(request) + (this.casRenew != null && !this.casRenew.equals("") ? "&renew=" + this.casRenew : "");
            logger.info((Object)("redirectUrl 4:" + redirectUrl));
            response.sendRedirect(redirectUrl);
            return redirectUrl;
        }
        return url;
    }

    private String authenticate(String ticket) throws Exception {
        block14: {
            boolean isAuthenticated = false;
            if (logger.isInfoEnabled()) {
                try {
                    throw new Exception("authenticate called with ticket:" + ticket);
                }
                catch (Exception e) {
                    if (!logger.isInfoEnabled()) break block14;
                    logger.info((Object)("DEBUG:" + e.getMessage()), (Throwable)e);
                }
            }
        }
        logger.info((Object)("ticket:" + ticket));
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
                logger.info((Object)"Checking if client is trusted...");
            }

            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }
        }};
        HostnameVerifier hv = new HostnameVerifier(){

            public boolean verify(String urlHostName, SSLSession session) {
                System.out.println("Warning: URL Host: " + urlHostName + " vs. " + session.getPeerHost());
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        String authenticatedUserName = null;
        ProxyTicketValidator pv = new ProxyTicketValidator();
        String encodeValidateUrl = CmsPropertyHandler.getEncodeValidateUrl();
        String encodeCasServiceUrl = CmsPropertyHandler.getEncodeCasServiceUrl();
        if (ticket != null && ticket.substring(0, 2).equals("PT")) {
            if (encodeValidateUrl != null && encodeValidateUrl.equals("true")) {
                this.casProxyValidateUrl = URLEncoder.encode(this.casProxyValidateUrl, "iso-8859-1");
            }
            logger.info((Object)("setting casProxyValidateUrl: " + this.casProxyValidateUrl));
            pv.setCasValidateUrl(this.casProxyValidateUrl);
        } else {
            if (encodeValidateUrl != null && encodeValidateUrl.equals("true")) {
                this.casValidateUrl = URLEncoder.encode(this.casValidateUrl, "iso-8859-1");
            }
            pv.setCasValidateUrl(this.casValidateUrl);
            logger.info((Object)("setting casValidateUrl: " + this.casValidateUrl));
        }
        if (encodeCasServiceUrl != null && encodeCasServiceUrl.equals("true")) {
            this.casServiceUrl = URLEncoder.encode(this.casServiceUrl, "iso-8859-1");
        }
        logger.info((Object)("validating: " + this.casServiceUrl));
        pv.setService(this.casServiceUrl);
        pv.setServiceTicket(ticket);
        try {
            pv.validate();
            String xmlResponse = pv.getResponse();
            logger.info((Object)("xmlResponse:" + xmlResponse));
            if (pv.isAuthenticationSuccesful()) {
                String user = pv.getUser();
                List proxyList = pv.getProxyList();
                authenticatedUserName = pv.getUser();
                logger.info((Object)("The user " + user + " was authenticated successfully."));
            } else {
                String errorCode = pv.getErrorCode();
                String proxyList = pv.getErrorMessage();
            }
            logger.info((Object)("proxies:\n " + pv.getProxyList()));
        }
        catch (Exception e) {
            logger.info((Object)"-------------------------------------------------------------");
            logger.info((Object)("(Johans utskrift)  Felmeddelande: " + e.getMessage()));
            logger.info((Object)("(Johans utskrift)  pv.getCasValidateUrl: " + pv.getCasValidateUrl()));
            logger.info((Object)("(Johans utskrift)  pv.getErrorCode(): " + pv.getErrorCode()));
            logger.info((Object)("(Johans utskrift)  pv.getErrorMessage: " + pv.getErrorMessage()));
            logger.info((Object)("(Johans utskrift)  pv.getPgtIou: " + pv.getPgtIou()));
            logger.info((Object)("(Johans utskrift)  pv.getProxyCallbackUrl: " + pv.getProxyCallbackUrl()));
            logger.info((Object)("(Johans utskrift)  pv.getResponse: " + pv.getResponse()));
            logger.info((Object)("(Johans utskrift)  pv.getUser: " + pv.getUser()));
            logger.info((Object)("(Johans utskrift)  pv.getClass: " + pv.getClass()));
            logger.info((Object)("(Johans utskrift)  pv.getProxyList: " + pv.getProxyList()));
            logger.info((Object)"-------------------------------------------------------------");
            String casResponse = pv.getResponse();
            logger.info((Object)("CAS RESPONSE: " + casResponse.substring(0, 3)));
            String response = casResponse.substring(0, casResponse.indexOf(10));
            String userId = casResponse.substring(casResponse.indexOf(10) + 1);
            if (response.equals("yes")) {
                logger.info((Object)("The user " + userId + " was authenticated successfully against a CAS 1.0 installation"));
                authenticatedUserName = userId.trim();
            }
            if (response.equals("no")) {
                logger.info((Object)("Permission denied for the user " + userId + " against a CAS 1.0 installation"));
            }
            throw e;
        }
        return authenticatedUserName;
    }

    public Principal loginUser(HttpServletRequest request, HttpServletResponse response, Map status) throws SystemException, Exception {
        InfoGluePrincipal principal = null;
        String authenticatedUserName = this.getAuthenticatedUserName(request, response, status);
        if (authenticatedUserName != null && (principal = UserControllerProxy.getController().getUser(authenticatedUserName)) == null) {
            throw new SystemException("The CAS-authenticated user " + authenticatedUserName + " was not located in the authorization system's user database.");
        }
        return principal;
    }

    public boolean logoutUser(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String referer = request.getHeader("Referer");
        String service = this.getService(request);
        if (referer != null && !referer.equals("")) {
            if (referer.lastIndexOf("/") > 0) {
                referer = referer.substring(0, referer.lastIndexOf("/"));
            }
            service = referer;
        }
        response.sendRedirect(String.valueOf(this.getCasLogoutUrl()) + "?service=" + service);
        return true;
    }

    private String getService(HttpServletRequest request) throws ServletException, Exception {
        if (this.serverName == null && this.casServiceUrl == null) {
            throw new ServletException("need one of the following configuration parameters: edu.yale.its.tp.cas.client.filter.serviceUrl or edu.yale.its.tp.cas.client.filter.serverName");
        }
        if (this.casServiceUrl.equals("$currentUrl")) {
            String originalFullURL = this.getCurrentURL(request);
            String referer = request.getHeader("Referer");
            logger.info((Object)("originalFullURL:" + originalFullURL));
            this.casServiceUrl = originalFullURL;
        }
        String returnUrl = "";
        if (this.casServiceUrl != null && this.casServiceUrl.length() > 0) {
            String gateway = (String)request.getAttribute("gateway");
            if (gateway != null) {
                this.casServiceUrl = this.casServiceUrl.indexOf("?") == -1 ? String.valueOf(this.casServiceUrl) + "?skipSSOCheck=true" : String.valueOf(this.casServiceUrl) + "&skipSSOCheck=true";
            }
            returnUrl = URLEncoder.encode(this.casServiceUrl, "UTF-8");
        } else {
            returnUrl = Util.getService((HttpServletRequest)request, (String)this.serverName);
        }
        return returnUrl;
    }

    public String getCurrentURL(HttpServletRequest request) {
        return request.getRequestURL() + (request.getQueryString() == null ? "" : "?" + request.getQueryString());
    }

    public String getAuthenticatorClass() {
        return this.authenticatorClass;
    }

    public void setAuthenticatorClass(String authenticatorClass) {
        this.authenticatorClass = authenticatorClass;
    }

    public String getAuthorizerClass() {
        return this.authorizerClass;
    }

    public void setAuthorizerClass(String authorizerClass) {
        this.authorizerClass = authorizerClass;
    }

    public String getInvalidLoginUrl() {
        return this.invalidLoginUrl;
    }

    public void setInvalidLoginUrl(String invalidLoginUrl) {
        this.invalidLoginUrl = invalidLoginUrl;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public Properties getExtraProperties() {
        return this.extraProperties;
    }

    public void setExtraProperties(Properties properties) {
        this.extraProperties = properties;
    }

    public String getCasRenew() {
        return this.casRenew;
    }

    public void setCasRenew(String casRenew) {
        this.casRenew = casRenew;
    }

    public String getCasServiceUrl() {
        return this.casServiceUrl;
    }

    public void setCasServiceUrl(String casServiceUrl) {
        this.casServiceUrl = casServiceUrl;
    }

    public String getCasValidateUrl() {
        return this.casValidateUrl;
    }

    public void setCasValidateUrl(String casValidateUrl) {
        this.casValidateUrl = casValidateUrl;
    }

    public String getCasProxyValidateUrl() {
        return this.casProxyValidateUrl;
    }

    public void setCasProxyValidateUrl(String casProxyValidateUrl) {
        this.casProxyValidateUrl = casProxyValidateUrl;
    }

    public String getCasLogoutUrl() {
        return this.casLogoutUrl;
    }

    public void setCasLogoutUrl(String casLogoutUrl) {
        this.casLogoutUrl = casLogoutUrl;
    }

    public String getCasAuthorizedProxy() {
        return this.casAuthorizedProxy;
    }

    public void setCasAuthorizedProxy(String casAuthorizedProxy) {
        this.casAuthorizedProxy = casAuthorizedProxy;
    }

    public Object getTransactionObject() {
        return null;
    }

    public void setTransactionObject(Object transactionObject) {
    }

    private String getAuthenticatedUserName(HttpServletRequest request, HttpServletResponse response, Map status) throws Exception {
        String authenticatedUserName = null;
        String ticket = request.getParameter("ticket");
        String gateway = (String)request.getAttribute("gateway");
        logger.info((Object)("ticket:" + ticket));
        logger.info((Object)("gateway:" + gateway));
        if (ticket == null || ticket.equals("")) {
            if (this.loginUrl == null) {
                throw new ServletException("When InfoGlueFilter protects pages that do not receive a 'userName' parameter, it needs a org.infoglue.cms.security.loginUrl filter parameter");
            }
            String requestURI = request.getRequestURI();
            logger.info((Object)("requestURI:" + requestURI));
            String redirectUrl = "";
            redirectUrl = requestURI.indexOf("?") > 0 ? String.valueOf(this.loginUrl) + "&service=" + this.getService(request) + (this.casRenew != null && !this.casRenew.equals("") ? "&renew=" + this.casRenew : "") + (gateway != null && !gateway.equals("") ? "&gateway=" + gateway : "") : String.valueOf(this.loginUrl) + "?service=" + this.getService(request) + (this.casRenew != null && !this.casRenew.equals("") ? "&renew=" + this.casRenew : "") + (gateway != null && !gateway.equals("") ? "&gateway=" + gateway : "");
            logger.info((Object)("redirectUrl 6:" + redirectUrl));
            response.sendRedirect(redirectUrl);
            status.put("redirected", new Boolean(true));
            return null;
        }
        authenticatedUserName = this.authenticate(ticket);
        logger.info((Object)("authenticatedUserName:" + authenticatedUserName));
        if (authenticatedUserName == null) {
            String requestURI = request.getRequestURI();
            logger.info((Object)("requestURI:" + requestURI));
            String redirectUrl = "";
            redirectUrl = requestURI.indexOf("?") > 0 ? String.valueOf(this.loginUrl) + "&service=" + this.getService(request) + (this.casRenew != null && !this.casRenew.equals("") ? "&renew=" + this.casRenew : (gateway != null && !gateway.equals("") ? "&gateway=" + gateway : "")) : String.valueOf(this.loginUrl) + "?service=" + this.getService(request) + (this.casRenew != null && !this.casRenew.equals("") ? "&renew=" + this.casRenew : (gateway != null && !gateway.equals("") ? "&gateway=" + gateway : ""));
            logger.info((Object)("redirectUrl 7:" + redirectUrl));
            response.sendRedirect(redirectUrl);
            status.put("redirected", new Boolean(true));
            return null;
        }
        return authenticatedUserName;
    }

    public String getSuccessLoginUrl() {
        return this.successLoginUrl;
    }

    public void setSuccessLoginUrl(String successLoginUrl) {
        this.successLoginUrl = successLoginUrl;
    }

    public boolean enforceJ2EEContainerPrincipal() {
        return false;
    }
}

