/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.security;

import java.security.AccessControlException;

public class BasicMethodAccessManager {
    public static final void checkAccessToCall(String[] allowedClassNames, String message) {
        Throwable t = new Throwable();
        StackTraceElement[] stackElements = t.getStackTrace();
        StackTraceElement calledElement = stackElements[1];
        String calledClassName = calledElement.getClassName();
        String calledMethodName = calledElement.getMethodName();
        StackTraceElement callingElement = stackElements[2];
        String className = callingElement.getClassName();
        String methodName = callingElement.getMethodName();
        boolean acceptedCall = false;
        int i = 0;
        while (i < allowedClassNames.length) {
            String allowedClassName = allowedClassNames[i];
            if (callingElement.getClassName().equals(allowedClassName)) {
                acceptedCall = true;
            }
            ++i;
        }
        if (!acceptedCall) {
            throw new AccessControlException("An access control violation was attempted. Call from " + className + "." + methodName + " was made to " + calledClassName + "." + calledMethodName + "." + message);
        }
    }
}

