/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.security;

import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupController;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.RoleController;
import org.infoglue.cms.controllers.kernel.impl.simple.RoleControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.SystemUserController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.entities.management.GroupVO;
import org.infoglue.cms.entities.management.RoleVO;
import org.infoglue.cms.entities.management.SystemUserVO;
import org.infoglue.cms.security.InfoGlueGroup;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.InfoGlueRole;

public class AuthorizationRefreshHelper {
    private static final Logger logger = Logger.getLogger((String)AuthorizationRefreshHelper.class.getName());
    private static final RoleControllerProxy roleControllerProxy = RoleControllerProxy.getController();
    private static final RoleController roleController = RoleController.getController();
    private static final GroupControllerProxy groupControllerProxy = GroupControllerProxy.getController();
    private static final GroupController groupController = GroupController.getController();
    private static final UserControllerProxy userControllerProxy = UserControllerProxy.getController();
    private static final SystemUserController userController = SystemUserController.getController();

    public void updateCopiedRoles() {
        try {
            List currentRoles = roleControllerProxy.getAllRoles();
            System.out.println("currentRoles:" + currentRoles.size());
            List currentLocalRoles = RoleController.getController().getRoleVOList();
            System.out.println("currentLocalRoles:" + currentLocalRoles.size());
            for (InfoGlueRole role : currentRoles) {
                RoleVO localRoleVO = this.getRoleInLocalList(role, currentLocalRoles);
                if (localRoleVO == null) {
                    System.out.println("Creating local role with:" + role);
                    RoleVO newLocalRoleVO = new RoleVO();
                    newLocalRoleVO.setRoleName(role.getName());
                    newLocalRoleVO.setDescription(role.getDescription());
                    roleController.create(newLocalRoleVO);
                    continue;
                }
                System.out.println("Updating local role with:" + role);
                localRoleVO.setDescription(role.getDescription());
                roleController.update(localRoleVO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateCopiedGroups() {
        try {
            List currentGroups = groupControllerProxy.getAllGroups();
            System.out.println("currentGroups:" + currentGroups.size());
            List currentLocalGroups = GroupController.getController().getGroupVOList();
            System.out.println("currentLocalGroups:" + currentLocalGroups.size());
            for (InfoGlueGroup group : currentGroups) {
                GroupVO localGroupVO = this.getGroupInLocalList(group, currentLocalGroups);
                if (localGroupVO == null) {
                    System.out.println("Creating local group with:" + group);
                    GroupVO newLocalGroupVO = new GroupVO();
                    newLocalGroupVO.setGroupName(group.getName());
                    newLocalGroupVO.setDescription(group.getDescription());
                    groupController.create(newLocalGroupVO);
                    continue;
                }
                System.out.println("Updating local group with:" + group);
                localGroupVO.setDescription(group.getDescription());
                groupController.update(localGroupVO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateCopiedUsers() {
        try {
            List currentUsers = userControllerProxy.getAllUsers();
            System.out.println("currentUsers:" + currentUsers.size());
            List currentLocalUsers = SystemUserController.getController().getSystemUserVOList();
            System.out.println("currentLocalUsers:" + currentLocalUsers.size());
            for (InfoGluePrincipal principal : currentUsers) {
                SystemUserVO localSystemUserVO = this.getSystemUserInLocalList(principal, currentLocalUsers);
                if (localSystemUserVO == null) {
                    System.out.println("Creating local system user with:" + principal);
                    SystemUserVO newLocalSystemUserVO = new SystemUserVO();
                    newLocalSystemUserVO.setUserName(principal.getName());
                    newLocalSystemUserVO.setFirstName(principal.getFirstName());
                    newLocalSystemUserVO.setLastName(principal.getLastName());
                    newLocalSystemUserVO.setEmail(principal.getEmail());
                    newLocalSystemUserVO.setPassword("HUHUHU????");
                    userController.create(newLocalSystemUserVO);
                } else {
                    System.out.println("Updating local system user with:" + principal);
                    localSystemUserVO.setFirstName(principal.getFirstName());
                    localSystemUserVO.setLastName(principal.getLastName());
                    localSystemUserVO.setEmail(principal.getEmail());
                }
                System.out.println("Auth module:" + principal.getAutorizationModule());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private RoleVO getRoleInLocalList(InfoGlueRole role, List currentLocalRoles) {
        RoleVO roleVO = null;
        for (RoleVO localRoleVO : currentLocalRoles) {
            if (!localRoleVO.getRoleName().equals(role.getName())) continue;
            roleVO = localRoleVO;
        }
        return roleVO;
    }

    private GroupVO getGroupInLocalList(InfoGlueGroup group, List currentLocalGroups) {
        GroupVO groupVO = null;
        for (GroupVO localGroupVO : currentLocalGroups) {
            if (!localGroupVO.getGroupName().equals(group.getName())) continue;
            groupVO = localGroupVO;
        }
        return groupVO;
    }

    private SystemUserVO getSystemUserInLocalList(InfoGluePrincipal principal, List currentLocalSystemUsers) {
        SystemUserVO systemUserVO = null;
        for (SystemUserVO localSystemUserVO : currentLocalSystemUsers) {
            if (!localSystemUserVO.getUserName().equals(principal.getName())) continue;
            systemUserVO = localSystemUserVO;
        }
        return systemUserVO;
    }
}

