/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.security;

import java.security.Principal;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGlueAuthenticationFilter;

public abstract class AuthenticationModule {
    private static final Logger logger = Logger.getLogger((String)AuthenticationModule.class.getName());

    public static AuthenticationModule getAuthenticationModule(Object transactionObject, String successLoginUrl) throws SystemException {
        AuthenticationModule authenticationModule = null;
        try {
            String authenticatorClass = InfoGlueAuthenticationFilter.authenticatorClass;
            String authorizerClass = InfoGlueAuthenticationFilter.authorizerClass;
            String invalidLoginUrl = InfoGlueAuthenticationFilter.invalidLoginUrl;
            String loginUrl = InfoGlueAuthenticationFilter.loginUrl;
            String logoutUrl = InfoGlueAuthenticationFilter.logoutUrl;
            String serverName = InfoGlueAuthenticationFilter.serverName;
            Properties extraProperties = InfoGlueAuthenticationFilter.extraProperties;
            String casRenew = InfoGlueAuthenticationFilter.casRenew;
            String casServiceUrl = InfoGlueAuthenticationFilter.casServiceUrl;
            String casValidateUrl = InfoGlueAuthenticationFilter.casValidateUrl;
            String casProxyValidateUrl = InfoGlueAuthenticationFilter.casProxyValidateUrl;
            String casLogoutUrl = InfoGlueAuthenticationFilter.casLogoutUrl;
            authenticationModule = (AuthenticationModule)Class.forName(authenticatorClass).newInstance();
            authenticationModule.setAuthenticatorClass(authenticatorClass);
            authenticationModule.setAuthorizerClass(authorizerClass);
            authenticationModule.setInvalidLoginUrl(invalidLoginUrl);
            authenticationModule.setLoginUrl(loginUrl);
            authenticationModule.setLogoutUrl(logoutUrl);
            authenticationModule.setServerName(serverName);
            authenticationModule.setExtraProperties(extraProperties);
            authenticationModule.setCasRenew(casRenew);
            if (successLoginUrl != null && successLoginUrl.length() > 0) {
                int index2;
                int index = successLoginUrl.indexOf("&ticket=");
                if (index > -1) {
                    successLoginUrl = successLoginUrl.substring(0, index);
                }
                if ((index2 = successLoginUrl.indexOf("?ticket=")) > -1) {
                    successLoginUrl = successLoginUrl.substring(0, index2);
                }
                logger.info((Object)("successLoginUrl:" + successLoginUrl));
                authenticationModule.setCasServiceUrl(successLoginUrl);
                authenticationModule.setSuccessLoginUrl(successLoginUrl);
            } else {
                authenticationModule.setCasServiceUrl(casServiceUrl);
            }
            authenticationModule.setCasValidateUrl(casValidateUrl);
            authenticationModule.setCasProxyValidateUrl(casProxyValidateUrl);
            authenticationModule.setCasLogoutUrl(casLogoutUrl);
            authenticationModule.setTransactionObject(transactionObject);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to get an authenticationModule:" + e), (Throwable)e);
            throw new SystemException("An error occurred when we tried to get an authenticationModule: " + e.getMessage(), e);
        }
        return authenticationModule;
    }

    public abstract String authenticateUser(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws Exception;

    public abstract String authenticateUser(Map var1) throws Exception;

    public abstract Principal loginUser(HttpServletRequest var1, HttpServletResponse var2, Map var3) throws Exception;

    public abstract boolean logoutUser(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    public abstract String getLoginDialogUrl(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    public abstract String getAuthenticatorClass();

    public abstract void setAuthenticatorClass(String var1);

    public abstract String getAuthorizerClass();

    public abstract void setAuthorizerClass(String var1);

    public abstract String getInvalidLoginUrl();

    public abstract void setInvalidLoginUrl(String var1);

    public abstract String getSSOUserName(HttpServletRequest var1) throws Exception;

    public abstract String getLoginUrl();

    public abstract void setLoginUrl(String var1);

    public abstract String getSuccessLoginUrl();

    public abstract void setSuccessLoginUrl(String var1);

    public abstract String getLogoutUrl();

    public abstract void setLogoutUrl(String var1);

    public abstract String getServerName();

    public abstract void setServerName(String var1);

    public abstract Properties getExtraProperties();

    public abstract void setExtraProperties(Properties var1);

    public abstract String getCasRenew();

    public abstract void setCasRenew(String var1);

    public abstract String getCasServiceUrl();

    public abstract void setCasServiceUrl(String var1);

    public abstract String getCasValidateUrl();

    public abstract void setCasValidateUrl(String var1);

    public abstract String getCasProxyValidateUrl();

    public abstract void setCasProxyValidateUrl(String var1);

    public abstract String getCasLogoutUrl();

    public abstract void setCasLogoutUrl(String var1);

    public abstract String getCasAuthorizedProxy();

    public abstract void setCasAuthorizedProxy(String var1);

    public abstract Object getTransactionObject();

    public abstract void setTransactionObject(Object var1);

    public abstract boolean enforceJ2EEContainerPrincipal();
}

