/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.plugins.opentree;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import netscape.javascript.JSObject;
import org.infoglue.cms.plugins.opentree.CMSNode;
import org.infoglue.cms.plugins.opentree.CMSTreeListener;
import org.infoglue.cms.plugins.opentree.Controller;
import org.infoglue.cms.plugins.opentree.NodeTreeSelectionListener;

public class OpenTree
extends JApplet {
    private Icon customOpenIcon = null;
    private Icon customClosedIcon = null;
    private Icon customLeafIcon = null;
    private TreeNode rootNode;
    protected JTree nodeTree;
    private JScrollPane sp;
    private Controller controller;
    private Integer repositoryId;
    private String entityName;
    private String hideLeafs;
    private Integer currentNodeId;

    public void init() {
        String serverAddress = null;
        Color bgColor = null;
        try {
            int rColor = Integer.parseInt(this.getParameter("bgColorR"));
            int gColor = Integer.parseInt(this.getParameter("bgColorG"));
            int bColor = Integer.parseInt(this.getParameter("bgColorB"));
            bgColor = new Color(rColor, gColor, bColor);
            this.entityName = this.getParameter("entityName");
            this.repositoryId = new Integer(this.getParameter("repositoryId"));
            this.hideLeafs = this.getParameter("hideLeafs");
            URL codeBase = this.getCodeBase();
            String applicationPath = this.getDocumentBase().getPath().substring(0, this.getDocumentBase().getPath().lastIndexOf("/"));
            System.out.println("applicationPath:" + applicationPath);
            serverAddress = String.valueOf(codeBase.getProtocol()) + "://" + codeBase.getHost() + ":" + codeBase.getPort() + applicationPath + "/" + this.entityName + "TreeService";
            String imageBaseURL = String.valueOf(codeBase.getProtocol()) + "://" + codeBase.getHost() + ":" + codeBase.getPort() + applicationPath + "/";
            String folderOpenImage = String.valueOf(imageBaseURL) + "images/" + this.entityName + "folderOpen.gif";
            String folderClosedImage = String.valueOf(imageBaseURL) + "images/" + this.entityName + "folderClosed.gif";
            String documentImage = String.valueOf(imageBaseURL) + "images/" + this.entityName + "document.gif";
            this.customOpenIcon = new ImageIcon(new URL(folderOpenImage));
            this.customClosedIcon = new ImageIcon(new URL(folderClosedImage));
            this.customLeafIcon = new ImageIcon(new URL(documentImage));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.controller = new Controller(serverAddress, this.entityName, this.repositoryId, this.hideLeafs);
            this.rootNode = this.controller.getRootNode();
            this.nodeTree = new JTree(this.rootNode);
            this.controller.setNodeTree(this.nodeTree);
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                SwingUtilities.updateComponentTreeUI(this.nodeTree);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
            renderer.setOpenIcon(this.customOpenIcon);
            renderer.setClosedIcon(this.customClosedIcon);
            renderer.setLeafIcon(this.customLeafIcon);
            renderer.setBackgroundNonSelectionColor(bgColor);
            this.nodeTree.setCellRenderer(renderer);
            FlowLayout flowManager = new FlowLayout(0);
            flowManager.setHgap(0);
            flowManager.setVgap(0);
            this.sp = new JScrollPane(this.nodeTree);
            this.sp.setBorder(null);
            this.getContentPane().setBackground(bgColor);
            this.getContentPane().add((Component)this.sp, "Center");
            this.nodeTree.setBackground(bgColor);
            this.nodeTree.addTreeSelectionListener(new NodeTreeSelectionListener(this));
            CMSTreeListener cmsTreeListener = new CMSTreeListener(this.nodeTree, this.controller);
            this.nodeTree.addMouseListener(cmsTreeListener);
            this.nodeTree.addTreeWillExpandListener(cmsTreeListener);
        }
        catch (Exception e) {
            FlowLayout flowManager = new FlowLayout(0);
            flowManager.setHgap(0);
            flowManager.setVgap(0);
            this.getContentPane().setBounds(5, 5, 150, 300);
            this.getContentPane().setLayout(flowManager);
            this.getContentPane().setBackground(bgColor);
            JTextPane errorMessage = new JTextPane();
            errorMessage.setBackground(bgColor);
            errorMessage.setText("Error:\r\nAn server-error made it\r\nimpossible to show the tree. \r\nPlease make sure that there are\r\nat least one repository available. \r\nIf the problem persists report it to \r\nyour technical straff.");
            this.getContentPane().add(errorMessage);
            e.printStackTrace();
        }
        this.notifyLoaded();
    }

    public void openMainArea(CMSNode node) {
        try {
            JSObject win = JSObject.getWindow((Applet)this);
            Object[] args = new Object[]{node.getId().toString(), this.repositoryId.toString(), this.getPath(node, new StringBuffer())};
            String functionName = "loadMainArea";
            win.call(functionName, args);
            this.currentNodeId = node.getId();
        }
        catch (Exception e) {
            System.err.println("An error occurred while we tried to call a javascript: " + e);
        }
    }

    public void notifyLoaded() {
        System.out.println("Going to tell the world that I'm fully loaded...");
        try {
            JSObject win = JSObject.getWindow((Applet)this);
            Object[] args = new Object[]{};
            String functionName = "notifyIsLoaded";
            win.call(functionName, args);
        }
        catch (Exception e) {
            System.err.println("An error occurred while we tried to call a javascript: " + e);
            e.printStackTrace();
        }
    }

    public void refreshTreeNode(Integer nodeId, Integer changeTypeId, Integer addedNodeId) {
        this.controller.refreshNode(nodeId, changeTypeId, addedNodeId);
    }

    public void refreshTreeNode(int nodeId, int changeTypeId, int addedNodeId) {
        this.controller.refreshNode(new Integer(nodeId), new Integer(changeTypeId), new Integer(addedNodeId));
    }

    private StringBuffer getPath(CMSNode node, StringBuffer path) {
        path.insert(0, "/" + node.getName());
        if (node.getParent() != null) {
            this.getPath((CMSNode)node.getParent(), path);
        }
        return path;
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.validate();
    }
}

