/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.plugins.opentree;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.infoglue.cms.net.Node;
import org.infoglue.cms.plugins.opentree.CMSNode;
import org.infoglue.cms.plugins.opentree.Communicator;

public class Controller {
    public static final int NODE_CHANGED = 1;
    public static final int NODE_CHILDREN_CHANGED = 2;
    public static final int NODE_MOVED = 3;
    public static final int NODE_DELETED = 4;
    private JTree nodeTree;
    private Communicator communicator;
    private Hashtable nodes = new Hashtable();
    private String hideLeafs;

    public Controller(String serverAddress, String entityName, Integer repositoryId, String hideLeafs) {
        this.communicator = new Communicator(serverAddress, entityName, repositoryId);
        this.hideLeafs = hideLeafs;
    }

    public void setNodeTree(JTree nodeTree) {
        this.nodeTree = nodeTree;
    }

    public void refreshNode(Integer nodeId, Integer changeTypeId, Integer addedNodeId) {
        DefaultTreeModel model = (DefaultTreeModel)this.nodeTree.getModel();
        CMSNode node = (CMSNode)this.nodes.get(nodeId);
        if (changeTypeId == 1) {
            CMSNode newNode = this.getNode(nodeId);
            node.setName(newNode.getName());
            model.nodeChanged(node);
        } else if (changeTypeId == 2) {
            node.setAreChildrenDefined(false);
            model.nodeStructureChanged(node);
            CMSNode addedNode = (CMSNode)this.nodes.get(addedNodeId);
            TreePath currentPath = this.nodeTree.getSelectionPath();
            if (currentPath == null) {
                currentPath = new TreePath(node);
            }
            this.nodeTree.setSelectionPath(currentPath.pathByAddingChild(addedNode));
        } else if (changeTypeId == 3) {
            CMSNode currentParent = (CMSNode)((CMSNode)this.nodeTree.getLastSelectedPathComponent()).getParent();
            currentParent.setAreChildrenDefined(false);
            model.nodeStructureChanged(currentParent);
            node.setAreChildrenDefined(false);
            model.nodeStructureChanged(node);
            CMSNode addedNode = (CMSNode)this.nodes.get(addedNodeId);
        } else if (changeTypeId == 4) {
            this.nodeTree.setSelectionPath(this.nodeTree.getSelectionPath().getParentPath());
            node.setAreChildrenDefined(false);
            model.nodeStructureChanged(node);
        }
    }

    public CMSNode getRootNode() throws Exception {
        Node rootNode = this.communicator.getRootNode();
        CMSNode rootCMSNode = this.generateVisualTreeModel(rootNode);
        this.updateHash(rootCMSNode);
        return rootCMSNode;
    }

    public CMSNode getNode(Integer nodeId) {
        Node node = this.communicator.getNode(nodeId);
        CMSNode cmsNode = this.generateVisualTreeModel(node);
        this.updateHash(cmsNode);
        return cmsNode;
    }

    public void updateHash(CMSNode node) {
        if (!this.nodes.containsKey(node.getId())) {
            this.nodes.put(node.getId(), node);
        }
    }

    public List getChildNodes(Integer parentId) {
        List childNodeVOList = this.communicator.getChildNodeList(parentId);
        List childNodes = this.generateVisualTreeModel(childNodeVOList);
        return childNodes;
    }

    private CMSNode generateVisualTreeModel(Node node) {
        CMSNode rootNode = new CMSNode(this, (boolean)node.getIsBranch());
        rootNode.setId(node.getId());
        rootNode.setName(node.getName());
        return rootNode;
    }

    private List generateVisualTreeModel(List nodeList) {
        ArrayList<CMSNode> children = new ArrayList<CMSNode>();
        if (nodeList != null) {
            for (Node node : nodeList) {
                if (this.hideLeafs != null && !this.hideLeafs.equals("false") && !node.getIsBranch().booleanValue()) continue;
                CMSNode cmsNode = new CMSNode(this, (boolean)node.getIsBranch());
                cmsNode.setId(node.getId());
                cmsNode.setName(node.getName());
                children.add(cmsNode);
                this.updateHash(cmsNode);
            }
        }
        return children;
    }
}

