/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.plugins.opentree;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.infoglue.cms.net.CommunicationEnvelope;
import org.infoglue.cms.net.Node;

public class Communicator {
    private String serverAddress = null;
    private String entityName = null;
    private Integer repositoryId = null;

    public Communicator(String serverAddress, String entityName, Integer repositoryId) {
        this.serverAddress = serverAddress;
        this.entityName = entityName;
        this.repositoryId = repositoryId;
    }

    public Node getRootNode() throws Exception {
        CommunicationEnvelope requestEnvelope = new CommunicationEnvelope();
        requestEnvelope.setAction("selectRootNode");
        ArrayList<Node> arguments = new ArrayList<Node>();
        Node n = new Node();
        n.setId(this.repositoryId);
        arguments.add(n);
        requestEnvelope.setNodes(arguments);
        CommunicationEnvelope responseEnvelope = this.callService(requestEnvelope);
        Node rootNode = null;
        int status = Integer.parseInt(responseEnvelope.getStatus());
        if (status == 0) {
            List nodes = responseEnvelope.getNodes();
            rootNode = (Node)nodes.get(0);
        }
        return rootNode;
    }

    public Node getNode(Integer nodeId) {
        CommunicationEnvelope requestEnvelope = new CommunicationEnvelope();
        requestEnvelope.setAction("selectNode");
        ArrayList<Node> arguments = new ArrayList<Node>();
        Node n = new Node();
        n.setId(nodeId);
        arguments.add(n);
        requestEnvelope.setNodes(arguments);
        CommunicationEnvelope responseEnvelope = this.callService(requestEnvelope);
        Node node = null;
        int status = Integer.parseInt(responseEnvelope.getStatus());
        if (status == 0) {
            List nodes = responseEnvelope.getNodes();
            node = (Node)nodes.get(0);
        }
        return node;
    }

    public List getChildNodeList(Integer parentId) {
        List childContents = null;
        CommunicationEnvelope requestEnvelope = new CommunicationEnvelope();
        requestEnvelope.setAction("selectChildNodes");
        ArrayList<Node> arguments = new ArrayList<Node>();
        Node n = new Node();
        n.setId(parentId);
        arguments.add(n);
        requestEnvelope.setNodes(arguments);
        CommunicationEnvelope responseEnvelope = this.callService(requestEnvelope);
        Object rootVO = null;
        int status = Integer.parseInt(responseEnvelope.getStatus());
        if (status == 0) {
            childContents = responseEnvelope.getNodes();
        }
        return childContents;
    }

    public CommunicationEnvelope callService(CommunicationEnvelope requestEnvelope) {
        Object outputToServlet = null;
        Object inputFromServlet = null;
        CommunicationEnvelope responseEnvelope = null;
        try {
            String url = this.serverAddress;
            try {
                Hashtable hash = this.serializeEnvelope(requestEnvelope);
                String response = this.postToUrl(this.serverAddress, hash);
                responseEnvelope = this.deserializeEnvelope(this.httpEncodedStringToHashtable(response));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return responseEnvelope;
    }

    private String postToUrl(String urlAddress, Hashtable inHash) throws Exception {
        String line;
        URL url = new URL(urlAddress);
        URLConnection urlConn = url.openConnection();
        urlConn.setAllowUserInteraction(false);
        urlConn.setDoOutput(true);
        urlConn.setDoInput(true);
        urlConn.setUseCaches(false);
        urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        PrintWriter printout = new PrintWriter(urlConn.getOutputStream(), true);
        String argString = "";
        if (inHash != null) {
            argString = this.toEncodedString(inHash);
        }
        printout.print(argString);
        printout.flush();
        printout.close();
        InputStream inStream = null;
        inStream = urlConn.getInputStream();
        InputStreamReader inStreamReader = new InputStreamReader(inStream);
        BufferedReader buffer = new BufferedReader(inStreamReader);
        StringBuffer strbuf = new StringBuffer();
        while ((line = buffer.readLine()) != null) {
            strbuf.append(line);
        }
        String readData = strbuf.toString();
        buffer.close();
        return readData;
    }

    private String toEncodedString(Hashtable inHash) throws Exception {
        StringBuffer buffer = new StringBuffer();
        Enumeration names = inHash.keys();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            String value = inHash.get(name).toString();
            buffer.append(String.valueOf(URLEncoder.encode(name, "UTF-8")) + "=" + URLEncoder.encode(value, "UTF-8"));
            if (!names.hasMoreElements()) continue;
            buffer.append("&");
        }
        return buffer.toString();
    }

    public Hashtable httpEncodedStringToHashtable(String encodedstrang) throws Exception {
        Hashtable<String, String> anropin = new Hashtable<String, String>();
        StringTokenizer andsplitter = new StringTokenizer(encodedstrang, "&");
        while (andsplitter.hasMoreTokens()) {
            String namevaluepair = andsplitter.nextToken();
            StringTokenizer equalsplitter = new StringTokenizer(namevaluepair, "=");
            if (equalsplitter.countTokens() != 2) continue;
            String name = equalsplitter.nextToken();
            String value = equalsplitter.nextToken();
            anropin.put(URLDecoder.decode(URLDecoder.decode(name, "UTF-8"), "UTF-8"), URLDecoder.decode(URLDecoder.decode(value, "UTF-8"), "UTF-8"));
        }
        return anropin;
    }

    private Hashtable serializeEnvelope(CommunicationEnvelope requestEnvelope) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        System.out.println("Serializing:" + requestEnvelope);
        hash.put("action", requestEnvelope.getAction());
        hash.put("status", requestEnvelope.getStatus());
        List nodes = requestEnvelope.getNodes();
        int i = 0;
        for (Node n : nodes) {
            hash.put("nodeList." + i + ".id", "" + n.getId());
            hash.put("nodeList." + i + ".name", n.getName());
            hash.put("nodeList." + i + ".isBranch", "" + n.getIsBranch());
            ++i;
        }
        return hash;
    }

    private CommunicationEnvelope deserializeEnvelope(Hashtable hash) {
        CommunicationEnvelope communicationEnvelope = new CommunicationEnvelope();
        communicationEnvelope.setAction("" + hash.get("action"));
        communicationEnvelope.setStatus("" + hash.get("status"));
        ArrayList<Node> nodes = new ArrayList<Node>();
        int i = 0;
        String id = (String)hash.get("nodeList." + i + ".id");
        while (id != null) {
            Node n = new Node();
            n.setId(new Integer(id));
            n.setName((String)hash.get("nodeList." + i + ".name"));
            n.setIsBranch(new Boolean((String)hash.get("nodeList." + i + ".isBranch")));
            nodes.add(n);
            id = (String)hash.get("nodeList." + ++i + ".id");
        }
        communicationEnvelope.setNodes(nodes);
        return communicationEnvelope;
    }
}

