/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.plugins.codeeditor;

import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.StringTokenizer;
import org.infoglue.cms.plugins.codeeditor.InfoGlueTextArea;

public class TextAreaInputListener
extends KeyAdapter {
    private InfoGlueTextArea infoGlueTextArea = null;
    private boolean isControlKeyActive = false;
    private boolean isShiftKeyActive = false;

    public TextAreaInputListener(InfoGlueTextArea infoGlueTextArea) {
        this.infoGlueTextArea = infoGlueTextArea;
    }

    public void keyPressed(KeyEvent e) {
        block27: {
            char key = e.getKeyChar();
            if (key == '.') {
                try {
                    int endPosition = this.infoGlueTextArea.getCaretPosition() - 1;
                    String text = this.infoGlueTextArea.getDocument().getText(this.infoGlueTextArea.getDocument().getStartPosition().getOffset(), this.infoGlueTextArea.getDocument().getEndPosition().getOffset());
                    StringBuffer sb = new StringBuffer();
                    int position = endPosition;
                    while (position > -1) {
                        char c = text.charAt(position);
                        if (c == '$' || c == ' ') {
                            sb.insert(0, c);
                            break;
                        }
                        sb.insert(0, c);
                        --position;
                    }
                    String keyword = sb.toString();
                    if (!keyword.equals("$templateLogic") && !keyword.equals("$!templateLogic") && !keyword.equals("${templateLogic") && !keyword.equals("$!{templateLogic")) break block27;
                    int x = 0;
                    int y = 0;
                    try {
                        Point caretPosition = this.infoGlueTextArea.getCaret().getMagicCaretPosition();
                        x = caretPosition.x;
                        y = caretPosition.y;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    this.infoGlueTextArea.openTemplateLogicCodeHelper(x, y);
                    this.isControlKeyActive = false;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (e.getKeyCode() == 52 && this.isControlKeyActive) {
                int x = 0;
                int y = 0;
                try {
                    Point caretPosition = this.infoGlueTextArea.getCaret().getMagicCaretPosition();
                    x = caretPosition.x;
                    y = caretPosition.y;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.infoGlueTextArea.openVelocityVariableTemplateCodeHelper(x, y);
                this.isControlKeyActive = false;
            } else if (key == '#') {
                int x = 0;
                int y = 0;
                try {
                    Point caretPosition = this.infoGlueTextArea.getCaret().getMagicCaretPosition();
                    x = caretPosition.x;
                    y = caretPosition.y;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.infoGlueTextArea.openVelocityTemplateCodeHelper(x, y);
            } else if (key == '\t') {
                String selectedText = this.infoGlueTextArea.getSelectedText();
                if (selectedText != null) {
                    String linebreak = System.getProperty("line.separator");
                    StringBuffer sb = new StringBuffer();
                    StringTokenizer st = new StringTokenizer(selectedText, linebreak, true);
                    while (st.hasMoreTokens()) {
                        String row = st.nextToken();
                        if (this.isShiftKeyActive) {
                            row = row.replaceFirst("\t", "");
                            sb.append(row);
                            continue;
                        }
                        sb.append(String.valueOf('\t') + row);
                    }
                    this.infoGlueTextArea.replaceSelection(sb.toString());
                }
            } else if (e.getKeyCode() == 83) {
                if (this.isControlKeyActive) {
                    this.infoGlueTextArea.controller.executeSave(this.infoGlueTextArea.getText());
                }
            } else if (e.getKeyCode() == 16) {
                this.isShiftKeyActive = true;
            } else if (e.getKeyCode() == 17) {
                this.isControlKeyActive = true;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        char key = e.getKeyChar();
        if (e.getKeyCode() == 16) {
            this.isShiftKeyActive = false;
        } else if (e.getKeyCode() == 17) {
            this.isControlKeyActive = false;
        }
    }
}

