/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.plugins.codeeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import org.infoglue.cms.plugins.codeeditor.CodeHelperDialog;
import org.infoglue.cms.plugins.codeeditor.HttpUtilities;
import org.infoglue.cms.plugins.codeeditor.InfoGlueCodeEditorController;
import org.infoglue.cms.plugins.codeeditor.Rule;
import org.infoglue.cms.plugins.codeeditor.TextAreaInputListener;

public class InfoGlueTextArea
extends JTextPane
implements DocumentListener {
    protected InfoGlueCodeEditorController controller = null;
    protected JScrollPane scrollPane = null;
    private Font standardFont = new Font("Courier", 0, 12);
    private CodeHelperDialog methodsCodeHelperDialog = null;
    private CodeHelperDialog velocityCodeHelperDialog = null;
    private CodeHelperDialog velocityVariableCodeHelperDialog = null;

    public InfoGlueTextArea(InfoGlueCodeEditorController infoGlueCodeEditorController) {
        Style styDefault = StyleContext.getDefaultStyleContext().getStyle("default");
        StyleConstants.setFontFamily(styDefault, "Courier");
        StyleConstants.setFontSize(styDefault, 14);
        StyleConstants.setForeground(styDefault, Color.black);
        this.setLogicalStyle(styDefault);
        SimpleAttributeSet attribs = new SimpleAttributeSet(this.getParagraphAttributes());
        StyleConstants.setBackground(attribs, new Color(230, 230, 230));
        this.setCharacterAttributes(attribs, false);
        this.setTabs();
        this.addKeyListener(new TextAreaInputListener(this));
        this.controller = infoGlueCodeEditorController;
    }

    private void setTabs() {
        ArrayList<TabStop> list = new ArrayList<TabStop>();
        float pos = 0.0f;
        int i = 0;
        while (i < 20) {
            int align = 0;
            int leader = 0;
            TabStop tstop = new TabStop(pos += 20.0f, align, leader);
            list.add(tstop);
            ++i;
        }
        TabStop[] tstops = list.toArray(new TabStop[0]);
        TabSet tabs = new TabSet(tstops);
        Style style = this.getLogicalStyle();
        StyleConstants.setTabSet(style, tabs);
        this.setLogicalStyle(style);
    }

    private List getTemplateLogicMethodList() {
        ArrayList<String> methods = new ArrayList<String>();
        try {
            String xml = HttpUtilities.getUrlContent(this.controller.getDeliverySettingsUrl());
            int offset = 0;
            int methodIndex = xml.indexOf("<method>", offset);
            int methodEndIndex = xml.indexOf("</method>", offset);
            while (methodIndex > -1 && methodEndIndex > -1) {
                String methodDescription = xml.substring(methodIndex + 8, methodEndIndex);
                methods.add(methodDescription);
                offset = methodEndIndex + 9;
                methodIndex = xml.indexOf("<method>", offset);
                methodEndIndex = xml.indexOf("</method>", offset);
            }
        }
        catch (Exception e) {
            System.out.println("Exception:" + e);
            e.printStackTrace();
        }
        return methods;
    }

    public void openTemplateLogicCodeHelper(int xPosition, int yPosition) {
        if (this.methodsCodeHelperDialog == null) {
            List methods = this.getTemplateLogicMethodList();
            ArrayList<String> listItems = new ArrayList<String>();
            Iterator i = methods.iterator();
            while (i.hasNext()) {
                String method = (String)i.next();
                listItems.add(method);
            }
            this.methodsCodeHelperDialog = new CodeHelperDialog(this.getFrame(this), this, listItems.toArray());
        }
        int xLocation = this.getFrame((Component)this).getLocationOnScreen().x + xPosition + 10;
        int yLocation = this.getFrame((Component)this).getLocationOnScreen().y + yPosition + 24;
        if (xLocation > this.scrollPane.getWidth()) {
            xLocation = this.scrollPane.getWidth();
        }
        if (yLocation > this.scrollPane.getHeight()) {
            yLocation = this.scrollPane.getHeight();
        }
        this.methodsCodeHelperDialog.setLocation(xLocation, yLocation);
        this.methodsCodeHelperDialog.setVisible(true);
    }

    public void openVelocityTemplateCodeHelper(int xPosition, int yPosition) {
        if (this.velocityCodeHelperDialog == null) {
            ArrayList<String> listItems = new ArrayList<String>();
            listItems.add("if()");
            listItems.add("else()");
            listItems.add("elseif()");
            listItems.add("end()");
            listItems.add("foreach()");
            listItems.add("if()");
            listItems.add("include()");
            listItems.add("macro()");
            listItems.add("parse()");
            listItems.add("set()");
            listItems.add("stop()");
            this.velocityCodeHelperDialog = new CodeHelperDialog(this.getFrame(this), this, listItems.toArray());
        }
        int xLocation = this.getFrame((Component)this).getLocationOnScreen().x + xPosition + 10;
        int yLocation = this.getFrame((Component)this).getLocationOnScreen().y + yPosition + 24;
        if (xLocation > this.scrollPane.getWidth()) {
            xLocation = this.scrollPane.getWidth();
        }
        if (yLocation > this.scrollPane.getHeight()) {
            yLocation = this.scrollPane.getHeight();
        }
        this.velocityCodeHelperDialog.setLocation(xLocation, yLocation);
        this.velocityCodeHelperDialog.setVisible(true);
    }

    public void openVelocityVariableTemplateCodeHelper(int xPosition, int yPosition) {
        if (this.velocityVariableCodeHelperDialog == null) {
            ArrayList<String> listItems = new ArrayList<String>();
            listItems.add("templateLogic");
            this.velocityVariableCodeHelperDialog = new CodeHelperDialog(this.getFrame(this), this, listItems.toArray());
        }
        int xLocation = this.getFrame((Component)this).getLocationOnScreen().x + xPosition + 10;
        int yLocation = this.getFrame((Component)this).getLocationOnScreen().y + yPosition + 24;
        if (xLocation > this.scrollPane.getWidth()) {
            xLocation = this.scrollPane.getWidth();
        }
        if (yLocation > this.scrollPane.getHeight()) {
            yLocation = this.scrollPane.getHeight();
        }
        this.velocityVariableCodeHelperDialog.setLocation(xLocation, yLocation);
        this.velocityVariableCodeHelperDialog.setVisible(true);
    }

    private Frame getFrame(Component parent) {
        while (!(parent instanceof Frame)) {
            parent = parent.getParent();
        }
        return (Frame)parent;
    }

    public void setScrollPane(JScrollPane scrollPane) {
        this.scrollPane = scrollPane;
        Rule columnView = new Rule(0, true);
        columnView.setPreferredWidth(500);
        Rule rowView = new Rule(1, true);
        rowView.setPreferredHeight(20000);
        scrollPane.setRowHeaderView(rowView);
    }

    public void insertUpdate(DocumentEvent event) {
    }

    public void removeUpdate(DocumentEvent event) {
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public void setSize(Dimension d) {
        if (d.width < this.getParent().getSize().width) {
            d.width = this.getParent().getSize().width;
        }
        super.setSize(d);
    }
}

