/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.plugins.codeeditor;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.infoglue.cms.plugins.codeeditor.InfoGlueTextArea;

public class CodeHelperDialog
extends JDialog
implements MouseListener,
KeyListener {
    private Frame parentFrame = null;
    private InfoGlueTextArea infoGlueTextArea = null;
    private JList list = new JList();

    public CodeHelperDialog(Frame parentFrame, InfoGlueTextArea infoGlueTextArea, Object[] items) {
        super(parentFrame, true);
        this.parentFrame = parentFrame;
        this.infoGlueTextArea = infoGlueTextArea;
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        int i = 0;
        while (i < items.length) {
            model.addElement(items[i]);
            ++i;
        }
        this.list.setModel(model);
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(this.list);
        this.getContentPane().add(scroller);
        this.list.setFont(new Font("Courier", 0, 12));
        this.list.addKeyListener(this);
        this.list.addMouseListener(this);
        this.setSize(500, 200);
        this.list.requestFocus();
    }

    public void mousePressed(MouseEvent event) {
        this.insertSpecialText(this.infoGlueTextArea.getCaretPosition(), this.list.getSelectedValue().toString());
        this.list.setSelectedIndex(0);
        this.setVisible(false);
        this.infoGlueTextArea.requestFocus();
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            this.insertSpecialText(this.infoGlueTextArea.getCaretPosition(), this.list.getSelectedValue().toString());
            this.setVisible(false);
            this.list.setSelectedIndex(0);
            this.infoGlueTextArea.requestFocus();
        } else {
            this.insertSpecialText(this.infoGlueTextArea.getCaretPosition(), "" + e.getKeyChar());
            this.setVisible(false);
            this.list.setSelectedIndex(0);
            this.infoGlueTextArea.requestFocus();
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void insertSpecialText(int position, String text) {
        SimpleAttributeSet attribs = new SimpleAttributeSet(this.infoGlueTextArea.getParagraphAttributes());
        StyleConstants.setBackground(attribs, new Color(230, 230, 230));
        try {
            this.infoGlueTextArea.getDocument().insertString(position, text, attribs);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.infoGlueTextArea.setCharacterAttributes(this.infoGlueTextArea.getParagraphAttributes(), false);
    }
}

