/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.jobs;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.InfoGluePrincipalControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.InterceptionPointController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.management.InterceptionPointVO;
import org.infoglue.cms.entities.management.InterceptorVO;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.interceptors.SubscriptionsInterceptor;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.interceptors.InfoGlueInterceptor;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionsJob
implements Job {
    private static final Logger logger = Logger.getLogger((String)SubscriptionsJob.class.getName());
    private static final VisualFormatter vf = new VisualFormatter();

    public synchronized void execute(JobExecutionContext context) throws JobExecutionException {
        logger.info((Object)"*********************************************************************");
        logger.info((Object)"* Starting job which sends subscriptions when conditions are met    *");
        logger.info((Object)"*********************************************************************");
        InfoGluePrincipalControllerProxy.getController().getTestPrincipal();
        try {
            logger.info((Object)"SubscriptionsJob...");
            logger.info((Object)"SubscriptionsJob...");
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("globalKey", "infoglueSubscriptions");
            PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
            int numberOfDays = 30;
            this.cleanPropertySet(ps, numberOfDays);
            this.handleExpirationEvents(ps, numberOfDays);
            SubscriptionsInterceptor interceptor = new SubscriptionsInterceptor();
            List processedTransactions = interceptor.processTransactionQueue();
            this.registerDoneSubscriptionProcessing(ps, numberOfDays, processedTransactions);
            logger.info((Object)"SubscriptionsJob ended...");
        }
        catch (Exception e) {
            logger.error((Object)("Could not notify subscribers: " + e.getMessage()));
        }
        logger.info((Object)"Refresh-job finished");
    }

    private void registerDoneSubscriptionProcessing(PropertySet ps, int numberOfDays, List<SubscriptionsInterceptor.TransactionQueueVO> processedTransactions) {
        for (SubscriptionsInterceptor.TransactionQueueVO transactionQueueVO : processedTransactions) {
            String key;
            if (transactionQueueVO.getInterceptionPointVO().getName().equalsIgnoreCase("Content.ExpireDateComingUp")) {
                key = "content_" + transactionQueueVO.getTransactionObjectId() + "_" + numberOfDays + "_days_isProcessed";
                logger.info((Object)("Setting key so we don't get the same warning again: " + key));
                ps.setString(key, vf.formatDate(new Date(), "yyyy-MM-dd"));
                continue;
            }
            if (!transactionQueueVO.getInterceptionPointVO().getName().equalsIgnoreCase("SiteNode.ExpireDateComingUp")) continue;
            key = "siteNode_" + transactionQueueVO.getTransactionObjectId() + "_" + numberOfDays + "_days_isProcessed";
            logger.info((Object)("Setting key so we don't get the same warning again: " + key));
            ps.setString(key, vf.formatDate(new Date(), "yyyy-MM-dd"));
        }
    }

    private void handleExpirationEvents(PropertySet ps, int numberOfDays) throws Exception, ConstraintException, SystemException, Bug {
        List<SiteNodeVO> upcomingSiteNodes = SiteNodeController.getController().getUpcomingExpiringSiteNodes(numberOfDays);
        for (SiteNodeVO siteNodeVO : upcomingSiteNodes) {
            logger.info((Object)("siteNodeVO:" + siteNodeVO.getName() + " - " + siteNodeVO.getExpireDateTime()));
            String key = "siteNode_" + siteNodeVO.getId() + "_" + numberOfDays + "_days_isProcessed";
            logger.info((Object)("key:" + key));
            String isProcessed = ps.getString(key);
            if (isProcessed != null && !isProcessed.equals("")) continue;
            logger.info((Object)("The node " + siteNodeVO.getName() + " has not been processed."));
            HashMap<String, SiteNodeVO> data = new HashMap<String, SiteNodeVO>();
            data.put("siteNodeVO", siteNodeVO);
            this.intercept(data, "SiteNode.ExpireDateComingUp");
        }
        List<ContentVO> upcomingContents = ContentController.getContentController().getUpcomingExpiringContents(30);
        for (ContentVO contentVO : upcomingContents) {
            logger.info((Object)("contentVO:" + contentVO.getName() + " - " + contentVO.getExpireDateTime()));
            String key = "content_" + contentVO.getId() + "_" + numberOfDays + "_days_isProcessed";
            logger.info((Object)("key:" + key));
            String dateProcessed = ps.getString(key);
            if (dateProcessed != null && !dateProcessed.equals("")) continue;
            logger.info((Object)("The node " + contentVO.getName() + " has not been processed."));
            HashMap<String, ContentVO> data = new HashMap<String, ContentVO>();
            data.put("contentVO", contentVO);
            this.intercept(data, "Content.ExpireDateComingUp");
        }
    }

    private void cleanPropertySet(PropertySet ps, int numberOfDays) {
        Collection keys = ps.getKeys(null);
        for (String key : keys) {
            String value = ps.getString(key);
            logger.info((Object)("Found key:" + key + "=" + value));
            Date lastDate = vf.parseDate(value, "yyyy-MM-dd");
            Calendar removeDate = Calendar.getInstance();
            removeDate.add(6, -(numberOfDays + 10));
            if (!lastDate.before(removeDate.getTime())) continue;
            logger.info((Object)("Removing key:" + key));
            ps.remove(key);
        }
    }

    protected void intercept(Map hashMap, String InterceptionPointName) throws ConstraintException, SystemException, Bug, Exception {
        InfoGluePrincipal principal = UserControllerProxy.getController().getUser(CmsPropertyHandler.getAdministratorUserName());
        InterceptionPointVO interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName(InterceptionPointName);
        if (interceptionPointVO == null) {
            throw new SystemException("The InterceptionPoint " + InterceptionPointName + " was not found. The system will not work unless you restore it.");
        }
        List interceptors = InterceptionPointController.getController().getInterceptorsVOList(interceptionPointVO.getInterceptionPointId());
        for (InterceptorVO interceptorVO : interceptors) {
            logger.info((Object)("Adding interceptorVO:" + interceptorVO.getName()));
            try {
                InfoGlueInterceptor infoGlueInterceptor = (InfoGlueInterceptor)Class.forName(interceptorVO.getClassName()).newInstance();
                infoGlueInterceptor.intercept(principal, interceptionPointVO, hashMap, false);
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)("The interceptor " + interceptorVO.getClassName() + "was not found: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

