/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.jobs;

import org.apache.log4j.Logger;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class CleanOldVersionsJob
implements Job {
    private static final Logger logger = Logger.getLogger((String)CleanOldVersionsJob.class.getName());
    private static boolean running = false;

    public synchronized void execute(JobExecutionContext context) throws JobExecutionException {
        block7: {
            logger.info((Object)"*********************************************************************");
            logger.info((Object)"* Starting version cleanup job which should run with nice intervals *");
            logger.info((Object)"* Purpose is to keep the database size at a minimum \t\t\t\t *");
            logger.info((Object)"*********************************************************************");
            if (running) {
                logger.info((Object)"CleanOldVersionsJob allready running... skipping.");
                return;
            }
            running = true;
            try {
                try {
                    String numberOfVersionsToKeepDuringClean = CmsPropertyHandler.getNumberOfVersionsToKeepDuringClean();
                    logger.info((Object)("numberOfVersionsToKeepDuringClean:" + numberOfVersionsToKeepDuringClean));
                    Integer numberOfVersionsToKeepDuringCleanInteger = new Integer(numberOfVersionsToKeepDuringClean);
                    String keepOnlyOldPublishedVersionsString = CmsPropertyHandler.getKeepOnlyOldPublishedVersionsDuringClean();
                    logger.info((Object)("keepOnlyOldPublishedVersionsString:" + keepOnlyOldPublishedVersionsString));
                    boolean keepOnlyOldPublishedVersions = Boolean.parseBoolean(keepOnlyOldPublishedVersionsString);
                    if (numberOfVersionsToKeepDuringCleanInteger > -1) {
                        ContentVersionController.getContentVersionController().cleanContentVersions(numberOfVersionsToKeepDuringCleanInteger, keepOnlyOldPublishedVersions);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Could not clean up old versions: " + e.getMessage()));
                    running = false;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                running = false;
                throw throwable;
            }
            running = false;
        }
        logger.info((Object)"Cleanup-job finished");
    }
}

