/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;

public class FileHelper {
    public static synchronized void writeToFile(File file, String text, boolean isAppend) throws Exception {
        PrintWriter pout = new PrintWriter((Writer)new FileWriter(file), isAppend);
        pout.println(text);
        pout.close();
    }

    public static synchronized void writeUTF8ToFileSpecial(File file, String text, boolean isAppend) throws Exception {
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(file, isAppend));
        dos.writeBytes(text);
        dos.flush();
        dos.close();
    }

    public static synchronized void writeUTF8(File file, String text, boolean isAppend) throws Exception {
        FileOutputStream fos = new FileOutputStream(file, isAppend);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        out.write(text);
        ((Writer)out).flush();
        ((Writer)out).close();
    }

    public static synchronized void writeUTF8ToFile(File file, String text, boolean isAppend) throws Exception {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
        out.write(text);
        ((Writer)out).flush();
        ((Writer)out).close();
    }

    public static synchronized String readUTF8FromFile(File file) throws Exception {
        int ch;
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
        String str = in.readLine();
        StringBuffer sb = new StringBuffer();
        while ((ch = in.read()) > -1) {
            sb.append((char)ch);
        }
        in.close();
        return sb.toString();
    }

    public static byte[] getFileBytes(File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        byte[] fileBytes = new byte[(int)file.length()];
        fis.read(fileBytes);
        fis.close();
        return fileBytes;
    }

    public static String getFileAsString(File file) throws Exception {
        int c;
        StringBuffer sb = new StringBuffer();
        FileInputStream fis = new FileInputStream(file);
        while ((c = fis.read()) != -1) {
            sb.append((char)c);
        }
        fis.close();
        return sb.toString();
    }

    public static String getStreamAsString(InputStream inputStream) throws Exception {
        StringBuffer sb = new StringBuffer();
        if (inputStream != null) {
            int c;
            while ((c = inputStream.read()) != -1) {
                sb.append((char)c);
            }
            inputStream.close();
        }
        return sb.toString();
    }

    public static void writeToFile(File file, byte[] data) throws Exception {
        FileOutputStream fos = new FileOutputStream(file);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        int i = 0;
        while (i < data.length) {
            bos.write(data[i]);
            ++i;
        }
        bos.flush();
        bos.close();
        fos.close();
    }

    public static String tail(File file, int numberOfLines) throws Exception {
        StringBuffer result = new StringBuffer("");
        if (file.length() == 0L) {
            return "The log file was empty";
        }
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        char ch = raf.readChar();
        if (file.length() > (long)(numberOfLines * 150)) {
            raf.seek(file.length() - (long)(numberOfLines * 150));
        }
        raf.readLine();
        String lineData = "";
        while ((lineData = raf.readLine()) != null) {
            result.append(lineData).append('\n');
        }
        raf.close();
        return result.toString();
    }
}

