/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.interceptors;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.InterceptionPointController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.SubscriptionController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.InterceptionPointVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.SubscriptionVO;
import org.infoglue.cms.entities.management.TransactionHistoryVO;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.entities.structure.SiteNodeVersion;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.interceptors.InfoGlueInterceptor;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.mail.MailServiceFactory;

public class SubscriptionsInterceptor
extends BaseController
implements InfoGlueInterceptor {
    private static final Logger logger = Logger.getLogger((String)SubscriptionsInterceptor.class.getName());
    private static final VisualFormatter vf = new VisualFormatter();
    private static List<TransactionQueueVO> transactionQueue = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransactionHistory(InterceptionPointVO interceptionPointVO, String name, String userName, Integer typeId, String objectName, String objectId, String subject, String description) {
        TransactionQueueVO transVO = new TransactionQueueVO();
        transVO.setInterceptionPointVO(interceptionPointVO);
        transVO.setName(name);
        transVO.setSystemUserName(userName);
        transVO.setTransactionDateTime(Calendar.getInstance().getTime());
        transVO.setTransactionTypeId(typeId);
        transVO.setTransactionObjectId(objectId);
        transVO.setTransactionObjectName(objectName);
        transVO.setSubject(subject);
        transVO.setDescription(description);
        List<TransactionQueueVO> list = transactionQueue;
        synchronized (list) {
            logger.info((Object)("Adding transactionQueue:" + interceptionPointVO.getName() + " - " + objectName));
            transactionQueue.add(transVO);
        }
    }

    public void intercept(InfoGluePrincipal infoGluePrincipal, InterceptionPointVO interceptionPointVO, Map extradata) throws ConstraintException, SystemException, Exception {
        this.intercept(infoGluePrincipal, interceptionPointVO, extradata, true);
    }

    public void intercept(InfoGluePrincipal infoGluePrincipal, InterceptionPointVO interceptionPointVO, Map extradata, boolean allowCreatorAccess) throws ConstraintException, SystemException, Exception {
        Database db = CastorDatabaseService.getDatabase();
        try {
            SubscriptionsInterceptor.beginTransaction(db);
            this.intercept(infoGluePrincipal, interceptionPointVO, extradata, allowCreatorAccess, db);
            SubscriptionsInterceptor.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            SubscriptionsInterceptor.rollbackTransaction(db);
        }
    }

    public void intercept(InfoGluePrincipal infoGluePrincipal, InterceptionPointVO interceptionPointVO, Map extradata, Database db) throws ConstraintException, SystemException, Exception {
        this.intercept(infoGluePrincipal, interceptionPointVO, extradata, true, db);
    }

    public void intercept(InfoGluePrincipal infoGluePrincipal, InterceptionPointVO interceptionPointVO, Map extradata, boolean allowCreatorAccess, Database db) throws ConstraintException, SystemException, Exception {
        Locale userLocale = this.getUserPrefferedLocale(infoGluePrincipal.getName());
        String generalFooter = this.getLocalizedString(userLocale, "tool.common.subscriptionMail.generalFooter");
        String entityName = null;
        String entityId = null;
        if (interceptionPointVO.getName().equalsIgnoreCase("Content.Write")) {
            Integer contentId = (Integer)extradata.get("contentId");
            entityName = Content.class.getName();
            entityId = contentId.toString();
        } else if (interceptionPointVO.getName().equalsIgnoreCase("Content.Create")) {
            Integer contentId = (Integer)extradata.get("contentId");
            entityName = Content.class.getName();
            entityId = contentId.toString();
        } else if (interceptionPointVO.getName().equalsIgnoreCase("Content.Delete")) {
            Integer contentId = (Integer)extradata.get("contentId");
            entityName = Content.class.getName();
            entityId = contentId.toString();
        } else if (interceptionPointVO.getName().equalsIgnoreCase("Content.Move")) {
            Integer contentId = (Integer)extradata.get("contentId");
            entityName = Content.class.getName();
            entityId = contentId.toString();
        } else if (interceptionPointVO.getName().equalsIgnoreCase("Content.CreateVersion")) {
            Integer contentId = (Integer)extradata.get("contentId");
            entityName = Content.class.getName();
            entityId = contentId.toString();
        } else if (interceptionPointVO.getName().equalsIgnoreCase("Content.SubmitToPublish")) {
            Integer contentId = (Integer)extradata.get("contentId");
            entityName = Content.class.getName();
            entityId = contentId.toString();
        } else if (interceptionPointVO.getName().equalsIgnoreCase("Content.ChangeAccessRights")) {
            Integer contentId = (Integer)extradata.get("contentId");
            entityName = Content.class.getName();
            entityId = contentId.toString();
        } else if (interceptionPointVO.getName().equalsIgnoreCase("ContentVersion.Write")) {
            Integer contentVersionId = (Integer)extradata.get("contentVersionId");
            entityName = ContentVersion.class.getName();
            entityId = contentVersionId.toString();
            ContentVersionVO contentVersionVO = ContentVersionControllerProxy.getController().getContentVersionVOWithId(contentVersionId, db);
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentVersionVO.getContentId(), db);
            InterceptionPointVO contentInterceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("Content.Write", db);
            String generalSubject = this.getLocalizedString(userLocale, "tool.common.subscriptionMail.generalSubject");
            String generalMessage = String.valueOf(this.getLocalizedString(userLocale, "tool.common.subscriptionMail.generalMessage", entityName, entityId)) + generalFooter;
            String subject = this.getLocalizedString(userLocale, "tool.common.subscriptionMail.contentUpdatedSubject");
            String message = String.valueOf(this.getLocalizedString(userLocale, "tool.common.subscriptionMail.contentUpdatedMessage", contentVO.getName())) + generalFooter;
            this.addTransactionHistory(contentInterceptionPointVO, "SubscriptionsEvents", infoGluePrincipal.getName(), new Integer(999), Content.class.getName(), contentVersionVO.getContentId().toString(), subject, message);
            this.addTransactionHistory(interceptionPointVO, "SubscriptionsEvents", infoGluePrincipal.getName(), new Integer(999), entityName, entityId, generalSubject, generalMessage);
        } else if (interceptionPointVO.getName().equalsIgnoreCase("ContentVersion.Delete")) {
            Integer contentVersionId = (Integer)extradata.get("contentVersionId");
            entityName = ContentVersion.class.getName();
            entityId = contentVersionId.toString();
            ContentVersionVO contentVersionVO = ContentVersionControllerProxy.getController().getContentVersionVOWithId(contentVersionId, db);
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentVersionVO.getContentId(), db);
            InterceptionPointVO contentInterceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName("Content.Write", db);
            this.addTransactionHistory(contentInterceptionPointVO, "SubscriptionsEvents", infoGluePrincipal.getName(), new Integer(999), Content.class.getName(), contentVersionVO.getContentId().toString(), "Subscription: Content deleted", "A user has changed the content '" + contentVO.getName() + "'. You subscribe to this event why this message is sent.");
            this.addTransactionHistory(interceptionPointVO, "SubscriptionsEvents", infoGluePrincipal.getName(), new Integer(999), entityName, entityId, "Subscription notification", "The entity " + entityName + " was deleted. You subscribe to this event why this message is sent.");
        } else if (interceptionPointVO.getName().equalsIgnoreCase("Content.ExpireDateComingUp")) {
            ContentVO contentVO = (ContentVO)extradata.get("contentVO");
            entityName = ContentVersion.class.getName();
            entityId = contentVO.getId().toString();
            String fullPath = ContentController.getContentController().getContentPath(new Integer(entityId), true, true);
            this.addTransactionHistory(interceptionPointVO, "SubscriptionsEvents", infoGluePrincipal.getName(), new Integer(999), entityName, entityId, "Subscription notification", "The content \"" + fullPath + "\" will expire on " + vf.formatDate(contentVO.getExpireDateTime(), "yyyy-MM-dd HH:ss") + ". <hr/>You either subscribe to this event, created the content or was the last person to modify the content why this message is sent.");
        } else if (interceptionPointVO.getName().equalsIgnoreCase("SiteNode.ExpireDateComingUp")) {
            SiteNodeVO siteNodeVO = (SiteNodeVO)extradata.get("siteNodeVO");
            entityName = ContentVersion.class.getName();
            entityId = siteNodeVO.getId().toString();
            String fullPath = SiteNodeController.getController().getSiteNodePath(new Integer(entityId), db);
            this.addTransactionHistory(interceptionPointVO, "SubscriptionsEvents", infoGluePrincipal.getName(), new Integer(999), entityName, entityId, "Subscription notification", "The page \"" + fullPath + "\" will expire on " + vf.formatDate(siteNodeVO.getExpireDateTime(), "yyyy-MM-dd HH:ss") + ". <hr/>You either subscribe to this event, created the page or was the last person to modify the page why this message is sent.");
        } else if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.Write")) {
            Integer siteNodeVersionId = (Integer)extradata.get("siteNodeVersionId");
            entityName = SiteNodeVersion.class.getName();
            entityId = siteNodeVersionId.toString();
        } else if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.CreateSiteNode")) {
            Integer parentSiteNodeId = (Integer)extradata.get("siteNodeId");
            entityName = SiteNode.class.getName();
            entityId = parentSiteNodeId.toString();
        } else if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.DeleteSiteNode")) {
            Integer siteNodeId = (Integer)extradata.get("siteNodeId");
            entityName = SiteNode.class.getName();
            entityId = siteNodeId.toString();
        } else if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.MoveSiteNode")) {
            Integer siteNodeId = (Integer)extradata.get("siteNodeId");
            entityName = SiteNode.class.getName();
            entityId = siteNodeId.toString();
        } else if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.SubmitToPublish")) {
            Integer siteNodeVersionId = (Integer)extradata.get("siteNodeVersionId");
            entityName = SiteNodeVersion.class.getName();
            entityId = siteNodeVersionId.toString();
        } else if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.ChangeAccessRights")) {
            Integer siteNodeVersionId = (Integer)extradata.get("siteNodeVersionId");
            entityName = SiteNodeVersion.class.getName();
            entityId = siteNodeVersionId.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List processTransactionQueue() throws Exception {
        ArrayList<TransactionQueueVO> completeTransactions = new ArrayList<TransactionQueueVO>();
        ArrayList<TransactionQueueVO> localTransactionQueue = new ArrayList<TransactionQueueVO>();
        List<TransactionQueueVO> list = transactionQueue;
        synchronized (list) {
            logger.info((Object)"Moving the transactions to this threads local queue...");
            localTransactionQueue.addAll(transactionQueue);
            transactionQueue.clear();
        }
        for (TransactionQueueVO transactionQueueVO : localTransactionQueue) {
            Database db = CastorDatabaseService.getDatabase();
            try {
                List<SubscriptionVO> subscriptionVOList;
                block11: {
                    block10: {
                        SubscriptionsInterceptor.beginTransaction(db);
                        logger.info((Object)("InterceptionPointVO:" + transactionQueueVO.getInterceptionPointVO().getName()));
                        logger.info((Object)("\t" + transactionQueueVO.getTransactionObjectName() + "=" + transactionQueueVO.getTransactionObjectId()));
                        subscriptionVOList = SubscriptionController.getController().getSubscriptionVOList(transactionQueueVO.getInterceptionPointVO().getId(), null, false, transactionQueueVO.getTransactionObjectName(), transactionQueueVO.getTransactionObjectId(), null, null, db, true);
                        logger.info((Object)("subscriptionVOList:" + subscriptionVOList.size()));
                        if (!transactionQueueVO.getInterceptionPointVO().getName().equalsIgnoreCase("SiteNode.ExpireDateComingUp")) break block10;
                        logger.info((Object)"It's a expiredate coming up event... let's find add a fake subscription on the last modifier.");
                        SiteNodeController.getController();
                        SiteNodeVO siteNodeVO = SiteNodeController.getSiteNodeVOWithId(new Integer(transactionQueueVO.getTransactionObjectId()), db);
                        if (siteNodeVO == null) break block11;
                        SiteNodeVersionVO version = SiteNodeVersionController.getController().getLatestSiteNodeVersionVO(db, siteNodeVO.getId());
                        SubscriptionVO creatorSubscriptionVO = new SubscriptionVO();
                        creatorSubscriptionVO.setEntityId(transactionQueueVO.getTransactionObjectId());
                        creatorSubscriptionVO.setEntityName(transactionQueueVO.getTransactionObjectName());
                        creatorSubscriptionVO.setInterceptionPointId(transactionQueueVO.getInterceptionPointVO().getId());
                        creatorSubscriptionVO.setName("Standard subscription");
                        creatorSubscriptionVO.setUserName(siteNodeVO.getCreatorName());
                        subscriptionVOList.add(creatorSubscriptionVO);
                        if (version == null || version.getVersionModifier().equals(siteNodeVO.getCreatorName())) break block11;
                        SubscriptionVO modifyerSubscriptionVO = new SubscriptionVO();
                        modifyerSubscriptionVO.setEntityId(transactionQueueVO.getTransactionObjectId());
                        modifyerSubscriptionVO.setEntityName(transactionQueueVO.getTransactionObjectName());
                        modifyerSubscriptionVO.setInterceptionPointId(transactionQueueVO.getInterceptionPointVO().getId());
                        modifyerSubscriptionVO.setName("Standard subscription");
                        modifyerSubscriptionVO.setUserName(version.getVersionModifier());
                        subscriptionVOList.add(modifyerSubscriptionVO);
                        break block11;
                    }
                    if (transactionQueueVO.getInterceptionPointVO().getName().equalsIgnoreCase("Content.ExpireDateComingUp")) {
                        logger.info((Object)"It's a expiredate coming up event... let's find add a fake subscription on the last modifier.");
                        ContentVO contentVO = ContentController.getContentController().getContentVOWithId(new Integer(transactionQueueVO.getTransactionObjectId()), db);
                        if (contentVO != null) {
                            SubscriptionVO creatorSubscriptionVO = new SubscriptionVO();
                            creatorSubscriptionVO.setEntityId(transactionQueueVO.getTransactionObjectId());
                            creatorSubscriptionVO.setEntityName(transactionQueueVO.getTransactionObjectName());
                            creatorSubscriptionVO.setInterceptionPointId(transactionQueueVO.getInterceptionPointVO().getId());
                            creatorSubscriptionVO.setName("Standard subscription");
                            creatorSubscriptionVO.setUserName(contentVO.getCreatorName());
                            subscriptionVOList.add(creatorSubscriptionVO);
                            List languages = LanguageController.getController().getLanguageVOList(contentVO.getRepositoryId(), db);
                            for (LanguageVO languageVO : languages) {
                                ContentVersionVO version = ContentVersionController.getContentVersionController().getLatestContentVersionVO(contentVO.getId(), languageVO.getId(), db);
                                if (version == null || version.getVersionModifier().equals(contentVO.getCreatorName())) continue;
                                SubscriptionVO modifyerSubscriptionVO = new SubscriptionVO();
                                modifyerSubscriptionVO.setEntityId(transactionQueueVO.getTransactionObjectId());
                                modifyerSubscriptionVO.setEntityName(transactionQueueVO.getTransactionObjectName());
                                modifyerSubscriptionVO.setInterceptionPointId(transactionQueueVO.getInterceptionPointVO().getId());
                                modifyerSubscriptionVO.setName("Standard subscription");
                                modifyerSubscriptionVO.setUserName(version.getVersionModifier());
                                subscriptionVOList.add(modifyerSubscriptionVO);
                            }
                        }
                    }
                }
                for (SubscriptionVO subscriptionVO : subscriptionVOList) {
                    boolean subscriptionHandled = this.handleSubscription(subscriptionVO, transactionQueueVO, db);
                    if (!subscriptionHandled) continue;
                    completeTransactions.add(transactionQueueVO);
                }
                SubscriptionsInterceptor.commitTransaction(db);
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
                SubscriptionsInterceptor.rollbackTransaction(db);
            }
        }
        logger.info((Object)("localTransactionQueue:" + localTransactionQueue.size()));
        return completeTransactions;
    }

    private boolean handleSubscription(SubscriptionVO subscriptionVO, TransactionQueueVO transactionQueueVO, Database db) throws Exception {
        boolean handledSubscription = true;
        logger.info((Object)("subscriptionVO:" + subscriptionVO));
        if (subscriptionVO.getSubscriptionFilterVOList() == null || subscriptionVO.getSubscriptionFilterVOList().size() == 0) {
            InfoGluePrincipal principal;
            String email = subscriptionVO.getUserEmail();
            if (email == null && (principal = UserControllerProxy.getController(db).getUser(subscriptionVO.getUserName())) != null) {
                logger.info((Object)("principal:" + principal.getEmail()));
                email = principal.getEmail();
            }
            logger.info((Object)("Was a simple subscription without filters:" + email));
            if (email != null) {
                MailServiceFactory.getService().sendEmail(CmsPropertyHandler.getSystemEmailSender(), email, null, null, transactionQueueVO.getSubject(), transactionQueueVO.getDescription(), "utf-8");
            }
        }
        return handledSubscription;
    }

    public BaseEntityVO getNewVO() {
        return null;
    }

    public class TransactionQueueVO
    extends TransactionHistoryVO {
        private String subject;
        private String description;
        private InterceptionPointVO interceptionPointVO = null;

        public InterceptionPointVO getInterceptionPointVO() {
            return this.interceptionPointVO;
        }

        public void setInterceptionPointVO(InterceptionPointVO interceptionPointVO) {
            this.interceptionPointVO = interceptionPointVO;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

