/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.entities.structure;

import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.SimpleTimeZone;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.validators.ValidatorFactory;

public class SiteNodeVO
implements BaseEntityVO {
    private Integer siteNodeId = null;
    private String name = "";
    private Date publishDateTime = new Date();
    private Date expireDateTime = new Date();
    private Boolean isBranch = new Boolean(false);
    private Integer repositoryId = null;
    private Integer siteNodeTypeDefinitionId = null;
    private Integer childCount;
    private String creatorName;
    private Integer metaInfoContentId = new Integer(-1);
    private Integer parentSiteNodeId = null;
    private Map extraProperties = new Hashtable();
    private static SimpleTimeZone stmz = new SimpleTimeZone(-28800000, "GMT");

    public SiteNodeVO() {
        Calendar calendar = Calendar.getInstance(stmz);
        int years = 50;
        try {
            String numberOfYears = CmsPropertyHandler.getDefaultNumberOfYearsBeforeExpire();
            if (numberOfYears != null && !numberOfYears.equals("")) {
                years = new Integer(numberOfYears);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        calendar.add(1, years);
        this.expireDateTime = calendar.getTime();
    }

    public Integer getChildCount() {
        return this.childCount;
    }

    public void setChildCount(Integer childCount) {
        this.childCount = childCount;
    }

    public Integer getSiteNodeId() {
        return this.siteNodeId;
    }

    public void setSiteNodeId(Integer siteNodeId) {
        this.siteNodeId = siteNodeId;
    }

    public String getName() {
        return this.name;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public void setSiteNodeTypeDefinitionId(Integer siteNodeTypeDefinitionId) {
        this.siteNodeTypeDefinitionId = siteNodeTypeDefinitionId;
    }

    public Integer getSiteNodeTypeDefinitionId() {
        return this.siteNodeTypeDefinitionId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getPublishDateTime() {
        return this.publishDateTime;
    }

    public void setPublishDateTime(Date publishDateTime) {
        this.publishDateTime = publishDateTime;
    }

    public Date getExpireDateTime() {
        return this.expireDateTime;
    }

    public void setExpireDateTime(Date expireDateTime) {
        this.expireDateTime = expireDateTime;
    }

    public Boolean getIsBranch() {
        return this.isBranch;
    }

    public void setIsBranch(Boolean isBranch) {
        this.isBranch = isBranch;
    }

    public Integer getMetaInfoContentId() {
        return this.metaInfoContentId;
    }

    public void setMetaInfoContentId(Integer metaInfoContentId) {
        this.metaInfoContentId = metaInfoContentId;
    }

    public Integer getId() {
        return this.getSiteNodeId();
    }

    public ConstraintExceptionBuffer validate() {
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ValidatorFactory.createStringValidator("SiteNode.name", true, 2, 100).validate(this.name, ceb);
        if (this.publishDateTime.after(this.expireDateTime)) {
            ceb.add(new ConstraintException("SiteNode.publishDateTime", "308"));
        }
        return ceb;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public Map getExtraProperties() {
        return this.extraProperties;
    }

    public Integer getParentSiteNodeId() {
        return this.parentSiteNodeId;
    }

    public void setParentSiteNodeId(Integer parentSiteNodeId) {
        this.parentSiteNodeId = parentSiteNodeId;
    }
}

