/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.entities.publishing;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class EditionBrowser
implements Serializable {
    private int totalEditions = 0;
    private int startIndex = 0;
    private int pageSize = 0;
    private int totalPages = 0;
    private int currentPage = 0;
    private List editions = new ArrayList();

    public EditionBrowser(int totalEditions, int pageSize, int startIndex) {
        this.totalEditions = totalEditions;
        this.pageSize = pageSize;
        this.startIndex = startIndex;
        this.init();
    }

    private void init() {
        BigDecimal total = new BigDecimal(this.totalEditions);
        BigDecimal page = new BigDecimal(this.pageSize);
        BigDecimal start = new BigDecimal((double)this.startIndex + 0.5);
        this.totalPages = Math.max(1, total.divide(page, 0, 0).intValue());
        this.currentPage = start.divide(page, 0, 0).intValue();
    }

    public int getTotalEditions() {
        return this.totalEditions;
    }

    public void setTotalEditions(int i) {
        this.totalEditions = i;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int i) {
        this.startIndex = i;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int i) {
        this.pageSize = i;
    }

    public List getEditions() {
        return this.editions;
    }

    public void setEditions(List c) {
        this.editions = c != null ? c : new ArrayList();
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public boolean hasPreviousPage() {
        return this.getPreviousPageSize() != 0;
    }

    public boolean hasNextPage() {
        return this.getNextPageSize() != 0;
    }

    public int getPreviousPageSize() {
        return Math.min(this.pageSize, Math.max(0, this.startIndex));
    }

    public int getNextPageSize() {
        return Math.min(this.pageSize, Math.max(0, this.totalEditions - (this.startIndex + this.pageSize)));
    }

    public int getPreviousPageIndex() {
        return this.getStartIndex() - this.getPreviousPageSize();
    }

    public int getNextPageIndex() {
        return this.getStartIndex() + this.getEditions().size();
    }
}

