/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.entities.mydesktop;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.mydesktop.WorkflowActionVO;
import org.infoglue.cms.entities.mydesktop.WorkflowStepVO;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.workflow.StepFilter;

public class WorkflowVO
implements BaseEntityVO {
    private static final long serialVersionUID = 1L;
    public static final int STATUS_OK = 0;
    public static final int STATUS_NOT_OK = 1;
    private Long workflowId;
    private String name;
    private String title;
    private List declaredSteps = new ArrayList();
    private List currentSteps = new ArrayList();
    private List historySteps = new ArrayList();
    private List initialActions = new ArrayList();
    private List globalActions = new ArrayList();
    private int status = 0;
    private String statusMessage = "";

    public WorkflowVO() {
    }

    public WorkflowVO(Long workflowId, String name) {
        this.setWorkflowId(workflowId);
        this.setName(name);
    }

    public Integer getId() {
        return new Integer(this.workflowId.intValue());
    }

    public void setId(Integer id) {
        this.setWorkflowId(new Long(id.longValue()));
    }

    public long getIdAsPrimitive() {
        return this.workflowId == null ? 0L : this.workflowId;
    }

    public Long getWorkflowId() {
        return this.workflowId;
    }

    public void setWorkflowId(Long workflowId) {
        this.workflowId = workflowId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List getDeclaredSteps() {
        return this.declaredSteps;
    }

    public void setDeclaredSteps(List steps) {
        this.declaredSteps = steps == null ? new ArrayList() : steps;
    }

    public List getCurrentSteps() {
        return this.currentSteps;
    }

    public List getCurrentSteps(StepFilter filter) {
        ArrayList<WorkflowStepVO> filteredSteps = new ArrayList<WorkflowStepVO>();
        for (WorkflowStepVO step : this.currentSteps) {
            if (!filter.isAllowed(step)) continue;
            filteredSteps.add(step);
        }
        return filteredSteps;
    }

    public void setCurrentSteps(List steps) {
        this.currentSteps = steps == null ? new ArrayList() : steps;
    }

    public List getHistorySteps() {
        return this.historySteps;
    }

    public void setHistorySteps(List steps) {
        this.historySteps = steps == null ? new ArrayList() : steps;
    }

    public List getInitialActions() {
        return this.initialActions;
    }

    public void setInitialActions(List actions) {
        this.initialActions = actions == null ? new ArrayList() : actions;
    }

    public List getGlobalActions() {
        return this.globalActions;
    }

    public void setGlobalActions(List actions) {
        this.globalActions = actions == null ? new ArrayList() : actions;
    }

    public List getSteps() {
        ArrayList steps = new ArrayList();
        steps.addAll(this.currentSteps);
        steps.addAll(this.historySteps);
        return steps;
    }

    public List getAvailableActions() {
        return this.getAvailableActions(null);
    }

    public List getAvailableActions(StepFilter filter) {
        List steps = filter == null ? this.currentSteps : this.getCurrentSteps(filter);
        ArrayList availableActions = new ArrayList();
        Iterator i = steps.iterator();
        while (i.hasNext()) {
            availableActions.addAll(((WorkflowStepVO)i.next()).getActions());
        }
        return availableActions;
    }

    public WorkflowActionVO getInitialAction(Integer id) {
        for (WorkflowActionVO action : this.initialActions) {
            if (!id.equals(action.getId())) continue;
            return action;
        }
        throw new IllegalArgumentException("Initial action " + id + " does not exist in workflow " + this.name);
    }

    public String toString() {
        return new StringBuffer(this.getClass().getName()).append(" name=").append(this.name).append(" workflowId=").append(this.workflowId).append(" declaredSteps=").append(this.declaredSteps.size()).append(" currentSteps=").append(this.currentSteps.size()).append(" historySteps=").append(this.historySteps.size()).append(" historySteps=").append(this.historySteps.size()).append(" globalActions=").append(this.globalActions.size()).toString();
    }

    public ConstraintExceptionBuffer validate() {
        return new ConstraintExceptionBuffer();
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }
}

