/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.entities.management;

import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.kernel.ValidatableEntityVO;
import org.infoglue.cms.entities.management.impl.simple.SystemUserImpl;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.validators.ConstraintRule;
import org.infoglue.cms.util.validators.EmailValidator;
import org.infoglue.cms.util.validators.Range;
import org.infoglue.cms.util.validators.StringValidator;

public class SystemUserVO
extends ValidatableEntityVO
implements BaseEntityVO {
    private long timeStamp = 0L;
    private String userName;
    private String password;
    private String firstName;
    private String lastName;
    private String email;

    public Integer getId() {
        return null;
    }

    public String toString() {
        return String.valueOf(this.getFirstName()) + " " + this.getLastName();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void PrepareValidation() {
        this.rules.setEntityClass(SystemUserImpl.class);
        ConstraintRule cr = new ConstraintRule(0, "SystemUser.userName");
        cr.setValidRange(new Range(2, 20));
        cr.unique = true;
        cr.required = true;
        cr.setValue(this.userName);
        this.rules.addRule(cr);
        cr = new ConstraintRule(0, "SystemUser.password");
        cr.setValidRange(new Range(4, 15));
        cr.required = true;
        cr.setValue(this.password);
        this.rules.addRule(cr);
        cr = new ConstraintRule(0, "SystemUser.firstName");
        cr.setValidRange(new Range(1, 30));
        cr.required = true;
        cr.setValue(this.firstName);
        this.rules.addRule(cr);
        cr = new ConstraintRule(0, "SystemUser.lastName");
        cr.setValidRange(new Range(1, 30));
        cr.required = true;
        cr.setValue(this.lastName);
        this.rules.addRule(cr);
        cr = new ConstraintRule(1, "SystemUser.email");
        cr.setValidRange(new Range(50));
        cr.required = true;
        cr.setValue(this.email);
        this.rules.addRule(cr);
    }

    public ConstraintExceptionBuffer validate(ValidatableEntityVO vo) {
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        vo.PrepareValidation();
        for (ConstraintRule cr : vo.getConstraintRules()) {
            String userName = ((SystemUserVO)vo).getUserName();
            switch (cr.getConstraintType()) {
                case 1: {
                    if (cr.getValue() == null) break;
                    StringValidator v = new EmailValidator(cr.getFieldName());
                    v.setObjectClass(vo.getConstraintRuleList().getEntityClass());
                    v.setRange(cr.getValidRange());
                    v.setIsRequired(cr.required);
                    v.setMustBeUnique(cr.unique);
                    v.setExcludeId(null);
                    v.setExcludeObject(userName);
                    v.validate((String)cr.getValue(), ceb);
                    break;
                }
                case 0: {
                    if (cr.getValue() == null) break;
                    StringValidator v = new StringValidator(cr.getFieldName());
                    v.setObjectClass(vo.getConstraintRuleList().getEntityClass());
                    v.setRange(cr.getValidRange());
                    v.setIsRequired(cr.required);
                    v.setMustBeUnique(cr.unique);
                    v.setExcludeId(null);
                    v.setExcludeObject(userName);
                    v.validate((String)cr.getValue(), ceb);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
        return ceb;
    }
}

