/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.entities.management;

import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.impl.simple.ServiceDefinitionImpl;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.validators.ValidatorFactory;

public class ServiceDefinitionVO
implements BaseEntityVO {
    private Integer serviceDefinitionId;
    private String className;
    private String name;
    private String description;

    public String toString() {
        return this.getName();
    }

    public Integer getId() {
        return this.getServiceDefinitionId();
    }

    public Integer getServiceDefinitionId() {
        return this.serviceDefinitionId;
    }

    public void setServiceDefinitionId(Integer serviceDefinitionId) {
        this.serviceDefinitionId = serviceDefinitionId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) throws ConstraintException {
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ValidatorFactory.createStringValidator("ServiceDefinition.name", true, 4, 50).validate(name, ceb);
        ceb.throwIfNotEmpty();
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) throws ConstraintException {
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ValidatorFactory.createStringValidator("ServiceDefinition.description", true, 4, 255).validate(description, ceb);
        ceb.throwIfNotEmpty();
        this.description = description;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) throws ConstraintException {
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ValidatorFactory.createStringValidator("ServiceDefinition.className", true, 4, 100).validate(className, ceb);
        ceb.throwIfNotEmpty();
        this.className = className;
    }

    public ConstraintExceptionBuffer validate() {
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        if (this.name != null) {
            ValidatorFactory.createStringValidator("ServiceDefinition.name", true, 4, 50, true, ServiceDefinitionImpl.class, this.getId(), null).validate(this.name, ceb);
        }
        return ceb;
    }
}

