/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.entities.management;

import java.util.Locale;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.impl.simple.LanguageImpl;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.validators.ValidatorFactory;
import org.infoglue.deliver.controllers.kernel.impl.simple.LanguageDeliveryController;

public class LanguageVO
implements BaseEntityVO {
    private Integer languageId;
    private String name;
    private String languageCode;
    private String charset = "ISO-8859-1";

    public String toString() {
        return this.getName();
    }

    public Integer getId() {
        return this.getLanguageId();
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(Integer languageId) {
        this.languageId = languageId;
    }

    public String getName() {
        return this.name;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setName(String name) throws ConstraintException {
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ValidatorFactory.createStringValidator("Language.name", true, 4, 20).validate(name, ceb);
        ceb.throwIfNotEmpty();
        this.name = name;
    }

    public void setLanguageCode(String languageCode) throws ConstraintException {
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ValidatorFactory.createStringValidator("Language.languageCode", true, 2, 6).validate(languageCode, ceb);
        ceb.throwIfNotEmpty();
        this.languageCode = languageCode;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public ConstraintExceptionBuffer validate() {
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        if (this.name != null) {
            ValidatorFactory.createStringValidator("Language.name", true, 4, 20, true, LanguageImpl.class, this.getId(), null).validate(this.name, ceb);
        }
        if (this.languageCode != null) {
            ValidatorFactory.createStringValidator("Language.languageCode", true, 2, 6, true, LanguageImpl.class, this.getId(), null).validate(this.languageCode, ceb);
        }
        return ceb;
    }

    public boolean equals(Object o) {
        LanguageVO languageVO;
        boolean equals = false;
        if (o instanceof LanguageVO && (languageVO = (LanguageVO)o) != null && languageVO.getLanguageId().equals(this.languageId)) {
            equals = true;
        }
        return equals;
    }

    public int hashCode() {
        return this.languageId;
    }

    public Locale getLocale() {
        return LanguageDeliveryController.getLanguageDeliveryController().getLocaleWithCode(this.languageCode);
    }

    public String getDisplayLanguage() {
        Locale locale = this.getLocale();
        return locale.getDisplayLanguage();
    }

    public String getLocalizedDisplayLanguage() {
        Locale locale = this.getLocale();
        return locale.getDisplayLanguage(locale);
    }
}

