/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.entities.management;

import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.validators.ValidatorFactory;

public class InterceptionPointVO
implements BaseEntityVO {
    private Integer interceptionPointId;
    private String category;
    private String name;
    private String description;
    private Boolean usesExtraDataForAccessControl;

    public InterceptionPointVO() {
    }

    public InterceptionPointVO(String category, String name, String description, boolean usesExtraDataForAccessControl) {
        this.category = category;
        this.name = name;
        this.description = description;
        this.usesExtraDataForAccessControl = new Boolean(usesExtraDataForAccessControl);
    }

    public Integer getInterceptionPointId() {
        return this.interceptionPointId;
    }

    public void setInterceptionPointId(Integer interceptionPointId) {
        this.interceptionPointId = interceptionPointId;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getUsesExtraDataForAccessControl() {
        return this.usesExtraDataForAccessControl;
    }

    public void setUsesExtraDataForAccessControl(Boolean usesExtraDataForAccessControl) {
        this.usesExtraDataForAccessControl = usesExtraDataForAccessControl;
    }

    public String toString() {
        return String.valueOf(this.getCategory()) + ":" + this.getName();
    }

    public Integer getId() {
        return this.getInterceptionPointId();
    }

    public ConstraintExceptionBuffer validate() {
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ValidatorFactory.createStringValidator("InterceptionPoint.name", true, 2, 100).validate(this.name, ceb);
        ValidatorFactory.createStringValidator("InterceptionPoint.category", true, 2, 30).validate(this.category, ceb);
        ValidatorFactory.createStringValidator("InterceptionPoint.description", true, 2, 100).validate(this.description, ceb);
        return ceb;
    }
}

