/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.entities.management;

import java.util.ArrayList;
import java.util.List;
import org.infoglue.cms.entities.kernel.Persistent;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.DomainUtils;
import org.infoglue.cms.util.validators.ValidatorFactory;

public class CategoryVO
extends Persistent {
    private Integer categoryId;
    private String name;
    private String description;
    private boolean active = true;
    private Integer parentId;
    private List children = new ArrayList();
    private String categoryPath = null;

    public CategoryVO() {
    }

    public CategoryVO(String name) {
        this.setName(name);
    }

    public CategoryVO(Integer id, String name) {
        this(name);
        this.setCategoryId(id);
    }

    public Integer getId() {
        return this.getCategoryId();
    }

    public Integer getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Integer i) {
        this.categoryId = i;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String s) {
        this.description = s;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean b) {
        this.active = b;
    }

    public Integer getParentId() {
        return this.parentId;
    }

    public void setParentId(Integer i) {
        this.parentId = i;
    }

    public List getChildren() {
        return this.children;
    }

    public void setChildren(List l) {
        this.children = l;
    }

    public boolean isRoot() {
        return this.getParentId() == null;
    }

    public ConstraintExceptionBuffer validate() {
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ValidatorFactory.createStringValidator("Category.name", true, 1, 100).validate(this.name, ceb);
        ValidatorFactory.createStringValidator("Category.description", false, 255).validate(this.description, ceb);
        return ceb;
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            CategoryVO category = (CategoryVO)o;
            return DomainUtils.equals(this.categoryId, category.categoryId) && DomainUtils.equals(this.name, category.name) && DomainUtils.equals(this.description, category.description) && DomainUtils.equals(this.parentId, category.parentId) && this.children.size() == category.children.size() && this.active == category.active;
        }
        return false;
    }

    public StringBuffer toStringBuffer() {
        StringBuffer sb = super.toStringBuffer();
        sb.append(" name=").append(this.name).append(" description=").append(this.description).append(" active=").append(this.active).append(" parentId=").append(this.parentId).append(" children.size=").append(this.children.size());
        return sb;
    }

    public String getCategoryPath() {
        return this.categoryPath;
    }

    public void setCategoryPath(String categoryPath) {
        this.categoryPath = categoryPath;
    }
}

