/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.entities.kernel;

import java.util.Collection;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.validators.ConstraintRule;
import org.infoglue.cms.util.validators.ConstraintRuleList;
import org.infoglue.cms.util.validators.EmailValidator;
import org.infoglue.cms.util.validators.StringValidator;

public abstract class ValidatableEntityVO
implements BaseEntityVO {
    protected ConstraintRuleList rules = new ConstraintRuleList();

    public ConstraintRule getRule(String fieldName) {
        return this.rules.getRule(fieldName);
    }

    public Collection getConstraintRules() {
        return this.rules.getRules();
    }

    public ConstraintRuleList getConstraintRuleList() {
        return this.rules;
    }

    public abstract void PrepareValidation();

    public ConstraintExceptionBuffer validate() {
        return this.validate(this);
    }

    public ConstraintExceptionBuffer validate(ValidatableEntityVO vo) {
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        vo.PrepareValidation();
        for (ConstraintRule cr : vo.getConstraintRules()) {
            Integer intId = vo.getId();
            switch (cr.getConstraintType()) {
                case 1: {
                    if (cr.getValue() == null) break;
                    StringValidator v = new EmailValidator(cr.getFieldName());
                    v.setObjectClass(vo.getConstraintRuleList().getEntityClass());
                    v.setRange(cr.getValidRange());
                    v.setIsRequired(cr.required);
                    v.setMustBeUnique(cr.unique);
                    v.setExcludeId(intId);
                    v.validate((String)cr.getValue(), ceb);
                    break;
                }
                case 0: {
                    if (cr.getValue() == null) break;
                    StringValidator v = new StringValidator(cr.getFieldName());
                    v.setObjectClass(vo.getConstraintRuleList().getEntityClass());
                    v.setRange(cr.getValidRange());
                    v.setIsRequired(cr.required);
                    v.setMustBeUnique(cr.unique);
                    v.setExcludeId(intId);
                    v.validate((String)cr.getValue(), ceb);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
        return ceb;
    }
}

