/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.entities.content.impl.simple;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Collection;
import org.infoglue.cms.entities.content.DigitalAsset;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.entities.kernel.BaseEntityVO;

public class DigitalAssetImpl
implements DigitalAsset {
    private DigitalAssetVO valueObject = new DigitalAssetVO();
    private byte[] assetBytes = null;
    private Collection contentVersions;
    private Collection userProperties;
    private Collection roleProperties;
    private Collection groupProperties;
    private InputStream assetBlob;
    private boolean assetBlobRead = false;

    public BaseEntityVO getVO() {
        return this.getValueObject();
    }

    public void setVO(BaseEntityVO valueObject) {
        this.setValueObject((DigitalAssetVO)valueObject);
    }

    public Integer getId() {
        return this.getDigitalAssetId();
    }

    public Object getIdAsObject() {
        return this.getId();
    }

    public DigitalAssetVO getValueObject() {
        return this.valueObject;
    }

    public void setValueObject(DigitalAssetVO valueObject) {
        this.valueObject = valueObject;
    }

    public Integer getDigitalAssetId() {
        return this.valueObject.getDigitalAssetId();
    }

    public void setDigitalAssetId(Integer digitalAssetId) {
        this.valueObject.setDigitalAssetId(digitalAssetId);
    }

    public String getAssetFileName() {
        return this.valueObject.getAssetFileName();
    }

    public void setAssetFileName(String assetFileName) {
        this.valueObject.setAssetFileName(assetFileName);
    }

    public String getAssetKey() {
        return this.valueObject.getAssetKey();
    }

    public void setAssetKey(String assetKey) {
        this.valueObject.setAssetKey(assetKey);
    }

    public String getAssetFilePath() {
        return this.valueObject.getAssetFilePath();
    }

    public void setAssetFilePath(String assetFilePath) {
        this.valueObject.setAssetFilePath(assetFilePath);
    }

    public String getAssetContentType() {
        return this.valueObject.getAssetContentType();
    }

    public void setAssetContentType(String assetContentType) {
        this.valueObject.setAssetContentType(assetContentType);
    }

    public Integer getAssetFileSize() {
        return this.valueObject.getAssetFileSize();
    }

    public void setAssetFileSize(Integer assetFileSize) {
        this.valueObject.setAssetFileSize(assetFileSize);
    }

    public Collection getContentVersions() {
        return this.contentVersions;
    }

    public void setContentVersions(Collection contentVersions) {
        this.contentVersions = contentVersions;
    }

    public Collection getUserProperties() {
        return this.userProperties;
    }

    public void setUserProperties(Collection userProperties) {
        this.userProperties = userProperties;
    }

    public Collection getRoleProperties() {
        return this.roleProperties;
    }

    public void setRoleProperties(Collection roleProperties) {
        this.roleProperties = roleProperties;
    }

    public Collection getGroupProperties() {
        return this.groupProperties;
    }

    public void setGroupProperties(Collection groupProperties) {
        this.groupProperties = groupProperties;
    }

    public void setAssetBlob(InputStream assetBlob) {
        this.assetBlob = assetBlob;
    }

    public synchronized InputStream getAssetBlob() {
        InputStream inputStream = null;
        inputStream = this.assetBytes != null ? new ByteArrayInputStream(this.assetBytes) : this.assetBlob;
        this.assetBlobRead = true;
        return inputStream;
    }

    public void setAssetBytes(byte[] bytes) {
        this.setAssetBlob(new ByteArrayInputStream(bytes));
    }

    public byte[] getAssetBytes() {
        if (this.assetBytes == null) {
            try {
                int character;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                BufferedInputStream bis = new BufferedInputStream(this.getAssetBlob());
                while ((character = bis.read()) != -1) {
                    byteArrayOutputStream.write(character);
                }
                byteArrayOutputStream.flush();
                bis.close();
                byteArrayOutputStream.close();
                this.assetBytes = byteArrayOutputStream.toByteArray();
            }
            catch (Exception e) {
                System.out.println("The asset with id:" + this.getId() + " had no assetBlob or an error occurred when we tried to get it:" + e.getMessage());
            }
        }
        return this.assetBytes;
    }

    public boolean getIsAssetBlobRead() {
        return this.assetBlobRead;
    }
}

