/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.entities.content;

import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.SimpleTimeZone;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.validators.ValidatorFactory;

public class ContentVO
implements BaseEntityVO {
    public static final Integer NO = new Integer(0);
    public static final Integer YES = new Integer(1);
    public static final Integer INHERITED = new Integer(2);
    private Integer contentId;
    private String name = "";
    private Date publishDateTime = new Date();
    private Date expireDateTime = new Date();
    private Boolean isBranch = new Boolean(false);
    private Integer isProtected = INHERITED;
    private Integer repositoryId = null;
    private Integer contentTypeDefinitionId = null;
    private Integer parentContentId = null;
    private Integer childCount;
    private String creatorName;
    private String fullPath = null;
    private String[] versions = new String[0];
    private ContentVersionVO contentVersionVO;
    private static SimpleTimeZone stmz = new SimpleTimeZone(-28800000, "GMT");
    private Map extraProperties = new Hashtable();

    public ContentVO() {
        Calendar calendar = Calendar.getInstance(stmz);
        int years = 50;
        try {
            String numberOfYears = CmsPropertyHandler.getDefaultNumberOfYearsBeforeExpire();
            if (numberOfYears != null && !numberOfYears.equals("")) {
                years = new Integer(numberOfYears);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        calendar.add(1, years);
        this.expireDateTime = calendar.getTime();
    }

    public Integer getId() {
        return this.getContentId();
    }

    public Integer getContentId() {
        return this.contentId;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public void setContentId(Integer contentId) {
        this.contentId = contentId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getPublishDateTime() {
        return this.publishDateTime;
    }

    public void setPublishDateTime(Date publishDateTime) {
        this.publishDateTime = publishDateTime;
    }

    public Date getExpireDateTime() {
        return this.expireDateTime;
    }

    public void setExpireDateTime(Date expireDateTime) {
        this.expireDateTime = expireDateTime;
    }

    public Boolean getIsBranch() {
        return this.isBranch;
    }

    public void setIsBranch(Boolean isBranch) {
        this.isBranch = isBranch;
    }

    public ConstraintExceptionBuffer validate() {
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ValidatorFactory.createStringValidator("Content.name", true, 2, 100).validate(this.name, ceb);
        if (this.publishDateTime == null) {
            ceb.add(new ConstraintException("Content.publishDateTime", "300"));
        }
        if (this.expireDateTime == null) {
            ceb.add(new ConstraintException("Content.expireDateTime", "300"));
        }
        if (this.publishDateTime != null && this.expireDateTime != null && this.publishDateTime.after(this.expireDateTime)) {
            ceb.add(new ConstraintException("Content.publishDateTime", "308"));
        }
        return ceb;
    }

    public Integer getChildCount() {
        return this.childCount;
    }

    public void setChildCount(Integer childCount) {
        this.childCount = childCount;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public Integer getIsProtected() {
        return this.isProtected;
    }

    public void setIsProtected(Integer isProtected) {
        this.isProtected = isProtected;
    }

    public Integer getContentTypeDefinitionId() {
        return this.contentTypeDefinitionId;
    }

    public void setContentTypeDefinitionId(Integer contentTypeDefinitionId) {
        this.contentTypeDefinitionId = contentTypeDefinitionId;
    }

    public Integer getParentContentId() {
        return this.parentContentId;
    }

    public void setParentContentId(Integer parentContentId) {
        this.parentContentId = parentContentId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("id=").append(this.contentId).append(" name=").append(this.name).append(" publishDateTime=").append(this.publishDateTime).append(" expireDateTime=").append(this.expireDateTime).append(" isBranch=").append(this.isBranch).append(" isProtected=").append(this.isProtected).append(" repositoryId=").append(this.repositoryId).append(" contentTypeDefinitionId=").append(this.contentTypeDefinitionId).append(" parentContentId=").append(this.parentContentId).append(" creatorName=").append(this.creatorName);
        return sb.toString();
    }

    public Map getExtraProperties() {
        return this.extraProperties;
    }

    public void setExtraProperties(Map extraProperties) {
        this.extraProperties = extraProperties;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public void setVersions(String[] versions) {
        this.versions = versions;
    }

    public String[] getVersions() {
        return this.versions;
    }

    public ContentVersionVO getContentVersion() {
        return this.contentVersionVO;
    }

    public void setContentVersion(ContentVersionVO contentVersionVO) {
        this.contentVersionVO = contentVersionVO;
    }
}

