/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.usecases.structuretool.impl.simple;

import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseUCCController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.controllers.usecases.structuretool.ViewSiteNodeVersionUCC;
import org.infoglue.cms.entities.structure.SiteNodeVersion;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class ViewSiteNodeVersionUCCImpl
extends BaseUCCController
implements ViewSiteNodeVersionUCC {
    private static final Logger logger = Logger.getLogger((String)ViewSiteNodeVersionUCCImpl.class.getName());

    public SiteNodeVersionVO viewSiteNodeVersion(Integer siteNodeVersionId) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNodeVersion siteNodeVersion = null;
        this.beginTransaction(db);
        try {
            siteNodeVersion = SiteNodeVersionController.getController().getSiteNodeVersionWithId(siteNodeVersionId, db);
            ceb.throwIfNotEmpty();
            this.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            this.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            this.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return siteNodeVersion.getValueObject();
    }
}

