/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.usecases.structuretool.impl.simple;

import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseUCCController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.usecases.structuretool.ViewSiteNodeUCC;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class ViewSiteNodeUCCImpl
extends BaseUCCController
implements ViewSiteNodeUCC {
    private static final Logger logger = Logger.getLogger((String)ViewSiteNodeUCCImpl.class.getName());

    public SiteNodeVO viewSiteNode(Integer siteNodeId) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNode siteNode = null;
        this.beginTransaction(db);
        try {
            siteNode = SiteNodeController.getController().getSiteNodeWithId(siteNodeId, db);
            ceb.throwIfNotEmpty();
            this.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            this.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            this.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return siteNode.getValueObject();
    }
}

