/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.usecases.structuretool.impl.simple;

import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseUCCController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeTypeDefinitionController;
import org.infoglue.cms.controllers.usecases.structuretool.ViewSiteNodeTreeUCC;
import org.infoglue.cms.entities.management.Repository;
import org.infoglue.cms.entities.management.SiteNodeTypeDefinition;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class ViewSiteNodeTreeUCCImpl
extends BaseUCCController
implements ViewSiteNodeTreeUCC {
    private static final Logger logger = Logger.getLogger((String)ViewSiteNodeTreeUCCImpl.class.getName());

    public SiteNodeVO getRootSiteNode(Integer repositoryId, InfoGluePrincipal infoGluePrincipal) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNodeVO siteNodeVO = null;
        this.beginTransaction(db);
        try {
            logger.info((Object)("Fetching the root siteNode for the repository " + repositoryId));
            OQLQuery oql = db.getOQLQuery("SELECT c FROM org.infoglue.cms.entities.structure.impl.simple.SiteNodeImpl c WHERE is_undefined(c.parentSiteNode) AND c.repository.repositoryId = $1");
            oql.bind((Object)repositoryId);
            QueryResults results = oql.execute((short)0);
            if (results.hasMore()) {
                siteNodeVO = ((SiteNode)results.next()).getValueObject();
            } else {
                logger.info((Object)"Found no rootSiteNode so we create a new....");
                SiteNodeVO rootSiteNodeVO = new SiteNodeVO();
                Repository repository = RepositoryController.getController().getRepositoryWithId(repositoryId, db);
                rootSiteNodeVO.setName(repository.getName());
                rootSiteNodeVO.setIsBranch(new Boolean(true));
                rootSiteNodeVO.setMetaInfoContentId(new Integer(-1));
                List siteNodeTypeDefintionList = SiteNodeTypeDefinitionController.getController().getSiteNodeTypeDefinitionList(db);
                Integer siteNodeTypeDefintionId = null;
                if (siteNodeTypeDefintionList != null && siteNodeTypeDefintionList.size() == 1) {
                    siteNodeTypeDefintionId = ((SiteNodeTypeDefinition)siteNodeTypeDefintionList.get(0)).getId();
                }
                SiteNode siteNode = SiteNodeController.getController().create(db, null, siteNodeTypeDefintionId, infoGluePrincipal, repositoryId, rootSiteNodeVO);
                SiteNodeVO newSiteNodeVO = siteNodeVO = siteNode.getValueObject();
                SiteNodeController.getController().createSiteNodeMetaInfoContent(db, siteNode, repositoryId, infoGluePrincipal, null);
            }
            results.close();
            oql.close();
            ceb.throwIfNotEmpty();
            this.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            this.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            this.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return siteNodeVO;
    }

    public SiteNodeVO getSiteNode(Integer siteNodeId) throws ConstraintException, SystemException {
        return SiteNodeController.getController().getSiteNodeVOWithId(siteNodeId);
    }

    public List getSiteNodeChildren(Integer parentSiteNodeId) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        List childrenVOList = null;
        this.beginTransaction(db);
        try {
            SiteNode siteNode = SiteNodeController.getSiteNodeWithId(parentSiteNodeId, db, true);
            Collection children = siteNode.getChildSiteNodes();
            childrenVOList = SiteNodeController.toVOList(children);
            ceb.throwIfNotEmpty();
            this.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            this.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            this.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return childrenVOList;
    }
}

