/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.usecases.structuretool.impl.simple;

import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseUCCController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionControllerProxy;
import org.infoglue.cms.controllers.usecases.structuretool.UpdateSiteNodeUCC;
import org.infoglue.cms.entities.management.impl.simple.SiteNodeTypeDefinitionImpl;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.exception.AccessConstraintException;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.DateHelper;

public class UpdateSiteNodeUCCImpl
extends BaseUCCController
implements UpdateSiteNodeUCC {
    private static final Logger logger = Logger.getLogger((String)UpdateSiteNodeUCCImpl.class.getName());

    public SiteNodeVO updateSiteNode(InfoGluePrincipal infoGluePrincipal, SiteNodeVO siteNodeVO, SiteNodeVersionVO updatedSiteNodeVersionVO) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNode siteNode = null;
        this.beginTransaction(db);
        try {
            siteNode = SiteNodeController.getController().getSiteNodeWithId(siteNodeVO.getSiteNodeId(), db);
            siteNode.setValueObject(siteNodeVO);
            SiteNodeVersionVO latestSiteNodeVersionVO = SiteNodeVersionController.getController().getLatestSiteNodeVersion(db, siteNodeVO.getSiteNodeId(), false).getValueObject();
            latestSiteNodeVersionVO.setContentType(updatedSiteNodeVersionVO.getContentType());
            latestSiteNodeVersionVO.setPageCacheKey(updatedSiteNodeVersionVO.getPageCacheKey());
            latestSiteNodeVersionVO.setPageCacheTimeout(updatedSiteNodeVersionVO.getPageCacheTimeout());
            latestSiteNodeVersionVO.setDisableEditOnSight(updatedSiteNodeVersionVO.getDisableEditOnSight());
            latestSiteNodeVersionVO.setDisablePageCache(updatedSiteNodeVersionVO.getDisablePageCache());
            latestSiteNodeVersionVO.setDisableLanguages(updatedSiteNodeVersionVO.getDisableLanguages());
            latestSiteNodeVersionVO.setIsProtected(updatedSiteNodeVersionVO.getIsProtected());
            latestSiteNodeVersionVO.setDisableForceIdentityCheck(updatedSiteNodeVersionVO.getDisableForceIdentityCheck());
            latestSiteNodeVersionVO.setVersionModifier(updatedSiteNodeVersionVO.getVersionModifier());
            latestSiteNodeVersionVO.setModifiedDateTime(DateHelper.getSecondPreciseDate());
            SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().acUpdate(infoGluePrincipal, latestSiteNodeVersionVO, db);
            ceb.throwIfNotEmpty();
            this.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            this.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            this.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return siteNode.getValueObject();
    }

    public SiteNodeVO updateSiteNode(InfoGluePrincipal infoGluePrincipal, SiteNodeVO siteNodeVO, Integer siteNodeTypeDefinitionId, SiteNodeVersionVO updatedSiteNodeVersionVO) throws AccessConstraintException, ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNode siteNode = null;
        this.beginTransaction(db);
        try {
            siteNode = SiteNodeController.getController().getSiteNodeWithId(siteNodeVO.getSiteNodeId(), db);
            siteNode.setValueObject(siteNodeVO);
            if (siteNodeTypeDefinitionId != null) {
                siteNode.setSiteNodeTypeDefinition((SiteNodeTypeDefinitionImpl)SiteNodeTypeDefinitionController.getController().getSiteNodeTypeDefinitionWithId(siteNodeTypeDefinitionId, db));
            }
            SiteNodeVersionVO latestSiteNodeVersionVO = SiteNodeVersionController.getController().getLatestActiveSiteNodeVersion(db, siteNodeVO.getSiteNodeId()).getValueObject();
            latestSiteNodeVersionVO.setContentType(updatedSiteNodeVersionVO.getContentType());
            latestSiteNodeVersionVO.setPageCacheKey(updatedSiteNodeVersionVO.getPageCacheKey());
            latestSiteNodeVersionVO.setPageCacheTimeout(updatedSiteNodeVersionVO.getPageCacheTimeout());
            latestSiteNodeVersionVO.setDisableEditOnSight(updatedSiteNodeVersionVO.getDisableEditOnSight());
            latestSiteNodeVersionVO.setDisableLanguages(updatedSiteNodeVersionVO.getDisableLanguages());
            latestSiteNodeVersionVO.setDisablePageCache(updatedSiteNodeVersionVO.getDisablePageCache());
            latestSiteNodeVersionVO.setIsProtected(updatedSiteNodeVersionVO.getIsProtected());
            latestSiteNodeVersionVO.setDisableForceIdentityCheck(updatedSiteNodeVersionVO.getDisableForceIdentityCheck());
            latestSiteNodeVersionVO.setVersionModifier(infoGluePrincipal.getName());
            latestSiteNodeVersionVO.setModifiedDateTime(DateHelper.getSecondPreciseDate());
            SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().acUpdate(infoGluePrincipal, latestSiteNodeVersionVO, db);
            ceb.throwIfNotEmpty();
            this.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            this.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            this.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return siteNode.getValueObject();
    }
}

