/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.usecases.structuretool.impl.simple;

import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseUCCController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.usecases.structuretool.CreateSiteNodeVersionUCC;
import org.infoglue.cms.entities.structure.SiteNodeVersion;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.entities.structure.impl.simple.SiteNodeVersionImpl;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class CreateSiteNodeVersionUCCImpl
extends BaseUCCController
implements CreateSiteNodeVersionUCC {
    private static final Logger logger = Logger.getLogger((String)CreateSiteNodeVersionUCCImpl.class.getName());

    public SiteNodeVersionVO createSiteNodeVersion(SiteNodeVersionVO siteNodeVersionVO) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNodeVersion siteNodeVersion = null;
        this.beginTransaction(db);
        try {
            siteNodeVersion = this.createSiteNodeVersionEntity(db, siteNodeVersionVO);
            ceb.throwIfNotEmpty();
            this.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            this.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            this.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return siteNodeVersion.getValueObject();
    }

    private SiteNodeVersion createSiteNodeVersionEntity(Database db, SiteNodeVersionVO siteNodeVersionVO) throws SystemException {
        SiteNodeVersionImpl siteNodeVersion = null;
        try {
            siteNodeVersion = new SiteNodeVersionImpl();
            siteNodeVersion.setValueObject(siteNodeVersionVO);
            db.create((Object)siteNodeVersion);
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to create the SiteNodeVersion in the database. Reason:" + e.getMessage(), e);
        }
        return siteNodeVersion;
    }
}

