/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.List;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.workflow.WorkflowDefinition;
import org.infoglue.cms.entities.workflow.WorkflowDefinitionVO;
import org.infoglue.cms.entities.workflow.impl.simple.WorkflowDefinitionImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.deliver.util.CacheController;

public class WorkflowDefinitionController
extends BaseController {
    public static WorkflowDefinitionController getController() {
        return new WorkflowDefinitionController();
    }

    public WorkflowDefinitionVO getWorkflowDefinitionVOWithId(Integer workflowDefinitionId) throws SystemException, Bug {
        return (WorkflowDefinitionVO)WorkflowDefinitionController.getVOWithId(WorkflowDefinitionImpl.class, workflowDefinitionId);
    }

    public WorkflowDefinition getWorkflowDefinitionWithId(Integer workflowDefinitionId, Database db) throws SystemException, Bug {
        return (WorkflowDefinition)WorkflowDefinitionController.getObjectWithId(WorkflowDefinitionImpl.class, workflowDefinitionId, db);
    }

    public WorkflowDefinitionVO getWorkflowDefinitionVOWithName(String name) throws SystemException, Bug {
        WorkflowDefinitionVO workflowDefinitionVO = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            WorkflowDefinitionController.beginTransaction(db);
            WorkflowDefinition workflowDefinition = this.getWorkflowDefinitionWithName(name, db);
            if (workflowDefinition != null) {
                workflowDefinitionVO = workflowDefinition.getValueObject();
            }
            WorkflowDefinitionController.commitTransaction(db);
        }
        catch (Exception e) {
            WorkflowDefinitionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return workflowDefinitionVO;
    }

    public WorkflowDefinition getWorkflowDefinitionWithName(String name, Database db) throws SystemException, Bug {
        WorkflowDefinition workflowDefinition = null;
        try {
            OQLQuery oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.workflow.impl.simple.WorkflowDefinitionImpl f WHERE f.name = $1");
            oql.bind((Object)name);
            QueryResults results = oql.execute();
            if (results.hasMore()) {
                workflowDefinition = (WorkflowDefinition)results.next();
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch a named WorkflowDefinition. Reason:" + e.getMessage(), e);
        }
        return workflowDefinition;
    }

    public List getWorkflowDefinitionVOList() throws SystemException, Bug {
        String key = "workflowDefinitionVOList";
        List cachedWorkflowDefinitionVOList = (List)CacheController.getCachedObject("workflowCache", key);
        if (cachedWorkflowDefinitionVOList != null) {
            return cachedWorkflowDefinitionVOList;
        }
        List workflowDefinitionVOList = this.getAllVOObjects(WorkflowDefinitionImpl.class, "workflowDefinitionId");
        CacheController.cacheObject("workflowCache", key, workflowDefinitionVOList);
        return workflowDefinitionVOList;
    }

    public WorkflowDefinitionVO create(WorkflowDefinitionVO workflowDefinitionVO) throws ConstraintException, SystemException {
        WorkflowDefinition workflowDefinition = new WorkflowDefinitionImpl();
        workflowDefinition.setValueObject(workflowDefinitionVO);
        workflowDefinition = (WorkflowDefinition)WorkflowDefinitionController.createEntity(workflowDefinition);
        return workflowDefinition.getValueObject();
    }

    public void delete(WorkflowDefinitionVO workflowDefinitionVO) throws ConstraintException, SystemException {
        WorkflowDefinitionController.deleteEntity(WorkflowDefinitionImpl.class, workflowDefinitionVO.getWorkflowDefinitionId());
    }

    public WorkflowDefinitionVO update(WorkflowDefinitionVO workflowDefinitionVO) throws ConstraintException, SystemException {
        return (WorkflowDefinitionVO)WorkflowDefinitionController.updateEntity(WorkflowDefinitionImpl.class, workflowDefinitionVO);
    }

    public BaseEntityVO getNewVO() {
        return new WorkflowDefinitionVO();
    }
}

