/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.cfg.Configuration;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.UserPropertiesController;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.mydesktop.WorkflowActionVO;
import org.infoglue.cms.entities.mydesktop.WorkflowVO;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.mail.MailServiceFactory;
import org.infoglue.cms.util.workflow.WorkflowFacade;
import org.infoglue.deliver.util.CacheController;

public class WorkflowController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)UserPropertiesController.class.getName());
    private static final WorkflowController controller = new WorkflowController();
    private static SessionFactory hibernateSessionFactory;

    static {
        try {
            hibernateSessionFactory = new Configuration().configure().buildSessionFactory();
        }
        catch (HibernateException e) {
            logger.error((Object)"An exception occurred when we tried to initialize the hibernateSessionFactory", (Throwable)e);
            throw new ExceptionInInitializerError(e);
        }
    }

    public static WorkflowController getController() {
        return controller;
    }

    private WorkflowController() {
    }

    public static Map createWorkflowParameters(HttpServletRequest request) {
        HashMap<String, HttpServletRequest> parameters = new HashMap<String, HttpServletRequest>();
        parameters.putAll(request.getParameterMap());
        parameters.put("request", request);
        return parameters;
    }

    public WorkflowVO initializeWorkflow(InfoGluePrincipal principal, String name, int actionId, Map inputs) throws SystemException {
        WorkflowVO workflowVO;
        block16: {
            workflowVO = null;
            try {
                Session session = null;
                Transaction tx = null;
                try {
                    try {
                        session = hibernateSessionFactory.openSession();
                        tx = session.beginTransaction();
                        if (this.getIsAccessApproved(name, principal)) {
                            WorkflowFacade wf = new WorkflowFacade(principal, name, actionId, inputs, hibernateSessionFactory, session);
                            workflowVO = wf.createWorkflowVO();
                            session.flush();
                            tx.commit();
                            break block16;
                        }
                        throw new Bug("You are not allowed to create " + name + " workflows.");
                    }
                    catch (Exception e) {
                        logger.error((Object)("An error occurred when we tries to run initializeWorkflow():" + e.getMessage()), (Throwable)e);
                        try {
                            tx.rollback();
                        }
                        catch (HibernateException he) {
                            logger.error((Object)("An error occurred when we tries to rollback transaction:" + he.getMessage()), (Throwable)he);
                        }
                        WorkflowController.restoreSessionFactory(e);
                        try {
                            session.close();
                        }
                        catch (HibernateException e2) {
                            logger.error((Object)("An error occurred when we tries to close:" + e2.getMessage()), (Throwable)e2);
                        }
                    }
                }
                finally {
                    try {
                        session.close();
                    }
                    catch (HibernateException e) {
                        logger.error((Object)("An error occurred when we tries to close:" + e.getMessage()), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
        }
        return workflowVO;
    }

    public List getAvailableWorkflowVOList(InfoGluePrincipal userPrincipal) throws SystemException {
        ArrayList<WorkflowVO> accessibleWorkflows = new ArrayList<WorkflowVO>();
        Session session = null;
        Transaction tx = null;
        try {
            try {
                session = hibernateSessionFactory.openSession();
                tx = session.beginTransaction();
                WorkflowFacade wf = new WorkflowFacade(userPrincipal, hibernateSessionFactory, session);
                List allWorkflows = wf.getDeclaredWorkflows();
                for (WorkflowVO workflowVO : allWorkflows) {
                    if (!this.getIsAccessApproved(workflowVO.getName(), userPrincipal)) continue;
                    accessibleWorkflows.add(workflowVO);
                }
                session.flush();
                tx.commit();
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred when we tries to execute getAvailableWorkflowVOList():" + e.getMessage()), (Throwable)e);
                try {
                    tx.rollback();
                }
                catch (HibernateException he) {
                    logger.error((Object)("An error occurred when we tries to rollback transaction():" + he.getMessage()), (Throwable)he);
                }
                WorkflowController.restoreSessionFactory(e);
                try {
                    session.close();
                }
                catch (HibernateException e2) {
                    logger.error((Object)("An error occurred when we tries to close session:" + e2.getMessage()), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                session.close();
            }
            catch (HibernateException e) {
                logger.error((Object)("An error occurred when we tries to close session:" + e.getMessage()), (Throwable)e);
            }
        }
        return accessibleWorkflows;
    }

    public boolean getIsAccessApproved(String workflowName, InfoGluePrincipal infoGluePrincipal) throws SystemException {
        String protectWorkflows = CmsPropertyHandler.getProtectWorkflows();
        if (protectWorkflows == null || !protectWorkflows.equalsIgnoreCase("true")) {
            return true;
        }
        logger.info((Object)("getIsAccessApproved for " + workflowName + " AND " + infoGluePrincipal));
        boolean hasAccess = false;
        Database db = CastorDatabaseService.getDatabase();
        WorkflowController.beginTransaction(db);
        try {
            hasAccess = AccessRightController.getController().getIsPrincipalAuthorized(db, infoGluePrincipal, "Workflow.Create", workflowName);
            WorkflowController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            WorkflowController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return hasAccess;
    }

    public List getCurrentWorkflowVOList(InfoGluePrincipal userPrincipal) throws SystemException {
        List list = new ArrayList();
        Session session = null;
        Transaction tx = null;
        try {
            try {
                session = hibernateSessionFactory.openSession();
                tx = session.beginTransaction();
                WorkflowFacade wf = new WorkflowFacade(userPrincipal, hibernateSessionFactory, session);
                list = wf.getActiveWorkflows();
                session.flush();
                tx.commit();
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred when we tries to execute getCurrentWorkflowVOList():" + e.getMessage()), (Throwable)e);
                try {
                    tx.rollback();
                }
                catch (HibernateException he) {
                    logger.error((Object)("An error occurred when we tries to rollback transaction:" + he.getMessage()), (Throwable)he);
                }
                WorkflowController.restoreSessionFactory(e);
                try {
                    session.close();
                }
                catch (HibernateException e2) {
                    logger.error((Object)("An error occurred when we tries to close session:" + e2.getMessage()), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                session.close();
            }
            catch (HibernateException e) {
                logger.error((Object)("An error occurred when we tries to close session:" + e.getMessage()), (Throwable)e);
            }
        }
        return list;
    }

    public List getMyCurrentWorkflowVOList(InfoGluePrincipal userPrincipal) throws SystemException {
        List list = new ArrayList();
        Session session = null;
        Transaction tx = null;
        try {
            try {
                session = hibernateSessionFactory.openSession();
                tx = session.beginTransaction();
                WorkflowFacade wf = new WorkflowFacade(userPrincipal, hibernateSessionFactory, session);
                list = wf.getMyActiveWorkflows(userPrincipal);
                session.flush();
                tx.commit();
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred when we tries to execute getMyCurrentWorkflowVOList():" + e.getMessage()), (Throwable)e);
                try {
                    tx.rollback();
                }
                catch (HibernateException he) {
                    logger.error((Object)("An error occurred when we tries to rollback transaction:" + he.getMessage()), (Throwable)he);
                }
                WorkflowController.restoreSessionFactory(e);
                try {
                    session.close();
                }
                catch (HibernateException e2) {
                    logger.error((Object)("An error occurred when we tries to close session:" + e2.getMessage()), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                session.close();
            }
            catch (HibernateException e) {
                logger.error((Object)("An error occurred when we tries to close session:" + e.getMessage()), (Throwable)e);
            }
        }
        return list;
    }

    public WorkflowVO invokeAction(InfoGluePrincipal principal, long workflowId, int actionId, Map inputs) throws WorkflowException {
        WorkflowFacade wf;
        Transaction tx;
        Session session;
        WorkflowVO workflowVO;
        block26: {
            workflowVO = null;
            session = null;
            tx = null;
            try {
                try {
                    session = hibernateSessionFactory.openSession();
                    tx = session.beginTransaction();
                    wf = new WorkflowFacade(principal, workflowId, hibernateSessionFactory, session);
                    wf.doAction(actionId, inputs);
                    session.flush();
                    tx.commit();
                }
                catch (Exception e) {
                    logger.error((Object)("An error occurred when we tries to execute invokeAction():" + e.getMessage()), (Throwable)e);
                    try {
                        tx.rollback();
                    }
                    catch (HibernateException he) {
                        logger.error((Object)("An error occurred when we tries to rollback transaction:" + he.getMessage()), (Throwable)he);
                    }
                    WorkflowController.restoreSessionFactory(e);
                    try {
                        session.close();
                    }
                    catch (HibernateException e2) {
                        logger.error((Object)("An error occurred when we tries to close session:" + e2.getMessage()), (Throwable)e2);
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                try {
                    session.close();
                }
                catch (HibernateException e) {
                    logger.error((Object)("An error occurred when we tries to close session:" + e.getMessage()), (Throwable)e);
                }
                throw throwable;
            }
            try {
                session.close();
            }
            catch (HibernateException e) {
                logger.error((Object)("An error occurred when we tries to close session:" + e.getMessage()), (Throwable)e);
            }
        }
        try {
            try {
                session = hibernateSessionFactory.openSession();
                tx = session.beginTransaction();
                wf = new WorkflowFacade(principal, workflowId, hibernateSessionFactory, session);
                workflowVO = wf.createWorkflowVO();
                session.flush();
                tx.commit();
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred when we tries to execute invokeAction():" + e.getMessage()), (Throwable)e);
                try {
                    tx.rollback();
                }
                catch (HibernateException he) {
                    logger.error((Object)("An error occurred when we tries to rollback transaction:" + he.getMessage()), (Throwable)he);
                }
                WorkflowController.restoreSessionFactory(e);
                try {
                    session.close();
                }
                catch (HibernateException e3) {
                    logger.error((Object)("An error occurred when we tries to close session:" + e3.getMessage()), (Throwable)e3);
                }
            }
        }
        finally {
            try {
                session.close();
            }
            catch (HibernateException e) {
                logger.error((Object)("An error occurred when we tries to close session:" + e.getMessage()), (Throwable)e);
            }
        }
        return workflowVO;
    }

    public PropertySet getPropertySet(InfoGluePrincipal userPrincipal, long workflowId) {
        PropertySet propertySet = null;
        Session session = null;
        Transaction tx = null;
        try {
            try {
                session = hibernateSessionFactory.openSession();
                tx = session.beginTransaction();
                WorkflowFacade wf = new WorkflowFacade(userPrincipal, workflowId, hibernateSessionFactory, session);
                propertySet = wf.getPropertySet();
                session.flush();
                tx.commit();
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred when we tries to run getHistorySteps():" + e.getMessage()), (Throwable)e);
                try {
                    tx.rollback();
                }
                catch (HibernateException he) {
                    logger.error((Object)("An error occurred when we tries to rollback transaction:" + he.getMessage()), (Throwable)he);
                }
                WorkflowController.restoreSessionFactory(e);
                try {
                    session.close();
                }
                catch (HibernateException e2) {
                    logger.error((Object)("An error occurred when we tries to close session:" + e2.getMessage()), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                session.close();
            }
            catch (HibernateException e) {
                logger.error((Object)("An error occurred when we tries to close session:" + e.getMessage()), (Throwable)e);
            }
        }
        return propertySet;
    }

    public PropertySet getPropertySet(InfoGluePrincipal userPrincipal, long workflowId, Session session) {
        PropertySet propertySet = null;
        try {
            WorkflowFacade wf = new WorkflowFacade(userPrincipal, workflowId, hibernateSessionFactory, session);
            propertySet = wf.getPropertySet();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return propertySet;
    }

    public Map getProperties(InfoGluePrincipal userPrincipal, long workflowId) {
        if (logger.isDebugEnabled()) {
            logger.info((Object)("userPrincipal:" + userPrincipal));
            logger.info((Object)("workflowId:" + workflowId));
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        Session session = null;
        Transaction tx = null;
        try {
            try {
                session = hibernateSessionFactory.openSession();
                tx = session.beginTransaction();
                PropertySet propertySet = this.getPropertySet(userPrincipal, workflowId, session);
                for (String key : propertySet.getKeys()) {
                    parameters.put(key, propertySet.getString(key));
                }
                session.flush();
                tx.commit();
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred when we tries to run getHistorySteps():" + e.getMessage()), (Throwable)e);
                try {
                    tx.rollback();
                }
                catch (HibernateException he) {
                    logger.error((Object)("An error occurred when we tries to rollback transaction:" + he.getMessage()), (Throwable)he);
                }
                WorkflowController.restoreSessionFactory(e);
                try {
                    session.close();
                }
                catch (HibernateException e2) {
                    logger.error((Object)("An error occurred when we tries to close session:" + e2.getMessage()), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                session.close();
            }
            catch (HibernateException e) {
                logger.error((Object)("An error occurred when we tries to close session:" + e.getMessage()), (Throwable)e);
            }
        }
        return parameters;
    }

    public List getHistorySteps(InfoGluePrincipal userPrincipal, long workflowId) {
        List historySteps = new ArrayList();
        Session session = null;
        Transaction tx = null;
        try {
            try {
                session = hibernateSessionFactory.openSession();
                tx = session.beginTransaction();
                WorkflowFacade wf = new WorkflowFacade(userPrincipal, workflowId, hibernateSessionFactory, session);
                historySteps = wf.getHistorySteps();
                session.flush();
                tx.commit();
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred when we tries to run getHistorySteps():" + e.getMessage()), (Throwable)e);
                try {
                    tx.rollback();
                }
                catch (HibernateException he) {
                    logger.error((Object)("An error occurred when we tries to rollback transaction:" + he.getMessage()), (Throwable)he);
                }
                WorkflowController.restoreSessionFactory(e);
                try {
                    session.close();
                }
                catch (HibernateException e2) {
                    logger.error((Object)("An error occurred when we tries to close session:" + e2.getMessage()), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                session.close();
            }
            catch (HibernateException e) {
                logger.error((Object)("An error occurred when we tries to close session:" + e.getMessage()), (Throwable)e);
            }
        }
        return historySteps;
    }

    public List getCurrentSteps(InfoGluePrincipal userPrincipal, long workflowId) {
        List currentSteps = new ArrayList();
        Session session = null;
        Transaction tx = null;
        try {
            try {
                session = hibernateSessionFactory.openSession();
                tx = session.beginTransaction();
                WorkflowFacade wf = new WorkflowFacade(userPrincipal, workflowId, hibernateSessionFactory, session);
                currentSteps = wf.getCurrentSteps();
                session.flush();
                tx.commit();
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred when we tries to run getCurrentSteps():" + e.getMessage()), (Throwable)e);
                try {
                    tx.rollback();
                }
                catch (HibernateException he) {
                    logger.error((Object)("An error occurred when we tries to rollback transaction:" + he.getMessage()), (Throwable)he);
                }
                WorkflowController.restoreSessionFactory(e);
                try {
                    session.close();
                }
                catch (HibernateException e2) {
                    logger.error((Object)("An error occurred when we tries to close session:" + e2.getMessage()), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                session.close();
            }
            catch (HibernateException e) {
                logger.error((Object)("An error occurred when we tries to close session:" + e.getMessage()), (Throwable)e);
            }
        }
        return currentSteps;
    }

    public List getAllSteps(InfoGluePrincipal userPrincipal, long workflowId) {
        List declaredSteps = new ArrayList();
        Session session = null;
        Transaction tx = null;
        try {
            try {
                session = hibernateSessionFactory.openSession();
                tx = session.beginTransaction();
                WorkflowFacade wf = new WorkflowFacade(userPrincipal, workflowId, hibernateSessionFactory, session);
                declaredSteps = wf.getDeclaredSteps();
                session.flush();
                tx.commit();
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred when we tries to run getAllSteps():" + e.getMessage()), (Throwable)e);
                try {
                    tx.rollback();
                }
                catch (HibernateException he) {
                    logger.error((Object)("An error occurred when we tries to rollback transaction:" + he.getMessage()), (Throwable)he);
                }
                WorkflowController.restoreSessionFactory(e);
                try {
                    session.close();
                }
                catch (HibernateException e2) {
                    logger.error((Object)("An error occurred when we tries to close session:" + e2.getMessage()), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                session.close();
            }
            catch (HibernateException e) {
                logger.error((Object)("An error occurred when we tries to close session:" + e.getMessage()), (Throwable)e);
            }
        }
        return declaredSteps;
    }

    public boolean hasTerminated(InfoGluePrincipal userPrincipal, long workflowId) throws WorkflowException {
        boolean isFinished = false;
        Session session = null;
        Transaction tx = null;
        try {
            try {
                session = hibernateSessionFactory.openSession();
                tx = session.beginTransaction();
                WorkflowFacade wf = new WorkflowFacade(userPrincipal, workflowId, hibernateSessionFactory, session);
                isFinished = wf.isFinished();
                session.flush();
                tx.commit();
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred when we tries to run hasTerminated:" + e.getMessage()), (Throwable)e);
                try {
                    tx.rollback();
                }
                catch (HibernateException he) {
                    logger.error((Object)("An error occurred when we tries to rollback transaction:" + he.getMessage()), (Throwable)he);
                }
                WorkflowController.restoreSessionFactory(e);
                try {
                    session.close();
                }
                catch (HibernateException e2) {
                    logger.error((Object)("An error occurred when we tries to close session:" + e2.getMessage()), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                session.close();
            }
            catch (HibernateException e) {
                logger.error((Object)("An error occurred when we tries to close session:" + e.getMessage()), (Throwable)e);
            }
        }
        return isFinished;
    }

    public static void restoreSessionFactory(Throwable we) {
        try {
            logger.error((Object)"Restoring session factory...");
            String serverName = "Unknown";
            try {
                InetAddress localhost = InetAddress.getLocalHost();
                serverName = localhost.getHostName();
            }
            catch (Exception localhost) {
                // empty catch block
            }
            String errorMessage = "";
            String stacktrace = "";
            StringWriter sw = new StringWriter();
            if (we != null) {
                errorMessage = we.getMessage();
                we.printStackTrace(new PrintWriter(sw));
                stacktrace = sw.toString().replaceAll("(\r\n|\r|\n|\n\r)", "<br/>");
            }
            String subject = "CMS - Restoring session factory on " + serverName;
            String message = "OS Workflow had problems accessing the database or some other problem occurred. Check why the database went away or the error occurred.";
            message = String.valueOf(message) + "\n\n" + errorMessage + "\n\n" + stacktrace;
            String warningEmailReceiver = CmsPropertyHandler.getWarningEmailReceiver();
            if (warningEmailReceiver != null && !warningEmailReceiver.equals("") && warningEmailReceiver.indexOf("@warningEmailReceiver@") == -1) {
                try {
                    MailServiceFactory.getService().sendEmail(warningEmailReceiver, warningEmailReceiver, null, subject, message, "utf-8");
                }
                catch (Exception e) {
                    logger.error((Object)("Could not send mail:" + e.getMessage()), (Throwable)e);
                }
            }
            try {
                logger.info((Object)("Closing:" + hibernateSessionFactory));
                hibernateSessionFactory.close();
                CacheController.clearCache("propertySetCache");
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred when we tried to close the hibernate session factory:" + e.getMessage()));
            }
            hibernateSessionFactory = new Configuration().configure().buildSessionFactory();
            logger.info((Object)("Opened:" + hibernateSessionFactory));
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to restore the hibernate session factory:" + e.getMessage()), (Throwable)e);
        }
    }

    public BaseEntityVO getNewVO() {
        return new WorkflowActionVO();
    }
}

