/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.kernel.IBaseEntity;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;

public class ValidationController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)ValidationController.class.getName());
    private static final String NOTUNIQUE_FIELD_ERROR_CODE = "302";

    protected static void validateUniqueness(String value, String fieldName, Class objectClass, Integer excludeId, Object excludedObject) throws ConstraintException, SystemException {
        Pattern p = Pattern.compile("[.\\s]+");
        String[] arrString = p.split(fieldName);
        String cleanField = arrString[arrString.length - 1];
        if (ValidationController.fieldValueExists(objectClass, cleanField, value, excludeId, excludedObject)) {
            throw ValidationController.createConstraintException(fieldName, NOTUNIQUE_FIELD_ERROR_CODE);
        }
    }

    private static final ConstraintException createConstraintException(String fieldName, String errorCode) {
        return new ConstraintException(fieldName, errorCode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean fieldValueExists(Class objectClass, String fieldName, String checkValue, Integer excludeId, Object excludeObject) throws SystemException {
        boolean valueExist = false;
        Database db = CastorDatabaseService.getDatabase();
        try {
            ValidationController.beginTransaction(db);
            OQLQuery oql = db.getOQLQuery("SELECT u FROM " + objectClass.getName() + " u WHERE u." + fieldName + " = $1");
            oql.bind((Object)checkValue);
            QueryResults results = oql.execute();
            logger.info((Object)"Fetching entity in read/write mode");
            if (excludeId == null && excludeObject == null) {
                valueExist = results.hasMore();
            } else {
                while (results.hasMore()) {
                    IBaseEntity o = (IBaseEntity)results.next();
                    logger.info((Object)("Validating...." + o.getIdAsObject() + ":" + excludeObject + ":" + o.getIdAsObject().equals(excludeObject)));
                    if (excludeObject != null) {
                        if (o.getIdAsObject().equals(excludeObject)) continue;
                        valueExist = true;
                        continue;
                    }
                    if (o.getId().compareTo(excludeId) == 0) continue;
                    valueExist = true;
                }
            }
            ValidationController.commitTransaction(db);
            return valueExist;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ValidationController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public BaseEntityVO getNewVO() {
        return null;
    }
}

