/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.DOMParser;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.entities.content.DigitalAsset;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.ContentTypeDefinition;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.Language;
import org.infoglue.cms.entities.management.UserContentTypeDefinition;
import org.infoglue.cms.entities.management.UserProperties;
import org.infoglue.cms.entities.management.UserPropertiesVO;
import org.infoglue.cms.entities.management.impl.simple.LanguageImpl;
import org.infoglue.cms.entities.management.impl.simple.UserContentTypeDefinitionImpl;
import org.infoglue.cms.entities.management.impl.simple.UserPropertiesImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.XMLHelper;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class UserPropertiesController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)UserPropertiesController.class.getName());

    public static UserPropertiesController getController() {
        return new UserPropertiesController();
    }

    public UserProperties getUserPropertiesWithId(Integer userPropertiesId, Database db) throws SystemException, Bug {
        return (UserProperties)UserPropertiesController.getObjectWithId(UserPropertiesImpl.class, userPropertiesId, db);
    }

    public UserPropertiesVO getUserPropertiesVOWithId(Integer userPropertiesId) throws SystemException, Bug {
        return (UserPropertiesVO)UserPropertiesController.getVOWithId(UserPropertiesImpl.class, userPropertiesId);
    }

    public List getUserPropertiesVOList() throws SystemException, Bug {
        return this.getAllVOObjects(UserPropertiesImpl.class, "userPropertiesId");
    }

    public UserPropertiesVO create(Integer languageId, Integer contentTypeDefinitionId, UserPropertiesVO userPropertiesVO) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        UserProperties userProperties = null;
        UserPropertiesController.beginTransaction(db);
        try {
            userProperties = this.create(languageId, contentTypeDefinitionId, userPropertiesVO, db);
            UserPropertiesController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            UserPropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return userProperties.getValueObject();
    }

    public UserProperties create(Integer languageId, Integer contentTypeDefinitionId, UserPropertiesVO userPropertiesVO, Database db) throws ConstraintException, SystemException, Exception {
        Language language = LanguageController.getController().getLanguageWithId(languageId, db);
        ContentTypeDefinition contentTypeDefinition = ContentTypeDefinitionController.getController().getContentTypeDefinitionWithId(contentTypeDefinitionId, db);
        UserPropertiesImpl userProperties = new UserPropertiesImpl();
        userProperties.setLanguage((LanguageImpl)language);
        userProperties.setContentTypeDefinition(contentTypeDefinition);
        userProperties.setValueObject(userPropertiesVO);
        db.create((Object)userProperties);
        return userProperties;
    }

    public UserPropertiesVO update(Integer languageId, Integer contentTypeDefinitionId, UserPropertiesVO userPropertiesVO) throws ConstraintException, SystemException, Exception {
        UserPropertiesVO realUserPropertiesVO = userPropertiesVO;
        if (userPropertiesVO.getId() == null) {
            InfoGluePrincipal infoGluePrincipal = UserControllerProxy.getController().getUser(userPropertiesVO.getUserName());
            List userPropertiesVOList = UserPropertiesController.getController().getUserPropertiesVOList(infoGluePrincipal.getName(), languageId);
            if (userPropertiesVOList != null && userPropertiesVOList.size() > 0) {
                realUserPropertiesVO = (UserPropertiesVO)userPropertiesVOList.get(0);
                realUserPropertiesVO.setValue(userPropertiesVO.getValue());
            } else {
                logger.info((Object)("Creating the entity because there was no version at all for: " + contentTypeDefinitionId + " " + languageId));
                realUserPropertiesVO = this.create(languageId, contentTypeDefinitionId, userPropertiesVO);
            }
        }
        return (UserPropertiesVO)UserPropertiesController.updateEntity(UserPropertiesImpl.class, realUserPropertiesVO);
    }

    public UserPropertiesVO update(UserPropertiesVO userPropertiesVO, String[] users) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        UserProperties userProperties = null;
        UserPropertiesController.beginTransaction(db);
        try {
            userProperties = this.getUserPropertiesWithId(userPropertiesVO.getUserPropertiesId(), db);
            userProperties.setValueObject(userPropertiesVO);
            ceb.throwIfNotEmpty();
            UserPropertiesController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            UserPropertiesController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            UserPropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return userProperties.getValueObject();
    }

    public void delete(UserPropertiesVO userPropertiesVO) throws ConstraintException, SystemException {
        UserPropertiesController.deleteEntity(UserPropertiesImpl.class, userPropertiesVO.getUserPropertiesId());
    }

    public void deleteDigitalAssetRelation(Integer userPropertiesId, DigitalAsset digitalAsset, Database db) throws SystemException, Bug {
        UserProperties userProperties = this.getUserPropertiesWithId(userPropertiesId, db);
        userProperties.getDigitalAssets().remove(digitalAsset);
        digitalAsset.getUserProperties().remove(userProperties);
    }

    public List getUserPropertiesVOList(String userName, Integer languageId) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        List userPropertiesVOList = new ArrayList();
        UserPropertiesController.beginTransaction(db);
        try {
            List userProperties = this.getUserPropertiesList(userName, languageId, db, true);
            userPropertiesVOList = UserPropertiesController.toVOList(userProperties);
            ceb.throwIfNotEmpty();
            UserPropertiesController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            UserPropertiesController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            UserPropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return userPropertiesVOList;
    }

    public List getUserPropertiesList(String userName, Integer languageId, Database db, boolean readOnly) throws ConstraintException, SystemException, Exception {
        ArrayList<UserProperties> userPropertiesList = new ArrayList<UserProperties>();
        OQLQuery oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.UserPropertiesImpl f WHERE f.userName = $1 AND f.language = $2");
        oql.bind((Object)userName);
        oql.bind((Object)languageId);
        QueryResults results = null;
        if (readOnly) {
            results = oql.execute((short)0);
        } else {
            logger.info((Object)("Fetching entity in read/write mode:" + userName));
            results = oql.execute();
        }
        while (results.hasMore()) {
            UserProperties userProperties = (UserProperties)results.next();
            userPropertiesList.add(userProperties);
        }
        results.close();
        oql.close();
        return userPropertiesList;
    }

    public List getContentTypeDefinitionVOList(String userName) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ArrayList<ContentTypeDefinitionVO> contentTypeDefinitionVOList = new ArrayList<ContentTypeDefinitionVO>();
        UserPropertiesController.beginTransaction(db);
        try {
            List userContentTypeDefinitionList = this.getUserContentTypeDefinitionList(userName, db);
            for (UserContentTypeDefinition userContentTypeDefinition : userContentTypeDefinitionList) {
                contentTypeDefinitionVOList.add(userContentTypeDefinition.getContentTypeDefinition().getValueObject());
            }
            ceb.throwIfNotEmpty();
            UserPropertiesController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            UserPropertiesController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            UserPropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contentTypeDefinitionVOList;
    }

    public List getUserContentTypeDefinitionList(String userName, Database db) throws ConstraintException, SystemException, Exception {
        ArrayList<UserContentTypeDefinition> userContentTypeDefinitionList = new ArrayList<UserContentTypeDefinition>();
        OQLQuery oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.UserContentTypeDefinitionImpl f WHERE f.userName = $1");
        oql.bind((Object)userName);
        QueryResults results = oql.execute();
        logger.info((Object)("Fetching entity in read/write mode:" + userName));
        while (results.hasMore()) {
            UserContentTypeDefinition userContentTypeDefinition = (UserContentTypeDefinition)results.next();
            userContentTypeDefinitionList.add(userContentTypeDefinition);
        }
        results.close();
        oql.close();
        return userContentTypeDefinitionList;
    }

    public void updateContentTypeDefinitions(String userName, String[] contentTypeDefinitionIds) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ArrayList contentTypeDefinitionVOList = new ArrayList();
        UserPropertiesController.beginTransaction(db);
        try {
            List userContentTypeDefinitionList = this.getUserContentTypeDefinitionList(userName, db);
            for (UserContentTypeDefinition userContentTypeDefinition : userContentTypeDefinitionList) {
                db.remove((Object)userContentTypeDefinition);
            }
            int i = 0;
            while (i < contentTypeDefinitionIds.length) {
                Integer contentTypeDefinitionId = new Integer(contentTypeDefinitionIds[i]);
                ContentTypeDefinition contentTypeDefinition = ContentTypeDefinitionController.getController().getContentTypeDefinitionWithId(contentTypeDefinitionId, db);
                UserContentTypeDefinitionImpl userContentTypeDefinitionImpl = new UserContentTypeDefinitionImpl();
                userContentTypeDefinitionImpl.setUserName(userName);
                userContentTypeDefinitionImpl.setContentTypeDefinition(contentTypeDefinition);
                db.create((Object)userContentTypeDefinitionImpl);
                ++i;
            }
            ceb.throwIfNotEmpty();
            UserPropertiesController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            UserPropertiesController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            UserPropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void updateAttributeValue(Integer userPropertiesId, String attributeName, String attributeValue) throws SystemException, Bug {
        UserPropertiesVO userPropertiesVO = this.getUserPropertiesVOWithId(userPropertiesId);
        if (userPropertiesVO != null) {
            try {
                logger.info((Object)("attributeName:" + attributeName));
                logger.info((Object)("versionValue:" + userPropertiesVO.getValue()));
                logger.info((Object)("attributeValue:" + attributeValue));
                InputSource inputSource = new InputSource(new StringReader(userPropertiesVO.getValue()));
                DOMParser parser = new DOMParser();
                parser.parse(inputSource);
                Document document = parser.getDocument();
                NodeList nl = document.getDocumentElement().getChildNodes();
                Node attributesNode = nl.item(0);
                boolean existed = false;
                nl = attributesNode.getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    Node n = nl.item(i);
                    if (n.getNodeName().equalsIgnoreCase(attributeName)) {
                        if (n.getFirstChild() != null && n.getFirstChild().getNodeValue() != null) {
                            n.getFirstChild().setNodeValue(attributeValue);
                            existed = true;
                            break;
                        }
                        CDATASection cdata = document.createCDATASection(attributeValue);
                        n.appendChild(cdata);
                        existed = true;
                        break;
                    }
                    ++i;
                }
                if (!existed) {
                    Element attributeElement = document.createElement(attributeName);
                    attributesNode.appendChild(attributeElement);
                    CDATASection cdata = document.createCDATASection(attributeValue);
                    attributeElement.appendChild(cdata);
                }
                StringBuffer sb = new StringBuffer();
                XMLHelper.serializeDom(document.getDocumentElement(), sb);
                logger.info((Object)("sb:" + sb));
                userPropertiesVO.setValue(sb.toString());
                this.update(userPropertiesVO.getLanguageId(), userPropertiesVO.getContentTypeDefinitionId(), userPropertiesVO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getAttributeValue(Integer userPropertiesId, String attributeName, boolean escapeHTML) throws SystemException, Bug {
        String value = "";
        UserPropertiesVO userPropertiesVO = this.getUserPropertiesVOWithId(userPropertiesId);
        if (userPropertiesVO != null) {
            try {
                logger.info((Object)("attributeName:" + attributeName));
                logger.info((Object)("VersionValue:" + userPropertiesVO.getValue()));
                InputSource inputSource = new InputSource(new StringReader(userPropertiesVO.getValue()));
                DOMParser parser = new DOMParser();
                parser.parse(inputSource);
                Document document = parser.getDocument();
                NodeList nl = document.getDocumentElement().getChildNodes();
                Node n = nl.item(0);
                nl = n.getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    n = nl.item(i);
                    if (n.getNodeName().equalsIgnoreCase(attributeName) && n.getFirstChild() != null && n.getFirstChild().getNodeValue() != null) {
                        value = n.getFirstChild().getNodeValue();
                        logger.info((Object)("Getting value: " + value));
                        if (value != null && escapeHTML) {
                            value = new VisualFormatter().escapeHTML(value);
                        }
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public List getDigitalAssetVOList(Integer userPropertiesId) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        List digitalAssetVOList = new ArrayList();
        UserPropertiesController.beginTransaction(db);
        try {
            UserProperties userProperties = UserPropertiesController.getController().getUserPropertiesWithId(userPropertiesId, db);
            if (userProperties != null) {
                Collection digitalAssets = userProperties.getDigitalAssets();
                digitalAssetVOList = UserPropertiesController.toVOList(digitalAssets);
            }
            UserPropertiesController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred when we tried to fetch the list of digitalAssets belonging to this userProperties:" + e));
            e.printStackTrace();
            UserPropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return digitalAssetVOList;
    }

    public BaseEntityVO getNewVO() {
        return new UserPropertiesVO();
    }
}

