/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.SystemUserVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.AuthorizationModule;
import org.infoglue.cms.security.InfoGlueAuthenticationFilter;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.sorters.ReflectionComparator;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.NullObject;

public class UserControllerProxy
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)UserControllerProxy.class.getName());
    private AuthorizationModule authorizationModule = null;
    private Database transactionObject = null;

    public UserControllerProxy(Database transactionObject) {
        this.transactionObject = transactionObject;
    }

    public static UserControllerProxy getController() {
        return new UserControllerProxy(null);
    }

    public static UserControllerProxy getController(Database transactionObject) {
        return new UserControllerProxy(transactionObject);
    }

    private AuthorizationModule getAuthorizationModule() throws SystemException {
        try {
            logger.info((Object)("InfoGlueAuthenticationFilter.authorizerClass:" + InfoGlueAuthenticationFilter.authorizerClass));
            this.authorizationModule = (AuthorizationModule)Class.forName(InfoGlueAuthenticationFilter.authorizerClass).newInstance();
            logger.info((Object)("authorizationModule:" + this.authorizationModule));
            this.authorizationModule.setExtraProperties(InfoGlueAuthenticationFilter.extraProperties);
            this.authorizationModule.setTransactionObject(this.transactionObject);
            logger.info((Object)("InfoGlueAuthenticationFilter.extraProperties:" + InfoGlueAuthenticationFilter.extraProperties));
        }
        catch (Exception e) {
            logger.error((Object)("There was an error initializing the authorizerClass:" + e.getMessage()), (Throwable)e);
            throw new SystemException("There was an error initializing the authorizerClass:" + e.getMessage(), e);
        }
        return this.authorizationModule;
    }

    public boolean getSupportUpdate() throws ConstraintException, SystemException, Exception {
        return this.getAuthorizationModule().getSupportUpdate();
    }

    public boolean getSupportDelete() throws ConstraintException, SystemException, Exception {
        return this.getAuthorizationModule().getSupportDelete();
    }

    public boolean getSupportCreate() throws ConstraintException, SystemException, Exception {
        return this.getAuthorizationModule().getSupportCreate();
    }

    public List getAllUsers() throws ConstraintException, SystemException, Exception {
        List users = new ArrayList();
        users = this.getAuthorizationModule().getUsers();
        Collections.sort(users, new ReflectionComparator("displayName"));
        return users;
    }

    public List getFilteredUsers(String firstName, String lastName, String userName, String email, String[] roleNames) throws Exception {
        List users = new ArrayList();
        users = this.getAuthorizationModule().getFilteredUsers(firstName, lastName, userName, email, roleNames);
        return users;
    }

    public InfoGluePrincipal getUser(String userName) throws ConstraintException, SystemException, Exception {
        Object infoGluePrincipalCandidate = CacheController.getCachedObjectFromAdvancedCache("principalCache", userName, 300);
        if (infoGluePrincipalCandidate != null) {
            if (infoGluePrincipalCandidate instanceof NullObject) {
                return null;
            }
            return (InfoGluePrincipal)infoGluePrincipalCandidate;
        }
        InfoGluePrincipal infoGluePrincipal = this.getAuthorizationModule().getAuthorizedInfoGluePrincipal(userName);
        if (infoGluePrincipal != null) {
            CacheController.cacheObjectInAdvancedCache("principalCache", userName, infoGluePrincipal, new String[0], false);
        } else {
            CacheController.cacheObjectInAdvancedCache("principalCache", userName, new NullObject(), new String[0], false);
        }
        return infoGluePrincipal;
    }

    public InfoGluePrincipal createUser(SystemUserVO systemUserVO) throws ConstraintException, SystemException, Exception {
        this.getAuthorizationModule().createInfoGluePrincipal(systemUserVO);
        return this.getUser(systemUserVO.getUserName());
    }

    public void updateUser(SystemUserVO systemUserVO, String[] roleNames, String[] groupNames) throws ConstraintException, SystemException, Exception {
        this.getAuthorizationModule().updateInfoGluePrincipal(systemUserVO, roleNames, groupNames);
    }

    public void updateUserPassword(String userName) throws ConstraintException, SystemException, Exception {
        if (userName.equals(CmsPropertyHandler.getAnonymousUser())) {
            throw new SystemException("You must not change password on this user as it's needed by the system.");
        }
        this.getAuthorizationModule().updateInfoGluePrincipalPassword(userName);
    }

    public void updateAnonymousUserPassword() throws ConstraintException, SystemException, Exception {
        this.getAuthorizationModule().updateInfoGlueAnonymousPrincipalPassword();
    }

    public void updateUserPassword(String userName, String oldPassword, String newPassword) throws ConstraintException, SystemException, Exception {
        this.getAuthorizationModule().updateInfoGluePrincipalPassword(userName, oldPassword, newPassword);
    }

    public void deleteUser(String userName) throws ConstraintException, SystemException, Exception {
        this.getAuthorizationModule().deleteInfoGluePrincipal(userName);
    }

    public BaseEntityVO getNewVO() {
        return null;
    }
}

