/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Ant;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.UpdateListHandler;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.up2date.UpdateCollection;
import org.infoglue.cms.entities.up2date.UpdatePackage;
import org.xml.sax.InputSource;

public class UpdateController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)UpdateController.class.getName());
    private String protocolVersion = "20";
    private String path = "";
    private String url = "";
    Mapping mapping;

    public UpdateController(String url, String path) throws FileNotFoundException, IOException, MappingException {
        this.path = path;
        this.url = url;
        this.mapping = new Mapping();
        this.mapping.loadMapping(new InputSource(new FileReader(String.valueOf(path) + "mapping.xml")));
    }

    public void refreshAvailableUpdates() {
        UpdateListHandler.setAvailableUpdates(null);
    }

    public Date getLatestRefresh() {
        return UpdateListHandler.getLatestRefresh();
    }

    public Vector getAvailableUpdates() {
        logger.info((Object)"Get Available updates");
        if (UpdateListHandler.getAvailableUpdates() == null) {
            logger.info((Object)"Getting from updateserver");
            Vector ret = new Vector();
            try {
                Object u2;
                Unmarshaller unmar = new Unmarshaller(this.mapping);
                unmar.setWhitespacePreserve(true);
                this.url = this.url.indexOf("?") == -1 ? String.valueOf(this.url) + "?v=" + this.protocolVersion : String.valueOf(this.url) + "&v=" + this.protocolVersion;
                Vector installed = this.getInstalledUpdates();
                for (Object u2 : installed) {
                    this.url = String.valueOf(this.url) + "&p=" + ((UpdatePackage)u2).getPackageId();
                }
                u2 = new URL(this.url);
                URLConnection urlConn = ((URL)u2).openConnection();
                urlConn.setAllowUserInteraction(false);
                urlConn.setUseCaches(false);
                UpdateCollection coll = (UpdateCollection)unmar.unmarshal((Reader)new InputStreamReader(urlConn.getInputStream()));
                ret = coll.getUpdatePackageList();
            }
            catch (ValidationException e2) {
                e2.printStackTrace();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (MappingException e) {
                e.printStackTrace();
            }
            catch (MarshalException e) {
                e.printStackTrace();
            }
            UpdateListHandler.setAvailableUpdates(ret);
        }
        return UpdateListHandler.getAvailableUpdates();
    }

    public Vector getInstalledUpdates() {
        logger.info((Object)"GetInstalled Updates");
        Unmarshaller unmar = null;
        UpdateCollection coll = new UpdateCollection();
        try {
            unmar = new Unmarshaller(this.mapping);
            unmar.setWhitespacePreserve(true);
            coll = (UpdateCollection)unmar.unmarshal(new InputSource(new FileReader(String.valueOf(this.path) + "installed.xml")));
        }
        catch (MarshalException e2) {
            logger.info((Object)"Marshal exception");
        }
        catch (ValidationException e2) {
            e2.printStackTrace();
        }
        catch (FileNotFoundException e2) {
            logger.info((Object)"No packages found");
        }
        catch (MappingException e1) {
            e1.printStackTrace();
        }
        logger.info((Object)"Leaving GetInstalled Updates");
        return coll.getUpdatePackageList();
    }

    private void addInstalledUpdate(UpdatePackage upd) {
        Unmarshaller unmar = null;
        try {
            unmar = new Unmarshaller(this.mapping);
            unmar.setWhitespacePreserve(true);
        }
        catch (MappingException e1) {
            e1.printStackTrace();
        }
        UpdateCollection coll = new UpdateCollection();
        try {
            coll = (UpdateCollection)unmar.unmarshal(new InputSource(new FileReader(String.valueOf(this.path) + "installed.xml")));
        }
        catch (MarshalException e2) {
            e2.printStackTrace();
        }
        catch (ValidationException e2) {
            e2.printStackTrace();
        }
        catch (FileNotFoundException e2) {
            logger.info((Object)"No previous installations");
        }
        coll.getUpdatePackageList().add(upd);
        Marshaller marshaller = null;
        try {
            marshaller = new Marshaller((Writer)new FileWriter(new File(String.valueOf(this.path) + "installed.xml")));
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        try {
            marshaller.setMapping(this.mapping);
        }
        catch (MappingException e4) {
            e4.printStackTrace();
        }
        try {
            marshaller.marshal((Object)coll);
        }
        catch (MarshalException e5) {
            e5.printStackTrace();
        }
        catch (ValidationException e5) {
            e5.printStackTrace();
        }
    }

    private void removeInstalledUpdate(UpdatePackage upd) {
        Unmarshaller unmar = null;
        try {
            unmar = new Unmarshaller(this.mapping);
            unmar.setWhitespacePreserve(true);
        }
        catch (MappingException e1) {
            e1.printStackTrace();
        }
        UpdateCollection coll = new UpdateCollection();
        try {
            coll = (UpdateCollection)unmar.unmarshal(new InputSource(new FileReader(String.valueOf(this.path) + "installed.xml")));
        }
        catch (MarshalException e2) {
            e2.printStackTrace();
        }
        catch (ValidationException e2) {
            e2.printStackTrace();
        }
        catch (FileNotFoundException e2) {
            logger.info((Object)"No previous installations");
        }
        Iterator iterator = coll.getUpdatePackageList().iterator();
        while (iterator.hasNext()) {
            UpdatePackage u = (UpdatePackage)iterator.next();
            if (upd.getPackageId().compareTo(u.getPackageId()) != 0) continue;
            coll.getUpdatePackageList().remove(u);
            iterator = coll.getUpdatePackageList().iterator();
        }
        Marshaller marshaller = null;
        try {
            marshaller = new Marshaller((Writer)new FileWriter(new File(String.valueOf(this.path) + "installed.xml")));
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        try {
            marshaller.setMapping(this.mapping);
        }
        catch (MappingException e4) {
            e4.printStackTrace();
        }
        try {
            marshaller.marshal((Object)coll);
        }
        catch (MarshalException e5) {
            e5.printStackTrace();
        }
        catch (ValidationException e5) {
            e5.printStackTrace();
        }
    }

    public void runUpdatePackage(String updatePackageId, OutputStreamWriter writer) throws IOException {
        Vector updates = this.getAvailableUpdates();
        for (UpdatePackage u : updates) {
            if (updatePackageId.compareTo(u.getPackageId()) != 0) continue;
            logger.info((Object)("Found package to install: " + u.getPackageId()));
            this.runUpdatePackage(u, writer);
            break;
        }
    }

    public void unInstallPackage(String updatePackageId, PrintWriter out) throws MalformedURLException {
        Vector updates = this.getInstalledUpdates();
        for (UpdatePackage u : updates) {
            if (updatePackageId.compareTo(u.getPackageId()) != 0) continue;
            logger.info((Object)("Found package to uninstall: " + u.getPackageId()));
            this.unInstallPackage(u, out);
            break;
        }
    }

    public void runUpdatePackage(UpdatePackage upd, OutputStreamWriter out) throws IOException {
        try {
            String url = upd.getDecodedBinaryUrl();
            out.write("Downloading the package");
            out.flush();
            String zipFile = String.valueOf(this.path) + "autoUpdate/" + upd.getPackageId() + ".zip";
            this.getFile(url, zipFile, upd.getBinarySize(), out);
            String antFile = String.valueOf(this.path) + upd.getPackageId() + ".xml";
            this.getFile(upd.getDecodedUrl(), antFile, -1, out);
            out.flush();
            final class AntRun
            extends Ant {
                public AntRun() {
                    this.project = new Project();
                    this.project.init();
                }
            }
            AntRun a = new AntRun();
            a.setAntfile(antFile);
            a.setDir(new File(this.path));
            a.setTarget("runUpdate");
            out.write("Executing ant update script...<br>");
            out.flush();
            a.execute();
            out.write("Finalizing...<br>");
            out.flush();
            this.refreshAvailableUpdates();
            this.addInstalledUpdate(upd);
            out.write("DONE!<br>");
            out.flush();
        }
        catch (BuildException e) {
            out.write(e.getMessage());
            out.write("<br>");
        }
        catch (MalformedURLException e) {
            out.write(e.getMessage());
            out.write("<br>");
        }
    }

    public void unInstallPackage(UpdatePackage upd, PrintWriter out) throws MalformedURLException {
        out.println("About to run uninstallation...<br>");
        String antfile = upd.getPackageId();
        String destFile = String.valueOf(this.path) + antfile + ".xml";
        final class AntRun
        extends Ant {
            public AntRun() {
                this.project = new Project();
                this.project.init();
            }
        }
        AntRun a = new AntRun();
        a.setAntfile(destFile);
        a.setDir(new File(this.path));
        a.setTarget("unInstall");
        out.println("Running Ant...<br>");
        a.execute();
        out.println("Finalizing...<br>");
        this.refreshAvailableUpdates();
        this.removeInstalledUpdate(upd);
        out.println("DONE!<br>");
    }

    private void getFile(String src, String dest, int size, OutputStreamWriter out) throws IOException {
        File destFile = new File(dest);
        destFile.getParentFile().mkdirs();
        URL u = new URL(src);
        URLConnection urlConn = u.openConnection();
        urlConn.setAllowUserInteraction(false);
        urlConn.setUseCaches(false);
        InputStream is = urlConn.getInputStream();
        String fileName = dest.substring(dest.lastIndexOf("/"));
        FileOutputStream fo = new FileOutputStream(new File(dest));
        int cnt = 0;
        int cntcheck = 0;
        int steps = 50;
        int interval = size / steps;
        out.write("<font color='blue'><pre>");
        int x = 0;
        while (x < steps) {
            out.write("_");
            ++x;
        }
        out.write("<br>");
        out.flush();
        byte[] buffer = new byte[64];
        BufferedInputStream br = new BufferedInputStream(urlConn.getInputStream());
        int lengthRead = 0;
        while ((lengthRead = br.read(buffer)) >= 0) {
            cnt += lengthRead;
            fo.write(buffer, 0, lengthRead);
            if (size <= 0) continue;
            if (cnt % (size / steps) < cntcheck) {
                out.write("*");
                out.flush();
            }
            cntcheck = cnt % (size / steps);
        }
        if (size <= 0) {
            int x2 = 0;
            while (x2 < steps) {
                out.write("*");
                ++x2;
            }
        }
        out.flush();
        out.write("</font><font color='green'> [OK] - " + fileName + "</font>");
        out.write("<br>");
        out.write("</pre>");
        out.flush();
        is.close();
        fo.close();
        out.flush();
    }

    public BaseEntityVO getNewVO() {
        return null;
    }
}

