/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.TransactionHistory;
import org.infoglue.cms.entities.management.TransactionHistoryVO;
import org.infoglue.cms.entities.management.impl.simple.TransactionHistoryImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.NotificationMessage;

public class TransactionHistoryController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)TransactionHistoryController.class.getName());

    public static TransactionHistoryController getController() {
        return new TransactionHistoryController();
    }

    public TransactionHistoryVO getTransactionHistoryVOWithId(Integer transactionHistoryId) throws SystemException, Bug {
        return (TransactionHistoryVO)TransactionHistoryController.getVOWithId(TransactionHistoryImpl.class, transactionHistoryId);
    }

    public TransactionHistory getTransactionHistoryWithId(Integer transactionHistoryId, Database db) throws SystemException, Bug {
        return (TransactionHistory)TransactionHistoryController.getObjectWithId(TransactionHistoryImpl.class, transactionHistoryId, db);
    }

    public List getTransactionHistoryVOList() throws SystemException, Bug {
        return this.getAllVOObjects(TransactionHistoryImpl.class, "transactionHistoryId");
    }

    public void deleteTransactionHistory(Integer transactionHistoryId, Database db) throws SystemException, Bug {
        try {
            db.remove((Object)this.getTransactionHistoryWithId(transactionHistoryId, db));
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to delete TransactionHistory in the database. Reason: " + e.getMessage(), e);
        }
    }

    public TransactionHistoryVO getLatestTransactionHistoryVOForEntity(Class entClass, Integer entityId) throws SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        TransactionHistoryVO transactionHistoryVO = null;
        TransactionHistoryController.beginTransaction(db);
        try {
            OQLQuery oql = db.getOQLQuery("SELECT th FROM org.infoglue.cms.entities.management.impl.simple.TransactionHistoryImpl th WHERE th.transactionObjectName LIKE $1 AND th.transactionObjectId = $2 ORDER BY th.transactionDateTime desc");
            oql.bind((Object)(String.valueOf(entClass.getName()) + "%"));
            oql.bind((Object)entityId);
            QueryResults results = oql.execute((short)0);
            if (results.hasMore()) {
                TransactionHistory transactionHistory = (TransactionHistory)results.next();
                transactionHistoryVO = transactionHistory.getValueObject();
            }
            results.close();
            oql.close();
            TransactionHistoryController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            TransactionHistoryController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return transactionHistoryVO;
    }

    /*
     * WARNING - void declaration
     */
    public List getLatestTransactionHistoryVOListForEntity(Class entClass, Integer entityId, List transactionType, Date startDateTime, Date endDateTime, int rowLimit) throws SystemException {
        ArrayList<TransactionHistoryVO> resultList = new ArrayList<TransactionHistoryVO>();
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        Object transactionHistoryVO = null;
        TransactionHistoryController.beginTransaction(db);
        try {
            void var18_22;
            String baseSQL = "SELECT th FROM org.infoglue.cms.entities.management.impl.simple.TransactionHistoryImpl th";
            ArrayList<Object> bindings = new ArrayList<Object>();
            int i = 1;
            String whereArguments = "";
            if (entClass != null) {
                whereArguments = String.valueOf(whereArguments) + (whereArguments.equals("") ? "" : " AND ") + " th.transactionObjectName LIKE $" + i + " ";
                bindings.add(String.valueOf(entClass.getName()) + "%");
                ++i;
            }
            if (entityId != null) {
                whereArguments = String.valueOf(whereArguments) + (whereArguments.equals("") ? "" : " AND ") + " th.transactionObjectId = $" + i + " ";
                bindings.add(entityId);
                ++i;
            }
            if (transactionType != null) {
                whereArguments = String.valueOf(whereArguments) + (whereArguments.equals("") ? "" : " AND ") + " th.transactionTypeId IN LIST (";
                int localIndex = 0;
                Iterator transactionTypeIterator = transactionType.iterator();
                while (transactionTypeIterator.hasNext()) {
                    if (localIndex > 0) {
                        whereArguments = String.valueOf(whereArguments) + ",";
                    }
                    whereArguments = String.valueOf(whereArguments) + "$" + i;
                    bindings.add(transactionTypeIterator.next());
                    ++i;
                    ++localIndex;
                }
                whereArguments = String.valueOf(whereArguments) + ") ";
            }
            if (startDateTime != null) {
                whereArguments = String.valueOf(whereArguments) + (whereArguments.equals("") ? "" : " AND ") + " th.transactionDateTime >= $" + i + " ";
                bindings.add(startDateTime);
                ++i;
            }
            if (endDateTime != null) {
                whereArguments = String.valueOf(whereArguments) + (whereArguments.equals("") ? "" : " AND ") + " th.transactionDateTime <= $" + i + " ";
                bindings.add(endDateTime);
                ++i;
            }
            String sql = String.valueOf(baseSQL) + (whereArguments.equals("") ? "" : " WHERE ") + whereArguments + " ORDER BY th.transactionDateTime desc";
            OQLQuery oql = db.getOQLQuery(sql);
            for (Object e : bindings) {
                oql.bind(e);
            }
            boolean bl = false;
            QueryResults results = oql.execute((short)0);
            while (results.hasMore() && var18_22 < rowLimit) {
                TransactionHistory transactionHistory = (TransactionHistory)results.next();
                resultList.add(transactionHistory.getValueObject());
                ++var18_22;
            }
            results.close();
            oql.close();
            TransactionHistoryController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            TransactionHistoryController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return resultList;
    }

    public TransactionHistoryVO update(TransactionHistoryVO transactionHistoryVO) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        TransactionHistory transactionHistory = null;
        TransactionHistoryController.beginTransaction(db);
        try {
            transactionHistory = this.getTransactionHistoryWithId(transactionHistoryVO.getTransactionHistoryId(), db);
            transactionHistory.setValueObject(transactionHistoryVO);
            ceb.throwIfNotEmpty();
            TransactionHistoryController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            TransactionHistoryController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            TransactionHistoryController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return transactionHistory.getValueObject();
    }

    public Integer create(NotificationMessage notificationMessage) throws SystemException {
        logger.info((Object)"Creating a transactionHistory object...");
        Database db = CastorDatabaseService.getDatabase();
        TransactionHistoryImpl transactionHistory = null;
        try {
            TransactionHistoryController.beginTransaction(db);
            logger.info((Object)"Began transaction...");
            TransactionHistoryVO transVO = new TransactionHistoryVO();
            transactionHistory = new TransactionHistoryImpl();
            transVO.setName(notificationMessage.getName());
            transVO.setSystemUserName(notificationMessage.getSystemUserName());
            transVO.setTransactionDateTime(Calendar.getInstance().getTime());
            transVO.setTransactionTypeId(new Integer(notificationMessage.getType()));
            transVO.setTransactionObjectId(notificationMessage.getObjectId().toString());
            transVO.setTransactionObjectName(notificationMessage.getObjectName());
            transactionHistory.setValueObject(transVO);
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Created the transaction object and filled it with values...");
                logger.info((Object)("transactionHistory.getId():" + transactionHistory.getId()));
                logger.info((Object)("transactionHistory.getName():" + transactionHistory.getName()));
                logger.info((Object)("transactionHistory.getSystemUserName():" + transactionHistory.getSystemUserName()));
                logger.info((Object)("transactionHistory.getTransactionDateTime():" + transactionHistory.getTransactionDateTime()));
                logger.info((Object)("transactionHistory.getTransactionObjectId():" + transactionHistory.getTransactionObjectId()));
                logger.info((Object)("transactionHistory.getTransactionObjectName():" + transactionHistory.getTransactionObjectName()));
                logger.info((Object)("transactionHistory.getTransactionTypeId():" + transactionHistory.getTransactionTypeId()));
                logger.info((Object)("isActive=" + db.isActive()));
            }
            db.create((Object)transactionHistory);
            logger.info((Object)"Created the transaction object in the database..");
            TransactionHistoryController.commitTransaction(db);
            logger.info((Object)"Committed the transaction..");
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            TransactionHistoryController.rollbackTransaction(db);
            return null;
        }
        logger.info((Object)"TransactionHistory object all done..");
        return transactionHistory.getValueObject().getTransactionHistoryId();
    }

    public BaseEntityVO getNewVO() {
        return new TransactionHistoryVO();
    }
}

