/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.ToolbarButton;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupPropertiesController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.RoleControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.RolePropertiesController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.UserPropertiesController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGlueGroup;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.InfoGlueRole;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.StringManager;
import org.infoglue.cms.util.StringManagerFactory;
import org.infoglue.deliver.util.HttpHelper;
import org.infoglue.deliver.util.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolbarController {
    private static final Logger logger = Logger.getLogger((String)ToolbarController.class.getName());
    private static final long serialVersionUID = 1L;
    private String URIEncoding = CmsPropertyHandler.getURIEncoding();
    private InfoGluePrincipal principal = null;
    private Locale locale = null;
    private String toolbarKey = null;
    private String primaryKey = null;
    private Integer primaryKeyAsInteger = null;
    private String extraParameters = null;
    private boolean disableCloseButton = false;

    public List<ToolbarButton> getRightToolbarButtons(String toolbarKey, InfoGluePrincipal principal, Locale locale, String primaryKey, String extraParameters, boolean disableCloseButton) {
        this.toolbarKey = toolbarKey;
        this.principal = principal;
        this.locale = locale;
        this.primaryKey = primaryKey;
        this.extraParameters = extraParameters;
        this.disableCloseButton = disableCloseButton;
        try {
            this.primaryKeyAsInteger = new Integer(primaryKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ArrayList<ToolbarButton> toolbarButtons = new ArrayList<ToolbarButton>();
            toolbarButtons.addAll(this.getHelpButton());
            if (!disableCloseButton) {
                toolbarButtons.addAll(this.getDialogCloseButton());
            }
            return toolbarButtons;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<ToolbarButton> getToolbarButtons(String toolbarKey, InfoGluePrincipal principal, Locale locale, String primaryKey, String extraParameters) {
        Timer t = new Timer();
        this.toolbarKey = toolbarKey;
        this.principal = principal;
        this.locale = locale;
        this.primaryKey = primaryKey;
        this.extraParameters = extraParameters;
        try {
            this.primaryKeyAsInteger = new Integer(primaryKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.info((Object)("toolbarKey:" + toolbarKey));
        logger.info((Object)("primaryKey:" + primaryKey));
        logger.info((Object)("extraParameters:" + extraParameters));
        try {
            if (toolbarKey.equalsIgnoreCase("tool.contenttool.contentVersionHeader")) {
                return this.getContentVersionButtons();
            }
            if (toolbarKey.equalsIgnoreCase("tool.common.globalSubscriptions.header")) {
                return this.getGlobalSubscriptionsButtons();
            }
            if (toolbarKey.equalsIgnoreCase("tool.managementtool.viewGroupProperties.header")) {
                return this.getGroupPropertiesButtons();
            }
            if (toolbarKey.equalsIgnoreCase("tool.managementtool.viewRoleProperties.header")) {
                return this.getRolePropertiesButtons();
            }
            if (toolbarKey.equalsIgnoreCase("tool.managementtool.viewUserProperties.header")) {
                return this.getUserPropertiesButtons();
            }
            if (toolbarKey.equalsIgnoreCase("tool.managementtool.viewSystemUserList.header")) {
                return this.getSystemUsersButtons();
            }
            if (toolbarKey.equalsIgnoreCase("tool.managementtool.viewSystemUser.header")) {
                return this.getSystemUserDetailsButtons();
            }
            if (toolbarKey.equalsIgnoreCase("tool.managementtool.viewRoleList.header")) {
                return this.getRolesButtons();
            }
            if (toolbarKey.equalsIgnoreCase("tool.managementtool.viewRole.header")) {
                return this.getRoleDetailsButtons();
            }
            if (toolbarKey.equalsIgnoreCase("tool.managementtool.viewGroupList.header")) {
                return this.getGroupsButtons();
            }
            if (toolbarKey.equalsIgnoreCase("tool.managementtool.viewGroup.header")) {
                return this.getGroupDetailsButtons();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<ToolbarButton> getFooterToolbarButtons(String toolbarKey, InfoGluePrincipal principal, Locale locale, String primaryKey, String extraParameters, boolean disableCloseButton) {
        Timer t = new Timer();
        this.toolbarKey = toolbarKey;
        this.principal = principal;
        this.locale = locale;
        this.primaryKey = primaryKey;
        this.extraParameters = extraParameters;
        this.disableCloseButton = disableCloseButton;
        try {
            this.primaryKeyAsInteger = new Integer(primaryKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.info((Object)("toolbarKey:" + toolbarKey));
        logger.info((Object)("primaryKey:" + primaryKey));
        logger.info((Object)("extraParameters:" + extraParameters));
        try {
            if (toolbarKey.equalsIgnoreCase("tool.contenttool.contentVersionHeader")) {
                return this.getContentVersionFooterButtons();
            }
            if (toolbarKey.equalsIgnoreCase("tool.structuretool.createSiteNodeHeader")) {
                return this.getCreateSiteNodeFooterButtons();
            }
            if (toolbarKey.equalsIgnoreCase("tool.managementtool.viewMessageCenter.header")) {
                return this.getMessageCenterFooterButtons();
            }
            if (toolbarKey.equalsIgnoreCase("tool.common.subscriptions.header")) {
                return this.getSaveCancelFooterButtons();
            }
            if (toolbarKey.equalsIgnoreCase("tool.managementtool.viewGroupProperties.header")) {
                return this.getEntityPropertiesFooterButtons();
            }
            if (toolbarKey.equalsIgnoreCase("tool.managementtool.viewRoleProperties.header")) {
                return this.getEntityPropertiesFooterButtons();
            }
            if (toolbarKey.equalsIgnoreCase("tool.managementtool.viewUserProperties.header")) {
                return this.getEntityPropertiesFooterButtons();
            }
            if (toolbarKey.equalsIgnoreCase("tool.managementtool.createSystemUser.header")) {
                return this.getCreateSystemUserFooterButtons();
            }
            if (toolbarKey.equalsIgnoreCase("tool.managementtool.viewSystemUser.header")) {
                return this.getSystemUserDetailFooterButtons();
            }
            if (toolbarKey.equalsIgnoreCase("tool.managementtool.viewRole.header")) {
                return this.getRoleDetailFooterButtons();
            }
            if (toolbarKey.equalsIgnoreCase("tool.managementtool.createRole.header")) {
                return this.getCreateRoleFooterButtons();
            }
            if (toolbarKey.equalsIgnoreCase("tool.managementtool.viewGroup.header")) {
                return this.getGroupDetailFooterButtons();
            }
            if (toolbarKey.equalsIgnoreCase("tool.managementtool.createGroup.header")) {
                return this.getCreateGroupFooterButtons();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private List<ToolbarButton> getGroupDetailFooterButtons() throws Exception {
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        buttons.add(this.getCommonFooterSaveButton());
        buttons.add(this.getCommonFooterSaveAndExitButton("UpdateGroup!saveAndExitV3.action"));
        buttons.add(this.getCommonFooterCancelButton("ViewListGroup!listManagableGroups.action"));
        return buttons;
    }

    private List<ToolbarButton> getCreateGroupFooterButtons() throws Exception {
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        buttons.add(this.getCommonFooterSaveButton());
        buttons.add(this.getCommonFooterSaveAndExitButton("CreateGroup!saveAndExitV3.action"));
        buttons.add(this.getCommonFooterCancelButton("ViewListGroup!listManagableGroups.action"));
        return buttons;
    }

    private List<ToolbarButton> getRoleDetailFooterButtons() throws Exception {
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        buttons.add(this.getCommonFooterSaveButton());
        buttons.add(this.getCommonFooterSaveAndExitButton("UpdateRole!saveAndExitV3.action"));
        buttons.add(this.getCommonFooterCancelButton("ViewListRole!listManagableRoles.action"));
        return buttons;
    }

    private List<ToolbarButton> getCreateRoleFooterButtons() throws Exception {
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        buttons.add(this.getCommonFooterSaveButton());
        buttons.add(this.getCommonFooterSaveAndExitButton("CreateRole!saveAndExitV3.action"));
        buttons.add(this.getCommonFooterCancelButton("ViewListRole!listManagableRoles.action"));
        return buttons;
    }

    private List<ToolbarButton> getSystemUserDetailFooterButtons() throws Exception {
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        InfoGluePrincipal infoGluePrincipal = UserControllerProxy.getController().getUser(this.primaryKey);
        if (infoGluePrincipal == null) {
            throw new SystemException("No user found called '" + this.primaryKey + "'. This could be an encoding issue if you gave your user a login name with non ascii chars in it. Look in the administrative manual on how to solve it.");
        }
        boolean supportsUpdate = infoGluePrincipal.getAutorizationModule().getSupportUpdate();
        if (supportsUpdate) {
            buttons.add(this.getCommonFooterSaveButton());
            buttons.add(this.getCommonFooterSaveAndExitButton("UpdateSystemUser!saveAndExitV3.action"));
        }
        buttons.add(this.getCommonFooterCancelButton("ViewListSystemUser!v3.action"));
        return buttons;
    }

    private List<ToolbarButton> getCreateSystemUserFooterButtons() throws Exception {
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        buttons.add(this.getCommonFooterSaveButton());
        buttons.add(this.getCommonFooterSaveAndExitButton("CreateSystemUser!saveAndExitV3.action"));
        buttons.add(this.getCommonFooterCancelButton("ViewListSystemUser!listManagableSystemUsers.action"));
        return buttons;
    }

    private List<ToolbarButton> getEntityPropertiesFooterButtons() throws Exception {
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.contenttool.save.label"), this.getLocalizedString(this.locale, "tool.contenttool.save.label"), "validateAndSubmitContentForm();", "images/v3/saveInlineIcon.gif", "left", true));
        buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.contenttool.saveAndExit.label"), this.getLocalizedString(this.locale, "tool.contenttool.saveAndExit.label"), "validateAndSubmitContentFormThenExit();", "images/v3/saveAndExitInlineIcon.gif", "left", true));
        buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.contenttool.cancel.label"), this.getLocalizedString(this.locale, "tool.contenttool.cancel.label"), "cancel();", "images/v3/cancelIcon.gif", "left", true));
        return buttons;
    }

    private List<ToolbarButton> getContentVersionButtons() throws Exception {
        Timer t = new Timer();
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        LanguageVO currentLanguageVO = null;
        ContentVO contentVO = null;
        if (this.primaryKeyAsInteger != null) {
            ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getContentVersionVOWithId(this.primaryKeyAsInteger);
            contentVO = ContentController.getContentController().getContentVOWithId(contentVersionVO.getContentId());
            currentLanguageVO = LanguageController.getController().getLanguageVOWithId(contentVersionVO.getLanguageId());
        } else {
            Map extraParametersMap = new HttpHelper().toMap(this.extraParameters, "UTF-8");
            contentVO = ContentController.getContentController().getContentVOWithId(new Integer((String)extraParametersMap.get("contentId")));
            currentLanguageVO = LanguageController.getController().getLanguageVOWithId(new Integer((String)extraParametersMap.get("languageId")));
        }
        ToolbarButton languageDropButton = new ToolbarButton("", StringUtils.capitalize((String)currentLanguageVO.getDisplayLanguage()), StringUtils.capitalize((String)currentLanguageVO.getDisplayLanguage()), "", "images/v3/menu-button-arrow.png", "right", false);
        for (LanguageVO languageVO : LanguageController.getController().getLanguageVOList(contentVO.getRepositoryId())) {
            if (currentLanguageVO.getId().equals(languageVO.getId())) continue;
            languageDropButton.getSubButtons().add(new ToolbarButton("" + languageVO.getId(), StringUtils.capitalize((String)languageVO.getDisplayLanguage()), StringUtils.capitalize((String)languageVO.getDisplayLanguage()), "changeLanguage(" + contentVO.getId() + ", " + languageVO.getId() + ");", ""));
        }
        buttons.add(languageDropButton);
        return buttons;
    }

    private List<ToolbarButton> getContentVersionFooterButtons() throws Exception {
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.contenttool.save.label"), this.getLocalizedString(this.locale, "tool.contenttool.save.label"), "javascript:validateAndSubmitContentForm();", "images/v3/saveInlineIcon.gif"));
        buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.contenttool.saveAndExit.label"), this.getLocalizedString(this.locale, "tool.contenttool.saveAndExit.label"), "javascript:validateAndSubmitContentFormThenClose();", "images/v3/saveAndExitInlineIcon.gif"));
        buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.contenttool.cancel.label"), this.getLocalizedString(this.locale, "tool.contenttool.cancel.label"), "if(parent && parent.closeDialog) parent.closeDialog(); else window.close();", "images/v3/cancelIcon.gif", "left", true));
        return buttons;
    }

    private List<ToolbarButton> getCreateSiteNodeButtons() throws Exception {
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.contenttool.save.label"), this.getLocalizedString(this.locale, "tool.contenttool.save.label"), "javascript:validateAndSubmitContentForm();", "images/v3/saveInlineIcon.gif"));
        return buttons;
    }

    private List<ToolbarButton> getCreateSiteNodeFooterButtons() throws Exception {
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.common.saveButton.label"), this.getLocalizedString(this.locale, "tool.common.saveButton.label"), "document.editForm.submit()", "images/v3/createBackgroundPenPaper.gif", "left", true));
        buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.common.cancelButton.label"), this.getLocalizedString(this.locale, "tool.common.cancelButton.label"), "if(parent && parent.closeDialog) parent.closeDialog(); else window.close();", "images/v3/cancelIcon.gif", "left", true));
        return buttons;
    }

    private List<ToolbarButton> getMessageCenterFooterButtons() {
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.common.nextButton.label"), this.getLocalizedString(this.locale, "tool.common.nextButton.label"), "submitForm();", "images/v3/nextBackground.gif", "left", true));
        buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.common.cancelButton.label"), this.getLocalizedString(this.locale, "tool.common.cancelButton.label"), "if(parent && parent.closeDialog) parent.closeDialog(); else window.close();", "images/v3/cancelIcon.gif", "left", true));
        return buttons;
    }

    private List<ToolbarButton> getSaveCancelFooterButtons() {
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.common.saveButton.label"), this.getLocalizedString(this.locale, "tool.common.saveButton.label"), "submitForm();", "images/v3/createBackgroundPenPaper.gif", "left", true));
        buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.common.cancelButton.label"), this.getLocalizedString(this.locale, "tool.common.cancelButton.label"), "if(parent && parent.closeDialog) parent.closeDialog(); else window.close();", "images/v3/cancelIcon.gif", "left", true));
        return buttons;
    }

    private List<ToolbarButton> getGlobalSubscriptionsButtons() {
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.common.createSubscription.header"), this.getLocalizedString(this.locale, "tool.common.createSubscription.header"), "showDiv('newSubscriptionForm')", "images/v3/createBackgroundPenPaper.gif", "left", true));
        return buttons;
    }

    private List<ToolbarButton> getSystemUsersButtons() throws Exception {
        boolean hasAccessToCreateRole;
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        if (UserControllerProxy.getController().getSupportCreate() && (hasAccessToCreateRole = this.hasAccessTo(this.principal, "SystemUser.Create", true))) {
            buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.managementtool.createSystemUser.header"), this.getLocalizedString(this.locale, "tool.managementtool.createSystemUser.header"), "CreateSystemUser!inputV3.action", "images/v3/createBackgroundPenPaper.gif"));
        }
        return buttons;
    }

    private List<ToolbarButton> getSystemUserDetailsButtons() throws Exception {
        List contentTypeDefinitionVOList;
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        String yesDestination = URLEncoder.encode("DeleteSystemUser!v3.action?userName=" + URLEncoder.encode(this.primaryKey, this.URIEncoding), this.URIEncoding);
        String noDestination = URLEncoder.encode("ViewListSystemUser!v3.action", this.URIEncoding);
        String message = URLEncoder.encode("Do you really want to delete the user " + URLEncoder.encode(this.primaryKey, this.URIEncoding), this.URIEncoding);
        if (!this.primaryKey.equals(CmsPropertyHandler.getAnonymousUser())) {
            InfoGluePrincipal user = UserControllerProxy.getController().getUser(this.primaryKey);
            if (user.getAutorizationModule().getSupportDelete()) {
                buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.managementtool.deleteSystemUser.header"), this.getLocalizedString(this.locale, "tool.managementtool.deleteSystemUser.header"), "Confirm.action?header=tool.managementtool.deleteSystemUser.header&yesDestination=" + yesDestination + "&noDestination=" + noDestination + "&message=tool.managementtool.deleteSystemUser.text&extraParameters=" + URLEncoder.encode(this.primaryKey, this.URIEncoding), "images/v3/createBackgroundPenPaper.gif"));
            }
            if (user.getAutorizationModule().getSupportUpdate()) {
                buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.managementtool.viewSystemUserPasswordDialog.header"), this.getLocalizedString(this.locale, "tool.managementtool.viewSystemUserPasswordDialog.header"), "UpdateSystemUserPassword!inputV3.action?userName=" + URLEncoder.encode(URLEncoder.encode(this.primaryKey, this.URIEncoding), this.URIEncoding), "images/v3/passwordIcon.gif"));
            }
        }
        if ((contentTypeDefinitionVOList = UserPropertiesController.getController().getContentTypeDefinitionVOList(this.primaryKey)).size() > 0) {
            buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.managementtool.viewUserProperties.header"), this.getLocalizedString(this.locale, "tool.managementtool.viewUserProperties.header"), "ViewUserProperties!v3.action?userName=" + URLEncoder.encode(URLEncoder.encode(this.primaryKey, this.URIEncoding), this.URIEncoding), "images/v3/advancedSettingsIcon.gif"));
        }
        if (this.principal.getIsAdministrator()) {
            buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.managementtool.transferAccessRights.header"), this.getLocalizedString(this.locale, "tool.managementtool.transferAccessRights.header"), "AuthorizationSwitchManagement!inputUser.action?userName=" + URLEncoder.encode(URLEncoder.encode(this.primaryKey, this.URIEncoding)), "images/v3/createBackgroundPenPaper.gif"));
        }
        return buttons;
    }

    private List<ToolbarButton> getRolesButtons() throws Exception {
        boolean hasAccessToCreateRole;
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        if (RoleControllerProxy.getController().getSupportCreate() && (hasAccessToCreateRole = this.hasAccessTo(this.principal, "Role.Create", true))) {
            buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.managementtool.createRole.header"), this.getLocalizedString(this.locale, "tool.managementtool.createRole.header"), "CreateRole!inputV3.action", "images/v3/createBackgroundPenPaper.gif"));
        }
        return buttons;
    }

    private List<ToolbarButton> getRoleDetailsButtons() throws Exception {
        boolean hasAccessToEditProperties;
        List contentTypeDefinitionVOList;
        boolean hasAccessToDeleteRole;
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        String yesDestination = URLEncoder.encode("DeleteRole!v3.action?roleName=" + URLEncoder.encode(this.primaryKey, this.URIEncoding), this.URIEncoding);
        String noDestination = URLEncoder.encode("ViewListRole!listManagableRoles.action", this.URIEncoding);
        String message = URLEncoder.encode("Do you really want to delete the role " + URLEncoder.encode(this.primaryKey, this.URIEncoding), this.URIEncoding);
        InfoGlueRole role = RoleControllerProxy.getController().getRole(this.primaryKey);
        if (role.getAutorizationModule().getSupportDelete() && (hasAccessToDeleteRole = this.hasAccessTo(this.principal, "Role.Delete", this.primaryKey))) {
            buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.managementtool.deleteRole.header"), this.getLocalizedString(this.locale, "tool.managementtool.deleteRole.header"), "Confirm.action?header=tool.managementtool.deleteRole.header&yesDestination=" + yesDestination + "&noDestination=" + noDestination + "&message=tool.managementtool.deleteRole.text&extraParameters=" + URLEncoder.encode(this.primaryKey, this.URIEncoding), "images/v3/deleteBackgroundWasteBasket.gif"));
        }
        if ((contentTypeDefinitionVOList = RolePropertiesController.getController().getContentTypeDefinitionVOList(this.primaryKey)).size() > 0 && (hasAccessToEditProperties = this.hasAccessTo(this.principal, "Role.EditProperties", true))) {
            buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.managementtool.viewRoleProperties.header"), this.getLocalizedString(this.locale, "tool.managementtool.viewRoleProperties.header"), "ViewRoleProperties!v3.action?roleName=" + URLEncoder.encode(URLEncoder.encode(this.primaryKey, this.URIEncoding)), "images/v3/advancedSettingsIcon.gif"));
        }
        boolean hasAccessToManageAllAccessRights = this.hasAccessTo(this.principal, "Role.ManageAllAccessRights", true);
        boolean hasAccessToManageAccessRights = this.hasAccessTo(this.principal, "Role.ManageAccessRights", this.primaryKey);
        if (hasAccessToManageAllAccessRights || hasAccessToManageAccessRights) {
            buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.contenttool.accessRights.header"), this.getLocalizedString(this.locale, "tool.contenttool.accessRights.header"), "ViewAccessRights.action?interceptionPointCategory=Role&extraParameters=" + URLEncoder.encode(this.primaryKey, this.URIEncoding) + "&returnAddress=ViewRole!v3.action?roleName=" + URLEncoder.encode(this.primaryKey, this.URIEncoding) + "&colorScheme=ManagementTool", "images/v3/accessRightsIcon.gif"));
        }
        return buttons;
    }

    private List<ToolbarButton> getGroupsButtons() throws Exception {
        boolean hasAccessToCreateGroup;
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        if (GroupControllerProxy.getController().getSupportCreate() && (hasAccessToCreateGroup = this.hasAccessTo(this.principal, "Group.Create", true))) {
            buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.managementtool.createGroup.header"), this.getLocalizedString(this.locale, "tool.managementtool.createGroup.header"), "CreateGroup!inputV3.action", "images/v3/createBackgroundPenPaper.gif"));
        }
        return buttons;
    }

    private List<ToolbarButton> getGroupDetailsButtons() throws Exception {
        boolean hasAccessToEditProperties;
        List contentTypeDefinitionVOList;
        boolean hasAccessToDeleteGroup;
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        String yesDestination = URLEncoder.encode("DeleteGroup!v3.action?groupName=" + URLEncoder.encode(this.primaryKey, this.URIEncoding), this.URIEncoding);
        String noDestination = URLEncoder.encode("ViewListGroup!listManagableGroups.action", this.URIEncoding);
        String message = URLEncoder.encode("Do you really want to delete the group " + URLEncoder.encode(this.primaryKey, this.URIEncoding), this.URIEncoding);
        InfoGlueGroup group = GroupControllerProxy.getController().getGroup(this.primaryKey);
        if (group.getAutorizationModule().getSupportDelete() && (hasAccessToDeleteGroup = this.hasAccessTo(this.principal, "Group.Delete", this.primaryKey))) {
            buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.managementtool.deleteGroup.header"), this.getLocalizedString(this.locale, "tool.managementtool.deleteGroup.header"), "Confirm.action?header=tool.managementtool.deleteGroup.header&yesDestination=" + yesDestination + "&noDestination=" + noDestination + "&message=tool.managementtool.deleteGroup.text&extraParameters=" + URLEncoder.encode(this.primaryKey, this.URIEncoding), "images/v3/deleteBackgroundWasteBasket.gif"));
        }
        if ((contentTypeDefinitionVOList = GroupPropertiesController.getController().getContentTypeDefinitionVOList(this.primaryKey)).size() > 0 && (hasAccessToEditProperties = this.hasAccessTo(this.principal, "Group.EditProperties", true))) {
            buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.managementtool.viewGroupProperties.header"), this.getLocalizedString(this.locale, "tool.managementtool.viewGroupProperties.header"), "ViewGroupProperties!v3.action?groupName=" + URLEncoder.encode(URLEncoder.encode(this.primaryKey, this.URIEncoding)), "images/v3/advancedSettingsIcon.gif"));
        }
        boolean hasAccessToManageAllAccessRights = this.hasAccessTo(this.principal, "Group.ManageAllAccessRights", true);
        boolean hasAccessToManageAccessRights = this.hasAccessTo(this.principal, "Group.ManageAccessRights", this.primaryKey);
        if (hasAccessToManageAllAccessRights || hasAccessToManageAccessRights) {
            buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.contenttool.accessRights.header"), this.getLocalizedString(this.locale, "tool.contenttool.accessRights.header"), "ViewAccessRights.action?interceptionPointCategory=Group&extraParameters=" + URLEncoder.encode(this.primaryKey, this.URIEncoding) + "&returnAddress=ViewGroup!v3.action?groupName=" + URLEncoder.encode(this.primaryKey, this.URIEncoding) + "&colorScheme=ManagementTool", "images/v3/accessRightsIcon.gif"));
        }
        return buttons;
    }

    private List<ToolbarButton> getGroupPropertiesButtons() throws Exception {
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.contenttool.uploadDigitalAsset.label"), this.getLocalizedString(this.locale, "tool.contenttool.uploadDigitalAsset.label"), "openWindow('ViewDigitalAsset.action?entity=org.infoglue.cms.entities.management.GroupProperties&entityId=" + this.primaryKey + "', 'DigitalAsset', 'width=400,height=200,resizable=no');", "images/v3/attachAssetBackgroundIcon.gif", "left", true));
        return buttons;
    }

    private List<ToolbarButton> getRolePropertiesButtons() throws Exception {
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.contenttool.uploadDigitalAsset.label"), this.getLocalizedString(this.locale, "tool.contenttool.uploadDigitalAsset.label"), "openWindow('ViewDigitalAsset.action?entity=org.infoglue.cms.entities.management.RoleProperties&entityId=" + this.primaryKey + "', 'DigitalAsset', 'width=400,height=200,resizable=no');", "images/v3/attachAssetBackgroundIcon.gif", "left", true));
        return buttons;
    }

    private List<ToolbarButton> getUserPropertiesButtons() throws Exception {
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        buttons.add(new ToolbarButton("", this.getLocalizedString(this.locale, "tool.contenttool.uploadDigitalAsset.label"), this.getLocalizedString(this.locale, "tool.contenttool.uploadDigitalAsset.label"), "openWindow('ViewDigitalAsset.action?entity=org.infoglue.cms.entities.management.UserProperties&entityId=" + this.primaryKey + "', 'DigitalAsset', 'width=400,height=200,resizable=no');", "images/v3/attachAssetBackgroundIcon.gif", "left", true));
        return buttons;
    }

    private List<ToolbarButton> getHelpButton() throws Exception {
        String helpPageBaseUrl = "http://www.infoglue.org";
        String helpPageUrl = "";
        if (this.toolbarKey.equalsIgnoreCase("tool.contenttool.contentVersionHeader")) {
            helpPageUrl = "/help/tools/contenttool/contentVersion";
        }
        if (this.toolbarKey.equalsIgnoreCase("tool.managementtool.viewRoleList.header")) {
            helpPageUrl = "/help/tools/managementtool/roles";
        }
        if (this.toolbarKey.equalsIgnoreCase("tool.managementtool.viewRole.header")) {
            helpPageUrl = "/help/tools/managementtool/role";
        }
        if (this.toolbarKey.equalsIgnoreCase("tool.managementtool.createRole.header")) {
            helpPageUrl = "/help/tools/managementtool/create_role";
        }
        if (this.toolbarKey.equalsIgnoreCase("tool.managementtool.viewGroupList.header")) {
            helpPageUrl = "/help/tools/managementtool/groups";
        }
        if (this.toolbarKey.equalsIgnoreCase("tool.managementtool.viewGroup.header")) {
            helpPageUrl = "/help/tools/managementtool/group";
        }
        if (this.toolbarKey.equalsIgnoreCase("tool.managementtool.createGroup.header")) {
            helpPageUrl = "/help/tools/managementtool/create_group";
        }
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        buttons.add(new ToolbarButton("helpButton", this.getLocalizedString(this.locale, "tool.common.helpButton.label"), this.getLocalizedString(this.locale, "tool.common.helpButton.title"), helpPageUrl, "images/v3/helpIcon.gif"));
        return buttons;
    }

    private List<ToolbarButton> getWindowCloseButton() throws Exception {
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        buttons.add(new ToolbarButton("exitButton", this.getLocalizedString(this.locale, "tool.common.closeWindowButton.label"), this.getLocalizedString(this.locale, "tool.common.closeWindowButton.title"), "if(parent && parent.closeDialog) parent.closeDialog(); else window.close();", "images/v3/closeWindowIcon.gif", "right", true));
        return buttons;
    }

    private List<ToolbarButton> getDialogCloseButton() throws Exception {
        ArrayList<ToolbarButton> buttons = new ArrayList<ToolbarButton>();
        buttons.add(new ToolbarButton("exitButton", this.getLocalizedString(this.locale, "tool.common.closeWindowButton.label"), this.getLocalizedString(this.locale, "tool.common.closeWindowButton.title"), "if(parent && parent.closeDialog) parent.closeDialog(); else window.close();", "images/v3/closeWindowIcon.gif", "right", true));
        return buttons;
    }

    private ToolbarButton getCommonFooterSaveButton() {
        return new ToolbarButton("", this.getLocalizedString(this.locale, "tool.contenttool.save.label"), this.getLocalizedString(this.locale, "tool.contenttool.save.label"), "save(document.inputForm);", "images/v3/saveInlineIcon.gif", "left", true);
    }

    private ToolbarButton getCommonFooterSaveAndExitButton(String exitUrl) {
        return new ToolbarButton("", this.getLocalizedString(this.locale, "tool.contenttool.saveAndExit.label"), this.getLocalizedString(this.locale, "tool.contenttool.saveAndExit.label"), "saveAndExit(document.inputForm, \"" + exitUrl + "\");", "images/v3/saveAndExitInlineIcon.gif", "left", true);
    }

    private ToolbarButton getCommonFooterCancelButton(String cancelUrl) {
        return new ToolbarButton("", this.getLocalizedString(this.locale, "tool.contenttool.cancel.label"), this.getLocalizedString(this.locale, "tool.contenttool.cancel.label"), cancelUrl, "images/v3/cancelIcon.gif", "left", false);
    }

    public boolean hasAccessTo(InfoGluePrincipal principal, String interceptionPointName, boolean returnSuccessIfInterceptionPointNotDefined) {
        logger.info((Object)("Checking if " + principal.getName() + " has access to " + interceptionPointName));
        try {
            return AccessRightController.getController().getIsPrincipalAuthorized(principal, interceptionPointName, returnSuccessIfInterceptionPointNotDefined);
        }
        catch (SystemException e) {
            logger.warn((Object)"Error checking access rights", (Throwable)e);
            return false;
        }
    }

    public boolean hasAccessTo(InfoGluePrincipal principal, String interceptionPointName, String extraParameter) {
        logger.info((Object)("Checking if " + principal.getName() + " has access to " + interceptionPointName + " with extraParameter " + extraParameter));
        try {
            return AccessRightController.getController().getIsPrincipalAuthorized(principal, interceptionPointName, extraParameter);
        }
        catch (SystemException e) {
            logger.warn((Object)"Error checking access rights", (Throwable)e);
            return false;
        }
    }

    public String getLocalizedString(Locale locale, String key) {
        StringManager stringManager = StringManagerFactory.getPresentationStringManager("org.infoglue.cms.applications", locale);
        return stringManager.getString(key);
    }
}

