/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupController;
import org.infoglue.cms.controllers.kernel.impl.simple.RoleController;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.Group;
import org.infoglue.cms.entities.management.Role;
import org.infoglue.cms.entities.management.SystemUser;
import org.infoglue.cms.entities.management.SystemUserVO;
import org.infoglue.cms.entities.management.impl.simple.SystemUserImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.PasswordGenerator;
import org.infoglue.cms.util.mail.MailServiceFactory;

public class SystemUserController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)SystemUserController.class.getName());

    public static SystemUserController getController() {
        return new SystemUserController();
    }

    public SystemUserVO getSystemUserVOWithName(String name) throws SystemException, Bug {
        SystemUserVO systemUserVO = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            SystemUserController.beginTransaction(db);
            systemUserVO = this.getReadOnlySystemUserWithName(name, db).getValueObject();
            SystemUserController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            SystemUserController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return systemUserVO;
    }

    public SystemUser getReadOnlySystemUserWithName(String userName, Database db) throws SystemException, Bug {
        SystemUser systemUser = null;
        try {
            OQLQuery oql = db.getOQLQuery("SELECT u FROM org.infoglue.cms.entities.management.impl.simple.SystemUserImpl u WHERE u.userName = $1");
            oql.bind((Object)userName);
            QueryResults results = oql.execute((short)0);
            if (results.hasMore()) {
                systemUser = (SystemUser)results.next();
                logger.info((Object)("found one:" + systemUser.getFirstName()));
            }
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch " + userName + " Reason:" + e.getMessage(), e);
        }
        return systemUser;
    }

    public SystemUser getSystemUserWithName(String userName, Database db) throws SystemException, Bug {
        SystemUser systemUser = null;
        try {
            OQLQuery oql = db.getOQLQuery("SELECT u FROM org.infoglue.cms.entities.management.impl.simple.SystemUserImpl u WHERE u.userName = $1");
            oql.bind((Object)userName);
            QueryResults results = oql.execute();
            logger.info((Object)("Fetching entity in read/write mode" + userName));
            if (results.hasMore()) {
                systemUser = (SystemUser)results.next();
                logger.info((Object)("found one:" + systemUser.getFirstName()));
            }
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch " + userName + " Reason:" + e.getMessage(), e);
        }
        return systemUser;
    }

    public SystemUserVO getSystemUserVO(String userName, String password) throws SystemException, Bug {
        SystemUserVO systemUserVO = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            SystemUserController.beginTransaction(db);
            systemUserVO = this.getSystemUserVO(db, userName, password);
            SystemUserController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            SystemUserController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return systemUserVO;
    }

    public SystemUserVO getSystemUserVO(Database db, String userName, String password) throws SystemException, Exception {
        SystemUserVO systemUserVO = null;
        OQLQuery oql = db.getOQLQuery("SELECT u FROM org.infoglue.cms.entities.management.impl.simple.SystemUserImpl u WHERE u.userName = $1 AND u.password = $2");
        oql.bind((Object)userName);
        oql.bind((Object)password);
        QueryResults results = oql.execute((short)0);
        if (results.hasMore()) {
            SystemUser systemUser = (SystemUser)results.next();
            systemUserVO = systemUser.getValueObject();
            logger.info((Object)("found one:" + systemUserVO.getFirstName()));
        }
        results.close();
        oql.close();
        return systemUserVO;
    }

    public SystemUser getSystemUser(Database db, String userName, String password) throws SystemException, Exception {
        SystemUser systemUser = null;
        OQLQuery oql = db.getOQLQuery("SELECT u FROM org.infoglue.cms.entities.management.impl.simple.SystemUserImpl u WHERE u.userName = $1 AND u.password = $2");
        oql.bind((Object)userName);
        oql.bind((Object)password);
        QueryResults results = oql.execute();
        logger.info((Object)("Fetching entity in read/write mode" + userName));
        if (results.hasMore()) {
            systemUser = (SystemUser)results.next();
            logger.info((Object)("found one:" + systemUser.getFirstName()));
        }
        results.close();
        oql.close();
        return systemUser;
    }

    public List getSystemUserVOList() throws SystemException, Bug {
        return this.getAllVOObjects(SystemUserImpl.class, "userName");
    }

    public List getSystemUserVOList(Database db) throws SystemException, Bug {
        return this.getAllVOObjects(SystemUserImpl.class, "userName", db);
    }

    public List getSystemUserList(Database db) throws SystemException, Bug {
        return this.getAllObjects(SystemUserImpl.class, "userName", db);
    }

    public List getFilteredSystemUserVOList(String firstName, String lastName, String userName, String email, String[] roleNames) throws SystemException, Bug {
        List filteredList = new ArrayList();
        Database db = CastorDatabaseService.getDatabase();
        try {
            SystemUserController.beginTransaction(db);
            filteredList = this.getFilteredSystemUserList(firstName, lastName, userName, email, roleNames, db);
            SystemUserController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            SystemUserController.rollbackTransaction(db);
            throw new SystemException("An error occurred so we should not complete the transaction:" + e, e);
        }
        return SystemUserController.toVOList(filteredList);
    }

    public List getFilteredSystemUserList(String firstName, String lastName, String userName, String email, String[] roleNames, Database db) throws SystemException, Bug, Exception {
        ArrayList<SystemUser> filteredList = new ArrayList<SystemUser>();
        OQLQuery oql = db.getOQLQuery("SELECT u FROM org.infoglue.cms.entities.management.impl.simple.SystemUserImpl u ORDER BY u.userName");
        QueryResults results = oql.execute((short)0);
        while (results.hasMore()) {
            SystemUser extranetUser = (SystemUser)results.next();
            boolean include = true;
            if (firstName != null && !firstName.equals("") && extranetUser.getFirstName().toLowerCase().indexOf(firstName.toLowerCase()) == -1) {
                include = false;
            }
            if (lastName != null && !lastName.equals("") && extranetUser.getLastName().toLowerCase().indexOf(lastName.toLowerCase()) == -1) {
                include = false;
            }
            if (userName != null && !userName.equals("") && extranetUser.getUserName().toLowerCase().indexOf(userName.toLowerCase()) == -1) {
                include = false;
            }
            if (email != null && !email.equals("") && extranetUser.getEmail().toLowerCase().indexOf(email.toLowerCase()) == -1) {
                include = false;
            }
            boolean hasRoles = true;
            if (roleNames != null && roleNames.length > 0) {
                int i = 0;
                while (i < roleNames.length) {
                    String roleName = roleNames[i];
                    if (roleName != null && !roleName.equals("")) {
                        Collection roles = extranetUser.getRoles();
                        Iterator rolesIterator = roles.iterator();
                        boolean hasRole = false;
                        while (rolesIterator.hasNext()) {
                            Role role = (Role)rolesIterator.next();
                            if (!role.getRoleName().equalsIgnoreCase(roleName)) continue;
                            hasRole = true;
                            break;
                        }
                        if (!hasRole) {
                            hasRoles = false;
                            break;
                        }
                    }
                    ++i;
                }
            }
            if (!include || !hasRoles) continue;
            filteredList.add(extranetUser);
        }
        results.close();
        oql.close();
        return filteredList;
    }

    public SystemUserVO create(SystemUserVO systemUserVO) throws ConstraintException, SystemException {
        if (CmsPropertyHandler.getUsePasswordEncryption()) {
            String password = systemUserVO.getPassword();
            try {
                String encryptedPass;
                byte[] encryptedPassRaw = DigestUtils.sha((String)password);
                password = encryptedPass = new String(new Base64().encode(encryptedPassRaw), "ASCII");
                systemUserVO.setPassword(password);
            }
            catch (Exception e) {
                System.out.println("Error generating password:" + e.getMessage());
            }
        }
        SystemUser systemUser = new SystemUserImpl();
        systemUser.setValueObject(systemUserVO);
        systemUser = (SystemUser)SystemUserController.createEntity(systemUser);
        return systemUser.getValueObject();
    }

    public SystemUser create(SystemUserVO systemUserVO, Database db) throws ConstraintException, SystemException, Exception {
        if (CmsPropertyHandler.getUsePasswordEncryption()) {
            String password = systemUserVO.getPassword();
            try {
                String encryptedPass;
                byte[] encryptedPassRaw = DigestUtils.sha((String)password);
                password = encryptedPass = new String(new Base64().encode(encryptedPassRaw), "ASCII");
                systemUserVO.setPassword(password);
            }
            catch (Exception e) {
                System.out.println("Error generating password:" + e.getMessage());
            }
        }
        SystemUser systemUser = new SystemUserImpl();
        systemUser.setValueObject(systemUserVO);
        systemUser = (SystemUser)SystemUserController.createEntity(systemUser, db);
        return systemUser;
    }

    public void delete(String userName) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        Object systemUser = null;
        SystemUserController.beginTransaction(db);
        try {
            this.delete(userName, db);
            ceb.throwIfNotEmpty();
            SystemUserController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not completes the transaction:" + ce), (Throwable)ce);
            SystemUserController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            SystemUserController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void delete(String userName, Database db) throws ConstraintException, SystemException, Exception {
        SystemUser systemUser = this.getSystemUserWithName(userName, db);
        Collection roles = systemUser.getRoles();
        for (Role role : roles) {
            role.getSystemUsers().remove(systemUser);
        }
        Collection groups = systemUser.getGroups();
        for (Group group : groups) {
            group.getSystemUsers().remove(systemUser);
        }
        db.remove((Object)systemUser);
    }

    public SystemUserVO update(SystemUserVO systemUserVO) throws ConstraintException, SystemException {
        return (SystemUserVO)SystemUserController.updateEntity(SystemUserImpl.class, systemUserVO);
    }

    public SystemUserVO update(SystemUserVO systemUserVO, String[] roleNames, String[] groupNames) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SystemUser systemUser = null;
        SystemUserController.beginTransaction(db);
        try {
            systemUser = this.update(systemUserVO, roleNames, groupNames, db);
            SystemUserController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not completes the transaction:" + ce), (Throwable)ce);
            SystemUserController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            SystemUserController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return systemUser.getValueObject();
    }

    public SystemUser update(SystemUserVO systemUserVO, String[] roleNames, String[] groupNames, Database db) throws ConstraintException, SystemException {
        int i;
        SystemUser systemUser = this.getSystemUserWithName(systemUserVO.getUserName(), db);
        systemUser.getRoles().clear();
        if (roleNames != null) {
            i = 0;
            while (i < roleNames.length) {
                Role role = RoleController.getController().getRoleWithName(roleNames[i], db);
                systemUser.getRoles().add(role);
                role.getSystemUsers().add(systemUser);
                ++i;
            }
        }
        systemUser.getGroups().clear();
        if (groupNames != null) {
            i = 0;
            while (i < groupNames.length) {
                Group group = GroupController.getController().getGroupWithName(groupNames[i], db);
                systemUser.getGroups().add(group);
                group.getSystemUsers().add(systemUser);
                ++i;
            }
        }
        systemUserVO.setPassword(systemUser.getPassword());
        systemUser.setValueObject(systemUserVO);
        return systemUser;
    }

    public void updatePassword(String userName) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SystemUserController.beginTransaction(db);
        try {
            this.updatePassword(userName, db);
            SystemUserController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            SystemUserController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void updatePassword(String userName, Database db) throws ConstraintException, SystemException {
        String newPassword;
        SystemUser systemUser = this.getSystemUserWithName(userName, db);
        String password = newPassword = PasswordGenerator.generate();
        if (CmsPropertyHandler.getUsePasswordEncryption()) {
            try {
                String encryptedPass;
                byte[] encryptedPassRaw = DigestUtils.sha((String)password);
                password = encryptedPass = new String(new Base64().encode(encryptedPassRaw), "ASCII");
            }
            catch (Exception e) {
                System.out.println("Error generating password:" + e.getMessage());
            }
        }
        systemUser.setPassword(password);
        StringBuffer sb = new StringBuffer();
        sb.append("<div><h2>Password changed</h2></div>");
        sb.append("<div>CMS notification: You or an administrator have requested a new password for your account (" + userName + "). <br/>");
        sb.append("<br/>");
        sb.append("The new password is '" + newPassword + "'.<br/>");
        sb.append("<br/>");
        sb.append("Please notify the administrator if this does not work. <br/>");
        sb.append("<br/>");
        sb.append("-----------------------------------------------------------------------<br/>");
        sb.append("This email was automatically generated and the sender is the CMS-system. <br/>");
        sb.append("Do not reply to this email. </div>");
        String systemEmailSender = CmsPropertyHandler.getSystemEmailSender();
        if (systemEmailSender == null || systemEmailSender.equalsIgnoreCase("")) {
            systemEmailSender = "InfoGlueCMS@" + CmsPropertyHandler.getMailSmtpHost();
        }
        try {
            MailServiceFactory.getService().send(systemEmailSender, systemUser.getEmail(), null, "InfoGlue Information - Password changed!!", sb.toString());
        }
        catch (Exception e) {
            logger.error((Object)("The notification was not sent to [" + systemEmailSender + ", " + systemUser.getEmail() + "]. Reason:" + e.getMessage()), (Throwable)e);
        }
    }

    public void updateAnonymousPassword(String userName) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SystemUserController.beginTransaction(db);
        try {
            this.updateAnonymousPassword(userName, db);
            SystemUserController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            SystemUserController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void updateAnonymousPassword(String userName, Database db) throws ConstraintException, SystemException {
        String newPassword;
        SystemUser systemUser = this.getSystemUserWithName(userName, db);
        String password = newPassword = "anonymous";
        if (CmsPropertyHandler.getUsePasswordEncryption()) {
            try {
                String encryptedPass;
                byte[] encryptedPassRaw = DigestUtils.sha((String)password);
                password = encryptedPass = new String(new Base64().encode(encryptedPassRaw), "ASCII");
            }
            catch (Exception e) {
                System.out.println("Error generating password:" + e.getMessage());
            }
        }
        systemUser.setPassword(password);
    }

    public void updatePassword(String userName, String oldPassword, String newPassword) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SystemUserController.beginTransaction(db);
        try {
            ceb.throwIfNotEmpty();
            this.updatePassword(userName, oldPassword, newPassword, db);
            SystemUserController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            SystemUserController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            SystemUserController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void updatePassword(String userName, String oldPassword, String newPassword, Database db) throws ConstraintException, SystemException, Exception {
        SystemUser systemUser;
        if (newPassword == null) {
            throw new ConstraintException("SystemUser.newPassword", "301");
        }
        if (CmsPropertyHandler.getUsePasswordEncryption()) {
            try {
                String encryptedOldPass;
                String encryptedPass;
                byte[] encryptedPassRaw = DigestUtils.sha((String)newPassword);
                newPassword = encryptedPass = new String(new Base64().encode(encryptedPassRaw), "ASCII");
                byte[] encryptedOldPasswordRaw = DigestUtils.sha((String)oldPassword);
                oldPassword = encryptedOldPass = new String(new Base64().encode(encryptedOldPasswordRaw), "ASCII");
            }
            catch (Exception e) {
                System.out.println("Error generating password:" + e.getMessage());
            }
        }
        if ((systemUser = this.getSystemUser(db, userName, oldPassword)) == null) {
            throw new ConstraintException("SystemUser.oldPassword", "310");
        }
        systemUser.setPassword(newPassword);
    }

    public BaseEntityVO getNewVO() {
        return new SystemUserVO();
    }
}

