/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.Subscription;
import org.infoglue.cms.entities.management.SubscriptionFilterVO;
import org.infoglue.cms.entities.management.SubscriptionVO;
import org.infoglue.cms.entities.management.impl.simple.SubscriptionFilterImpl;
import org.infoglue.cms.entities.management.impl.simple.SubscriptionImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)SubscriptionController.class.getName());

    public static SubscriptionController getController() {
        return new SubscriptionController();
    }

    public SubscriptionVO getSubscriptionVOWithId(Integer subscriptionId) throws SystemException, Bug {
        return (SubscriptionVO)SubscriptionController.getVOWithId(SubscriptionImpl.class, subscriptionId);
    }

    public Subscription getSubscriptionWithId(Integer subscriptionId, Database db) throws SystemException, Bug {
        return (Subscription)SubscriptionController.getObjectWithId(SubscriptionImpl.class, subscriptionId, db);
    }

    public List getSubscriptionVOList() throws SystemException, Bug {
        List subscriptionVOList = this.getAllVOObjects(SubscriptionImpl.class, "subscriptionId");
        return subscriptionVOList;
    }

    public List getSubscriptionVOList(Database db) throws SystemException, Bug {
        List subscriptionVOList = this.getAllVOObjects(SubscriptionImpl.class, "subscriptionId", db);
        return subscriptionVOList;
    }

    public SubscriptionVO create(SubscriptionVO subscriptionVO) throws ConstraintException, SystemException {
        Subscription subscription = new SubscriptionImpl();
        subscription.setValueObject(subscriptionVO);
        subscription = (Subscription)SubscriptionController.createEntity(subscription);
        return subscription.getValueObject();
    }

    public SubscriptionVO create(SubscriptionVO subscriptionVO, List<SubscriptionFilterVO> subscriptionFilterVOList) throws ConstraintException, SystemException {
        SubscriptionVO newSubscriptionVO = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            SubscriptionController.beginTransaction(db);
            newSubscriptionVO = this.create(subscriptionVO, subscriptionFilterVOList, db).getValueObject();
            SubscriptionController.commitTransaction(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + e));
            SubscriptionController.rollbackTransaction(db);
        }
        return newSubscriptionVO;
    }

    public Subscription create(SubscriptionVO subscriptionVO, List<SubscriptionFilterVO> subscriptionFilterVOList, Database db) throws ConstraintException, SystemException, Exception {
        Subscription subscription = new SubscriptionImpl();
        subscription.setValueObject(subscriptionVO);
        subscription = (Subscription)SubscriptionController.createEntity(subscription, db);
        for (SubscriptionFilterVO subscriptionFilterVO : subscriptionFilterVOList) {
            SubscriptionFilterImpl subscriptionFilter = new SubscriptionFilterImpl();
            subscriptionFilter.setValueObject(subscriptionFilterVO);
            subscriptionFilter.setSubscription(subscription);
            subscription.getSubscriptionFilters().add(subscriptionFilter);
        }
        return subscription;
    }

    public SubscriptionVO update(SubscriptionVO subscriptionVO, List<SubscriptionFilterVO> subscriptionFilterVOList) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        try {
            SubscriptionController.beginTransaction(db);
            Subscription subscription = this.getSubscriptionWithId(subscriptionVO.getId(), db);
            subscription.setValueObject(subscriptionVO);
            subscription.setSubscriptionFilters(new ArrayList<SubscriptionFilterImpl>());
            for (SubscriptionFilterVO subscriptionFilterVO : subscriptionFilterVOList) {
                SubscriptionFilterImpl subscriptionFilter = new SubscriptionFilterImpl();
                subscriptionFilter.setValueObject(subscriptionFilterVO);
                subscriptionFilter.setSubscription(subscription);
                logger.info((Object)("Adding subscriptionFilter:" + subscriptionFilter));
                subscription.getSubscriptionFilters().add(subscriptionFilter);
            }
            subscriptionVO = subscription.getValueObject();
            SubscriptionController.commitTransaction(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + e));
            SubscriptionController.rollbackTransaction(db);
        }
        return subscriptionVO;
    }

    public void addFilter(Integer subscriptionId, SubscriptionFilterVO subscriptionFilterVO) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        try {
            SubscriptionController.beginTransaction(db);
            Subscription subscription = this.getSubscriptionWithId(subscriptionId, db);
            SubscriptionFilterImpl subscriptionFilter = new SubscriptionFilterImpl();
            subscriptionFilter.setValueObject(subscriptionFilterVO);
            subscription.getSubscriptionFilters().add(subscriptionFilter);
            SubscriptionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + e));
            SubscriptionController.rollbackTransaction(db);
        }
    }

    public void delete(SubscriptionVO subscriptionVO) throws ConstraintException, SystemException {
        SubscriptionController.deleteEntity(SubscriptionImpl.class, subscriptionVO.getSubscriptionId());
    }

    public void delete(Integer subscriptionId) throws ConstraintException, SystemException {
        SubscriptionController.deleteEntity(SubscriptionImpl.class, subscriptionId);
    }

    public SubscriptionVO update(SubscriptionVO subscriptionVO) throws ConstraintException, SystemException {
        return (SubscriptionVO)SubscriptionController.updateEntity(SubscriptionImpl.class, subscriptionVO);
    }

    public List<SubscriptionVO> getSubscriptionVOList(Integer interceptionPointId, String name, Boolean isGlobal, String entityName, String entityId, String userName, String userEmail) throws SystemException, Exception {
        List<SubscriptionVO> subscriptionVOList = new ArrayList<SubscriptionVO>();
        Database db = CastorDatabaseService.getDatabase();
        try {
            SubscriptionController.beginTransaction(db);
            List<Subscription> subscriptionList = this.getSubscriptionList(interceptionPointId, name, isGlobal, entityName, entityId, userName, userEmail, db, true);
            subscriptionVOList = SubscriptionController.toVOList(subscriptionList);
            SubscriptionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + e));
            SubscriptionController.rollbackTransaction(db);
        }
        return subscriptionVOList;
    }

    public List<SubscriptionVO> getSubscriptionVOList(Integer interceptionPointId, String name, Boolean isGlobal, String entityName, String entityId, String userName, String userEmail, Database db, boolean readOnly) throws SystemException, Exception {
        ArrayList<SubscriptionVO> subscriptionVOList = new ArrayList();
        List<Subscription> subscriptionList = this.getSubscriptionList(interceptionPointId, name, isGlobal, entityName, entityId, userName, userEmail, db, true);
        subscriptionVOList = SubscriptionController.toVOList(subscriptionList);
        return subscriptionVOList;
    }

    public List<Subscription> getSubscriptionList(Integer interceptionPointId, String name, Boolean isGlobal, String entityName, String entityId, String userName, String userEmail, Database db, boolean readOnly) throws SystemException, Exception {
        ArrayList<Subscription> subscriptionList = new ArrayList<Subscription>();
        StringBuffer sql = new StringBuffer("SELECT s FROM org.infoglue.cms.entities.management.impl.simple.SubscriptionImpl s WHERE ");
        ArrayList<Object> bindings = new ArrayList<Object>();
        int bindingIndex = 1;
        if (interceptionPointId != null) {
            if (bindingIndex > 1) {
                sql.append(" AND ");
            }
            sql.append("s.interceptionPointId = $" + bindingIndex);
            bindings.add(interceptionPointId);
            ++bindingIndex;
        }
        if (name != null) {
            if (bindingIndex > 1) {
                sql.append(" AND ");
            }
            sql.append("s.name = $" + bindingIndex);
            bindings.add(name);
            ++bindingIndex;
        }
        if (isGlobal != null) {
            if (bindingIndex > 1) {
                sql.append(" AND ");
            }
            sql.append("s.isGlobal = $" + bindingIndex);
            bindings.add(isGlobal);
            ++bindingIndex;
        }
        if (entityName != null) {
            if (bindingIndex > 1) {
                sql.append(" AND ");
            }
            sql.append("s.entityName = $" + bindingIndex);
            bindings.add(entityName);
            ++bindingIndex;
        }
        if (entityId != null) {
            if (bindingIndex > 1) {
                sql.append(" AND ");
            }
            sql.append("s.entityId = $" + bindingIndex);
            bindings.add(entityId);
            ++bindingIndex;
        }
        if (userName != null) {
            if (bindingIndex > 1) {
                sql.append(" AND ");
            }
            sql.append("s.userName = $" + bindingIndex);
            bindings.add(userName);
            ++bindingIndex;
        }
        if (userEmail != null) {
            if (bindingIndex > 1) {
                sql.append(" AND ");
            }
            sql.append("s.userEmail = $" + bindingIndex);
            bindings.add(userEmail);
            ++bindingIndex;
        }
        sql.append(" ORDER BY s.subscriptionId");
        OQLQuery oql = db.getOQLQuery(sql.toString());
        Iterator bindingsIterator = bindings.iterator();
        while (bindingsIterator.hasNext()) {
            oql.bind(bindingsIterator.next());
        }
        QueryResults results = null;
        results = !readOnly ? oql.execute() : oql.execute((short)0);
        while (results.hasMore()) {
            Subscription subscription = (Subscription)results.next();
            subscriptionList.add(subscription);
        }
        results.close();
        oql.close();
        return subscriptionList;
    }

    @Override
    public BaseEntityVO getNewVO() {
        return null;
    }
}

