/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.controllers.kernel.impl.simple.ExtendedSearchController;
import org.infoglue.cms.controllers.kernel.impl.simple.ExtendedSearchCriterias;
import org.infoglue.cms.entities.content.impl.simple.SmallContentImpl;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.util.CmsPropertyHandler;

class SqlBuilder {
    private static final Logger logger = Logger.getLogger((String)SqlBuilder.class.getName());
    private static final String SELECT_KEYWORD = "SELECT";
    private static final String FROM_KEYWORD = "FROM";
    private static final String WHERE_KEYWORD = "WHERE";
    private static final String SPACE = " ";
    private static final String COMMA = ",";
    private static final String AND = "AND";
    private static final String OR = "OR";
    private static final String CONTENT_ALIAS = "c";
    private static final String CONTENT_VERSION_ALIAS = "cv";
    private static final String CONTENT_TABLE_SHORT = "cmCont";
    private static final String CONTENT_TABLE = "cmContent";
    private static final String CONTENT_VERSION_TABLE_SHORT = "cmContVer";
    private static final String CONTENT_VERSION_TABLE = "cmContentVersion";
    private static final String CV_ACTIVE_CLAUSE = "cv.isActive=1";
    private static final String CV_LANGUAGE_CLAUSE = "cv.languageId={0}";
    private static final String CV_STATE_CLAUSE = "cv.stateId>={0}";
    private static final String CV_CONTENT_JOIN_SHORT = "c.ContId=cv.ContId";
    private static final String CV_CONTENT_JOIN = "c.contentId=cv.contentId";
    private static final String CV_LATEST_VERSION_CLAUSE_SHORT = "cv.ContVerId in (select max(ContVerId) from cmContVer cv2 where cv2.ContId=cv.ContId AND cv2.languageId={0} AND cv2.stateId>={1} AND cv2.isActive=1)";
    private static final String CV_LATEST_VERSION_CLAUSE = "cv.contentVersionId in (select max(contentVersionId) from cmContentVersion cv2 where cv2.contentId=cv.contentId AND cv2.languageId={0} AND cv2.stateId>={1} AND cv2.isActive=1)";
    private static final String C_CONTENT_TYPE_CLAUSE_SHORT = "c.contentTypeDefId={0}";
    private static final String C_CONTENT_TYPE_CLAUSE = "c.contentTypeDefinitionId={0}";
    private static final String C_REPOSITORY_CLAUSE_SHORT = "c.repositoryId={0}";
    private static final String C_REPOSITORY_CLAUSE = "c.repositoryId={0}";
    private static final String FREETEXT_EXPRESSION_SHORT = "cv.VerValue like {0}";
    private static final String FREETEXT_EXPRESSION = "cv.versionValue like {0}";
    private static final String FROM_DATE_CLAUSE = "c.publishDateTime>={0}";
    private static final String TO_DATE_CLAUSE = "c.publishDateTime<={0}";
    private static final String FREETEXT_EXPRESSION_VARIABLE = "%<{0}><![CDATA[%{1}%]]></{0}>%";
    private static final String FREETEXT_EXPRESSION_VARIABLE_SQL_SERVER_ESCAPED = "%<{0}><![[]CDATA[[]%{1}%]]></{0}>%";
    private final ExtendedSearchCriterias criterias;
    private String sql;
    private List bindings;

    public SqlBuilder(ExtendedSearchCriterias criterias) {
        this.criterias = criterias;
        this.bindings = new ArrayList();
        logger.debug((Object)"===[sql]==============================================================");
        this.sql = this.generate();
        logger.debug((Object)"======================================================================");
        logger.debug((Object)this.sql);
        logger.debug((Object)"===[/sql]=============================================================");
    }

    public String getSQL() {
        return this.sql;
    }

    public List getBindings() {
        return this.bindings;
    }

    private String generate() {
        return "CALL SQL " + (ExtendedSearchController.useFull() ? this.generateSelectClause() : this.generateSelectClauseShort()) + SPACE + this.generateFromClause() + SPACE + this.generateWhereClause() + SPACE + (ExtendedSearchController.useFull() ? this.generateOrderByClause() : this.generateOrderByClauseShort()) + SPACE + "AS " + SmallContentImpl.class.getName();
    }

    private String generateSelectClauseShort() {
        return "SELECT c.ContId,c.name,c.publishDateTime,c.expireDateTime,c.isBranch,c.isProtected,c.creator,c.contentTypeDefId,c.repositoryId,c.parentContId,c.ContId";
    }

    private String generateSelectClause() {
        return "SELECT c.contentId,c.name,c.publishDateTime,c.expireDateTime,c.isBranch,c.isProtected,c.creator,c.contentTypeDefinitionId,c.repositoryId,c.parentContentId,c.contentId";
    }

    private String generateFromClause() {
        ArrayList<String> tables = new ArrayList<String>();
        tables.add(String.valueOf(SqlBuilder.getCONTENT_TABLE()) + SPACE + CONTENT_ALIAS);
        tables.add(String.valueOf(SqlBuilder.getCONTENT_VERSION_TABLE()) + SPACE + CONTENT_VERSION_ALIAS);
        tables.addAll(this.getCategoryTables());
        return "FROM " + this.joinCollection(tables, COMMA);
    }

    private String generateWhereClause() {
        ArrayList<String> clauses = new ArrayList<String>();
        clauses.addAll(this.getContentWhereClauses());
        clauses.add(this.getContentTypeDefinitionWhereClauses());
        if (this.criterias.getRepositoryIdList() != null && this.criterias.getRepositoryIdList().size() > 0) {
            clauses.add(this.getContentRepositoryWhereClauses());
        }
        if (this.criterias.hasFreetextCritera()) {
            clauses.add(this.getFreetextWhereClause());
        }
        clauses.addAll(this.getCategoriesWhereClauses());
        clauses.addAll(this.getDateWhereClauses());
        return "WHERE " + this.joinCollection(clauses, " AND ");
    }

    private List getContentWhereClauses() {
        ArrayList<String> clauses = new ArrayList<String>();
        String mode = CmsPropertyHandler.getOperatingMode();
        if (this.criterias.getForcedOperatingMode() != null) {
            mode = "" + this.criterias.getStateId();
        }
        clauses.add(CV_ACTIVE_CLAUSE);
        clauses.add(MessageFormat.format(SqlBuilder.getCV_LATEST_VERSION_CLAUSE(), this.criterias.getLanguage().getId().toString(), mode));
        clauses.add(SqlBuilder.getCV_CONTENT_JOIN());
        clauses.add(MessageFormat.format(CV_STATE_CLAUSE, this.getBindingVariable()));
        this.bindings.add(this.criterias.getStateId());
        if (this.criterias.hasLanguageCriteria()) {
            logger.debug((Object)" CRITERA[language]");
            clauses.add(MessageFormat.format(CV_LANGUAGE_CLAUSE, this.getBindingVariable()));
            this.bindings.add(this.criterias.getLanguage().getId());
        }
        return clauses;
    }

    private String generateOrderByClauseShort() {
        return "ORDER BY c.ContId";
    }

    private String generateOrderByClause() {
        return "ORDER BY c.contentId";
    }

    private String getContentTypeDefinitionWhereClauses() {
        ArrayList<String> expressions = new ArrayList<String>();
        if (this.criterias.hasContentTypeDefinitionVOsCriteria()) {
            logger.debug((Object)" CRITERA[content type definition]");
            for (ContentTypeDefinitionVO contentTypeDefinitionVO : this.criterias.getContentTypeDefinitions()) {
                expressions.add(MessageFormat.format(SqlBuilder.getC_CONTENT_TYPE_CLAUSE(), this.getBindingVariable()));
                this.bindings.add(contentTypeDefinitionVO.getId());
            }
        }
        return "(" + this.joinCollection(expressions, " OR ") + ")";
    }

    private String getContentRepositoryWhereClauses() {
        ArrayList<String> expressions = new ArrayList<String>();
        if (this.criterias.getRepositoryIdList() != null && this.criterias.getRepositoryIdList().size() > 0) {
            logger.debug((Object)" CRITERA[repository]");
            for (Integer repositoryId : this.criterias.getRepositoryIdList()) {
                expressions.add(MessageFormat.format(SqlBuilder.getC_REPOSITORY_CLAUSE(), this.getBindingVariable()));
                this.bindings.add(repositoryId);
            }
            return "(" + this.joinCollection(expressions, " OR ") + ")";
        }
        return "";
    }

    private List getCategoriesWhereClauses() {
        ArrayList<String> clauses = new ArrayList<String>();
        if (this.criterias.hasCategoryConditions()) {
            logger.debug((Object)" CRITERA[categories]");
            clauses.add(this.criterias.getCategories().getWhereClauseOQL(this.bindings));
        }
        return clauses;
    }

    private List getDateWhereClauses() {
        ArrayList<String> clauses = new ArrayList<String>();
        switch (this.criterias.getDateCriteriaType()) {
            case 1: {
                logger.debug((Object)" CRITERA[date : from]");
                clauses.add(MessageFormat.format(FROM_DATE_CLAUSE, this.getBindingVariable()));
                this.bindings.add(this.criterias.getFromDate());
                break;
            }
            case 2: {
                logger.debug((Object)" CRITERA[date : to]");
                clauses.add(MessageFormat.format(TO_DATE_CLAUSE, this.getBindingVariable()));
                this.bindings.add(this.criterias.getToDate());
                break;
            }
            case 3: {
                logger.debug((Object)" CRITERA[date : between]");
                clauses.add(MessageFormat.format(FROM_DATE_CLAUSE, this.getBindingVariable()));
                this.bindings.add(this.criterias.getFromDate());
                clauses.add(MessageFormat.format(TO_DATE_CLAUSE, this.getBindingVariable()));
                this.bindings.add(this.criterias.getToDate());
            }
        }
        return clauses;
    }

    private String getFreetextWhereClause() {
        logger.debug((Object)" CRITERA[freetext]");
        ArrayList<String> expressions = new ArrayList<String>();
        if (this.criterias.hasFreetextCritera()) {
            for (String xmlAttribute : this.criterias.getXmlAttributes()) {
                String freeTextExpression = MessageFormat.format(SqlBuilder.getFREETEXT_EXPRESSION(), this.getBindingVariable());
                String freeTextVariable = MessageFormat.format(SqlBuilder.getFREETEXT_EXPRESSION_VARIABLE(), xmlAttribute, this.criterias.getFreetext());
                this.bindings.add(freeTextVariable);
                expressions.add(freeTextExpression);
            }
        }
        return "(" + this.joinCollection(expressions, " OR ") + ")";
    }

    private List getCategoryTables() {
        ArrayList tables = new ArrayList();
        if (this.criterias.hasCategoryConditions()) {
            tables.addAll(this.criterias.getCategories().getFromClauseTables());
        }
        return tables;
    }

    private String joinCollection(Collection collection, String delimiter) {
        StringBuffer sb = new StringBuffer();
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            String element = (String)i.next();
            sb.append(String.valueOf(element) + (i.hasNext() ? delimiter : ""));
        }
        return sb.toString();
    }

    private String getBindingVariable() {
        return "$" + (this.bindings.size() + 1);
    }

    public static String getCONTENT_TABLE() {
        return ExtendedSearchController.useFull() ? CONTENT_TABLE : CONTENT_TABLE_SHORT;
    }

    public static String getCONTENT_VERSION_TABLE() {
        return ExtendedSearchController.useFull() ? CONTENT_VERSION_TABLE : CONTENT_VERSION_TABLE_SHORT;
    }

    public static String getC_CONTENT_TYPE_CLAUSE() {
        return ExtendedSearchController.useFull() ? C_CONTENT_TYPE_CLAUSE : C_CONTENT_TYPE_CLAUSE_SHORT;
    }

    public static String getC_REPOSITORY_CLAUSE() {
        return ExtendedSearchController.useFull() ? "c.repositoryId={0}" : "c.repositoryId={0}";
    }

    public static String getCV_CONTENT_JOIN() {
        return ExtendedSearchController.useFull() ? CV_CONTENT_JOIN : CV_CONTENT_JOIN_SHORT;
    }

    public static String getCV_LATEST_VERSION_CLAUSE() {
        return ExtendedSearchController.useFull() ? CV_LATEST_VERSION_CLAUSE : CV_LATEST_VERSION_CLAUSE_SHORT;
    }

    public static String getFREETEXT_EXPRESSION() {
        return ExtendedSearchController.useFull() ? FREETEXT_EXPRESSION : FREETEXT_EXPRESSION_SHORT;
    }

    public static String getFREETEXT_EXPRESSION_VARIABLE() {
        return ExtendedSearchController.useSQLServerDialect() ? FREETEXT_EXPRESSION_VARIABLE_SQL_SERVER_ESCAPED : FREETEXT_EXPRESSION_VARIABLE;
    }
}

