/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.InterceptionPointController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.entities.structure.SiteNodeVersion;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;

public class SiteNodeVersionControllerProxy
extends SiteNodeVersionController {
    private static final Logger logger = Logger.getLogger((String)SiteNodeVersionControllerProxy.class.getName());
    protected static final Integer NO = new Integer(0);
    protected static final Integer YES = new Integer(1);
    protected static final Integer INHERITED = new Integer(2);
    private static List interceptors = new ArrayList();

    public static SiteNodeVersionControllerProxy getSiteNodeVersionControllerProxy() {
        return new SiteNodeVersionControllerProxy();
    }

    private List getInterceptors(Integer interceptorPointId) throws SystemException, Bug {
        interceptors = InterceptionPointController.getController().getInterceptorsVOList(interceptorPointId);
        return interceptors;
    }

    public SiteNodeVersionVO getACLatestActiveSiteNodeVersionVO(InfoGluePrincipal infogluePrincipal, Integer siteNodeId, Database db) throws ConstraintException, SystemException, Bug, Exception {
        SiteNodeVersionVO siteNodeVersionVO = this.getLatestActiveSiteNodeVersionVO(db, siteNodeId);
        if (siteNodeVersionVO != null) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            hashMap.put("siteNodeVersionId", siteNodeVersionVO.getId());
            this.intercept(hashMap, "SiteNodeVersion.Read", infogluePrincipal, db);
        }
        return this.getLatestActiveSiteNodeVersionVO(db, siteNodeId);
    }

    public SiteNodeVersionVO getACLatestActiveSiteNodeVersionVO(InfoGluePrincipal infogluePrincipal, Integer siteNodeId) throws ConstraintException, SystemException, Bug, Exception {
        SiteNodeVersionVO siteNodeVersionVO = this.getLatestActiveSiteNodeVersionVO(siteNodeId);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("siteNodeVersionId", siteNodeVersionVO.getId());
        this.intercept(hashMap, "SiteNodeVersion.Read", infogluePrincipal);
        return this.getLatestActiveSiteNodeVersionVO(siteNodeId);
    }

    public SiteNodeVersionVO acUpdate(InfoGluePrincipal infogluePrincipal, SiteNodeVersionVO siteNodeVersionVO) throws ConstraintException, SystemException, Bug, Exception {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("siteNodeVersionId", siteNodeVersionVO.getId());
        this.intercept(hashMap, "SiteNodeVersion.Write", infogluePrincipal);
        return this.update(siteNodeVersionVO);
    }

    public SiteNodeVersionVO acUpdate(InfoGluePrincipal infogluePrincipal, SiteNodeVersionVO siteNodeVersionVO, Database db) throws ConstraintException, SystemException, Bug, Exception {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("siteNodeVersionId", siteNodeVersionVO.getId());
        this.intercept(hashMap, "SiteNodeVersion.Write", infogluePrincipal, db);
        return this.update(siteNodeVersionVO, db);
    }

    public Integer getProtectedSiteNodeVersionId(Integer siteNodeVersionId) {
        logger.info((Object)("siteNodeVersionId:" + siteNodeVersionId));
        Integer protectedSiteNodeVersionId = null;
        try {
            SiteNodeVersionVO siteNodeVersionVO = this.getSiteNodeVersionVOWithId(siteNodeVersionId);
            logger.info((Object)("Is Protected: " + siteNodeVersionVO.getIsProtected()));
            if (siteNodeVersionVO != null && siteNodeVersionVO.getIsProtected() != null) {
                SiteNodeVO parentSiteNodeVO;
                if (siteNodeVersionVO.getIsProtected().intValue() == NO.intValue()) {
                    protectedSiteNodeVersionId = null;
                } else if (siteNodeVersionVO.getIsProtected().intValue() == YES.intValue()) {
                    protectedSiteNodeVersionId = siteNodeVersionVO.getId();
                } else if (siteNodeVersionVO.getIsProtected().intValue() == INHERITED.intValue() && (parentSiteNodeVO = SiteNodeController.getParentSiteNode(siteNodeVersionVO.getSiteNodeId())) != null) {
                    siteNodeVersionVO = this.getLatestSiteNodeVersionVO(parentSiteNodeVO.getSiteNodeId());
                    protectedSiteNodeVersionId = this.getProtectedSiteNodeVersionId(siteNodeVersionVO.getSiteNodeVersionId());
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get if the siteNodeVersion is protected:" + e.getMessage()), (Throwable)e);
        }
        return protectedSiteNodeVersionId;
    }

    public Integer getProtectedSiteNodeVersionId(Integer siteNodeVersionId, Database db) {
        logger.info((Object)("siteNodeVersionId:" + siteNodeVersionId));
        Integer protectedSiteNodeVersionId = null;
        try {
            SiteNodeVersionVO siteNodeVersion = this.getSiteNodeVersionVOWithId(siteNodeVersionId, db);
            logger.info((Object)("Is Protected: " + siteNodeVersion.getIsProtected()));
            if (siteNodeVersion != null && siteNodeVersion.getIsProtected() != null) {
                SiteNode parentSiteNode;
                if (siteNodeVersion.getIsProtected().intValue() == NO.intValue()) {
                    protectedSiteNodeVersionId = null;
                } else if (siteNodeVersion.getIsProtected().intValue() == YES.intValue()) {
                    protectedSiteNodeVersionId = siteNodeVersion.getId();
                } else if (siteNodeVersion.getIsProtected().intValue() == INHERITED.intValue() && (parentSiteNode = SiteNodeController.getParentSiteNode(siteNodeVersion.getSiteNodeId(), db)) != null) {
                    siteNodeVersion = this.getLatestSiteNodeVersionVO(db, parentSiteNode.getSiteNodeId());
                    protectedSiteNodeVersionId = this.getProtectedSiteNodeVersionId(siteNodeVersion.getSiteNodeVersionId(), db);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get if the siteNodeVersion is protected:" + e.getMessage()), (Throwable)e);
        }
        return protectedSiteNodeVersionId;
    }

    public boolean getIsSiteNodeVersionProtected(Integer siteNodeVersionId) {
        logger.info((Object)("siteNodeVersionId:" + siteNodeVersionId));
        boolean isSiteNodeVersionProtected = false;
        try {
            SiteNodeVersionVO siteNodeVersionVO = this.getSiteNodeVersionVOWithId(siteNodeVersionId);
            logger.info((Object)("Is Protected: " + siteNodeVersionVO.getIsProtected()));
            if (siteNodeVersionVO != null && siteNodeVersionVO.getIsProtected() != null) {
                SiteNodeVO parentSiteNodeVO;
                if (siteNodeVersionVO.getIsProtected().intValue() == NO.intValue()) {
                    isSiteNodeVersionProtected = false;
                } else if (siteNodeVersionVO.getIsProtected().intValue() == YES.intValue()) {
                    isSiteNodeVersionProtected = true;
                } else if (siteNodeVersionVO.getIsProtected().intValue() == INHERITED.intValue() && (parentSiteNodeVO = SiteNodeController.getParentSiteNode(siteNodeVersionVO.getSiteNodeId())) != null) {
                    siteNodeVersionVO = this.getLatestSiteNodeVersionVO(parentSiteNodeVO.getSiteNodeId());
                    isSiteNodeVersionProtected = this.getIsSiteNodeVersionProtected(siteNodeVersionVO.getSiteNodeVersionId());
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get if the siteNodeVersion is protected:" + e.getMessage()), (Throwable)e);
        }
        return isSiteNodeVersionProtected;
    }

    public boolean getIsSiteNodeVersionProtected(Integer siteNodeVersionId, Database db) {
        logger.info((Object)("siteNodeVersionId:" + siteNodeVersionId));
        boolean isSiteNodeVersionProtected = false;
        try {
            SiteNodeVersion siteNodeVersion = this.getSiteNodeVersionWithId(siteNodeVersionId, db);
            logger.info((Object)("Is Protected: " + siteNodeVersion.getIsProtected()));
            if (siteNodeVersion != null && siteNodeVersion.getIsProtected() != null) {
                SiteNode parentSiteNode;
                if (siteNodeVersion.getIsProtected().intValue() == NO.intValue()) {
                    isSiteNodeVersionProtected = false;
                } else if (siteNodeVersion.getIsProtected().intValue() == YES.intValue()) {
                    isSiteNodeVersionProtected = true;
                } else if (siteNodeVersion.getIsProtected().intValue() == INHERITED.intValue() && (parentSiteNode = SiteNodeController.getParentSiteNode(siteNodeVersion.getValueObject().getSiteNodeId(), db)) != null) {
                    siteNodeVersion = this.getLatestSiteNodeVersion(db, parentSiteNode.getSiteNodeId(), false);
                    isSiteNodeVersionProtected = this.getIsSiteNodeVersionProtected(siteNodeVersion.getSiteNodeVersionId(), db);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get if the siteNodeVersion is protected:" + e.getMessage()), (Throwable)e);
        }
        return isSiteNodeVersionProtected;
    }
}

