/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.AvailableServiceBindingController;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.RegistryController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionControllerProxy;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.kernel.IBaseEntity;
import org.infoglue.cms.entities.management.AvailableServiceBindingVO;
import org.infoglue.cms.entities.management.Language;
import org.infoglue.cms.entities.management.RegistryVO;
import org.infoglue.cms.entities.structure.ServiceBinding;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.entities.structure.SiteNodeVersion;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.entities.structure.impl.simple.SiteNodeImpl;
import org.infoglue.cms.entities.structure.impl.simple.SiteNodeVersionImpl;
import org.infoglue.cms.entities.structure.impl.simple.SmallSiteNodeVersionImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.DateHelper;

public class SiteNodeVersionController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)SiteNodeVersionController.class.getName());
    private final RegistryController registryController = RegistryController.getController();

    public static SiteNodeVersionController getController() {
        return new SiteNodeVersionController();
    }

    public SiteNodeVersionVO getFullSiteNodeVersionVOWithId(Integer siteNodeVersionId) throws SystemException, Bug {
        return (SiteNodeVersionVO)SiteNodeVersionController.getVOWithId(SiteNodeVersionImpl.class, siteNodeVersionId);
    }

    public SiteNodeVersionVO getSiteNodeVersionVOWithId(Integer siteNodeVersionId) throws SystemException, Bug {
        return (SiteNodeVersionVO)SiteNodeVersionController.getVOWithId(SmallSiteNodeVersionImpl.class, siteNodeVersionId);
    }

    public SiteNodeVersionVO getSiteNodeVersionVOWithId(Integer siteNodeVersionId, Database db) throws SystemException, Bug {
        return (SiteNodeVersionVO)SiteNodeVersionController.getVOWithId(SmallSiteNodeVersionImpl.class, siteNodeVersionId, db);
    }

    public SiteNodeVersion getSiteNodeVersionWithId(Integer siteNodeVersionId, Database db) throws SystemException, Bug {
        return (SiteNodeVersion)SiteNodeVersionController.getObjectWithId(SiteNodeVersionImpl.class, siteNodeVersionId, db);
    }

    public static SiteNodeVersion getSiteNodeVersionWithIdAsReadOnly(Integer siteNodeVersionId, Database db) throws SystemException, Bug {
        return (SiteNodeVersion)SiteNodeVersionController.getObjectWithIdAsReadOnly(SiteNodeVersionImpl.class, siteNodeVersionId, db);
    }

    public List getSiteNodeVersionVOList() throws SystemException, Bug {
        return this.getAllVOObjects(SmallSiteNodeVersionImpl.class, "siteNodeVersionId");
    }

    public static void delete(SiteNodeVersionVO siteNodeVersionVO) throws ConstraintException, SystemException {
        SiteNodeVersionController.deleteEntity(SiteNodeVersionImpl.class, siteNodeVersionVO.getSiteNodeVersionId());
    }

    public void delete(SiteNodeVersion siteNodeVersion, Database db) throws ConstraintException, SystemException {
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        try {
            SiteNodeImpl siteNode = siteNodeVersion.getOwningSiteNode();
            Collection serviceBindings = siteNodeVersion.getServiceBindings();
            Iterator serviceBindingsIterator = serviceBindings.iterator();
            while (serviceBindingsIterator.hasNext()) {
                ServiceBinding serviceBinding = (ServiceBinding)serviceBindingsIterator.next();
                serviceBindingsIterator.remove();
                db.remove((Object)serviceBinding);
            }
            if (siteNode != null) {
                siteNode.getSiteNodeVersions().remove(siteNodeVersion);
            }
            db.remove((Object)siteNodeVersion);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    public static SiteNodeVersion createInitialSiteNodeVersion(Database db, SiteNode siteNode, InfoGluePrincipal infoGluePrincipal) throws SystemException, Bug {
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNodeVersionImpl siteNodeVersion = null;
        try {
            siteNodeVersion = new SiteNodeVersionImpl();
            siteNodeVersion.setIsCheckedOut(new Boolean(false));
            siteNodeVersion.setModifiedDateTime(DateHelper.getSecondPreciseDate());
            siteNodeVersion.setOwningSiteNode((SiteNodeImpl)siteNode);
            siteNodeVersion.setStateId(new Integer(0));
            siteNodeVersion.setVersionComment("Initial version");
            siteNodeVersion.setVersionModifier(infoGluePrincipal.getName());
            siteNodeVersion.setVersionNumber(new Integer(1));
            db.create((Object)siteNodeVersion);
            ArrayList<SiteNodeVersionImpl> siteNodeVersions = new ArrayList<SiteNodeVersionImpl>();
            siteNodeVersions.add(siteNodeVersion);
            siteNode.setSiteNodeVersions(siteNodeVersions);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        return siteNodeVersion;
    }

    public static SiteNodeVersion create(Integer siteNodeId, InfoGluePrincipal infoGluePrincipal, SiteNodeVersionVO siteNodeVersionVO) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNodeVersion siteNodeVersion = null;
        SiteNodeVersionController.beginTransaction(db);
        try {
            SiteNode siteNode = SiteNodeController.getController().getSiteNodeWithId(siteNodeId, db);
            siteNodeVersion = new SiteNodeVersionImpl();
            siteNodeVersion.setOwningSiteNode((SiteNodeImpl)siteNode);
            siteNodeVersion.setVersionModifier(infoGluePrincipal.getName());
            siteNodeVersion.setValueObject(siteNodeVersionVO);
            siteNodeVersion.setVersionNumber(new Integer(1));
            siteNodeVersion = (SiteNodeVersion)SiteNodeVersionController.createEntity(siteNodeVersion, db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        return siteNodeVersion;
    }

    public static SiteNodeVersion create(Integer siteNodeId, InfoGluePrincipal infoGluePrincipal, SiteNodeVersionVO siteNodeVersionVO, Database db) throws SystemException, Bug, Exception {
        SiteNodeVersionImpl siteNodeVersion = null;
        SiteNode siteNode = SiteNodeController.getController().getSiteNodeWithId(siteNodeId, db);
        siteNodeVersion = new SiteNodeVersionImpl();
        siteNodeVersion.setOwningSiteNode((SiteNodeImpl)siteNode);
        siteNodeVersion.setVersionModifier(infoGluePrincipal.getName());
        siteNodeVersion.setValueObject(siteNodeVersionVO);
        siteNodeVersion.setVersionNumber(new Integer(1));
        db.create((Object)siteNodeVersion);
        return siteNodeVersion;
    }

    public SiteNodeVersionVO getLatestActiveSiteNodeVersionVO(Integer siteNodeId) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNodeVersionVO siteNodeVersionVO = null;
        SiteNodeVersionController.beginTransaction(db);
        try {
            siteNodeVersionVO = this.getLatestActiveSiteNodeVersionVO(db, siteNodeId);
            SiteNodeVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            SiteNodeVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return siteNodeVersionVO;
    }

    public SiteNodeVersion getLatestActiveSiteNodeVersion(Database db, Integer siteNodeId) throws SystemException, Bug, Exception {
        SiteNodeVersion siteNodeVersion = null;
        OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.structure.impl.simple.SiteNodeVersionImpl cv WHERE cv.owningSiteNode.siteNodeId = $1 AND cv.isActive = $2 ORDER BY cv.siteNodeVersionId desc");
        oql.bind((Object)siteNodeId);
        oql.bind((Object)new Boolean(true));
        QueryResults results = oql.execute((short)0);
        if (results.hasMore()) {
            siteNodeVersion = (SiteNodeVersion)results.next();
        }
        results.close();
        oql.close();
        return siteNodeVersion;
    }

    public SiteNodeVersionVO getLatestActiveSiteNodeVersionVO(Database db, Integer siteNodeId) throws SystemException, Bug, Exception {
        SiteNodeVersionVO siteNodeVersionVO = null;
        SiteNodeVersion siteNodeVersion = null;
        OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.structure.impl.simple.SmallSiteNodeVersionImpl cv WHERE cv.siteNodeId = $1 AND cv.isActive = $2 ORDER BY cv.siteNodeVersionId desc");
        oql.bind((Object)siteNodeId);
        oql.bind((Object)new Boolean(true));
        QueryResults results = oql.execute((short)0);
        if (results.hasMore()) {
            siteNodeVersion = (SiteNodeVersion)results.next();
        }
        results.close();
        oql.close();
        if (siteNodeVersion != null) {
            siteNodeVersionVO = siteNodeVersion.getValueObject();
        } else {
            logger.warn((Object)("The siteNode " + siteNodeId + " did not have a latest active siteNodeVersion - very strange."));
        }
        return siteNodeVersionVO;
    }

    public SiteNodeVersionVO getLatestSiteNodeVersionVO(Integer siteNodeId) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNodeVersionVO siteNodeVersionVO = null;
        SiteNodeVersionController.beginTransaction(db);
        try {
            OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.structure.impl.simple.SmallSiteNodeVersionImpl cv WHERE cv.siteNodeId = $1 ORDER BY cv.siteNodeVersionId desc");
            oql.bind((Object)siteNodeId);
            QueryResults results = oql.execute((short)0);
            if (results.hasMore()) {
                SiteNodeVersion siteNodeVersion = (SiteNodeVersion)results.next();
                logger.info((Object)("found one:" + siteNodeVersion.getValueObject()));
                siteNodeVersionVO = siteNodeVersion.getValueObject();
            }
            results.close();
            oql.close();
            SiteNodeVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            SiteNodeVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return siteNodeVersionVO;
    }

    public SiteNodeVersionVO getLatestSiteNodeVersionVO(Database db, Integer siteNodeId) throws SystemException, Bug, Exception {
        SiteNodeVersionVO siteNodeVersionVO = null;
        OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.structure.impl.simple.SmallSiteNodeVersionImpl cv WHERE cv.siteNodeId = $1 ORDER BY cv.siteNodeVersionId desc");
        oql.bind((Object)siteNodeId);
        QueryResults results = oql.execute((short)0);
        if (results.hasMore()) {
            SiteNodeVersion siteNodeVersion = (SiteNodeVersion)results.next();
            logger.info((Object)("found one:" + siteNodeVersion.getValueObject()));
            siteNodeVersionVO = siteNodeVersion.getValueObject();
        }
        results.close();
        oql.close();
        return siteNodeVersionVO;
    }

    public SiteNodeVersion getLatestSiteNodeVersion(Database db, Integer siteNodeId, boolean readOnly) throws SystemException, Bug {
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNodeVersion siteNodeVersion = null;
        try {
            OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.structure.impl.simple.SiteNodeVersionImpl cv WHERE cv.owningSiteNode.siteNodeId = $1 ORDER BY cv.siteNodeVersionId desc");
            oql.bind((Object)siteNodeId);
            QueryResults results = null;
            if (readOnly) {
                results = oql.execute((short)0);
            } else {
                logger.info((Object)"Fetching entity in read/write mode");
                results = oql.execute();
            }
            if (results.hasMore()) {
                siteNodeVersion = (SiteNodeVersion)results.next();
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        return siteNodeVersion;
    }

    public SiteNodeVersionVO updateStateId(Integer siteNodeVersionId, Integer stateId, String versionComment, InfoGluePrincipal infoGluePrincipal, Integer siteNodeId) throws ConstraintException, SystemException {
        SiteNodeVersionVO siteNodeVersionVO = this.getSiteNodeVersionVOWithId(siteNodeVersionId);
        SiteNodeVersionVO returnVO = null;
        if (stateId == 2) {
            siteNodeVersionVO.setStateId(stateId);
            siteNodeVersionVO.setVersionComment(versionComment);
            returnVO = (SiteNodeVersionVO)SiteNodeVersionController.updateEntity(SiteNodeVersionImpl.class, siteNodeVersionVO);
        }
        if (stateId == 0) {
            siteNodeVersionVO.setStateId(stateId);
            siteNodeVersionVO.setVersionComment("");
            SiteNodeVersionController.create(siteNodeId, infoGluePrincipal, siteNodeVersionVO);
            returnVO = this.getLatestSiteNodeVersionVO(siteNodeId);
        }
        return returnVO;
    }

    public SiteNodeVersionVO updateStateId(Integer siteNodeVersionId, Integer stateId, String versionComment, InfoGluePrincipal infoGluePrincipal, Integer siteNodeId, Database db) throws ConstraintException, SystemException, Exception {
        SiteNodeVersionVO siteNodeVersionVO = this.getSiteNodeVersionWithId(siteNodeVersionId, db).getValueObject();
        SiteNodeVersionVO returnVO = null;
        if (stateId == 2) {
            siteNodeVersionVO.setStateId(stateId);
            siteNodeVersionVO.setVersionComment(versionComment);
            returnVO = (SiteNodeVersionVO)SiteNodeVersionController.updateEntity(SiteNodeVersionImpl.class, siteNodeVersionVO, db);
        }
        if (stateId == 0) {
            siteNodeVersionVO.setStateId(stateId);
            siteNodeVersionVO.setVersionComment("");
            returnVO = SiteNodeVersionController.create(siteNodeId, infoGluePrincipal, siteNodeVersionVO, db).getValueObject();
        }
        return returnVO;
    }

    public static void deleteVersionsForSiteNodeWithId(Integer siteNodeId) throws ConstraintException, SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNodeVersionController.beginTransaction(db);
        ArrayList<SiteNodeVersionVO> siteNodeVersions = new ArrayList<SiteNodeVersionVO>();
        try {
            OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.structure.impl.simple.SiteNodeVersionImpl cv WHERE cv.owningSiteNode.siteNodeId = $1");
            oql.bind((Object)siteNodeId);
            QueryResults results = oql.execute((short)0);
            while (results.hasMore()) {
                SiteNodeVersion siteNodeVersion = (SiteNodeVersion)results.next();
                siteNodeVersions.add(siteNodeVersion.getValueObject());
            }
            results.close();
            oql.close();
            SiteNodeVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            SiteNodeVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        for (SiteNodeVersionVO siteNodeVersionVO : siteNodeVersions) {
            SiteNodeVersionController.delete(siteNodeVersionVO);
        }
    }

    public static void deleteVersionsForSiteNode(SiteNode siteNode, Database db, InfoGluePrincipal infoGluePrincipal) throws ConstraintException, SystemException, Bug, Exception {
        Collection siteNodeVersions = Collections.synchronizedCollection(siteNode.getSiteNodeVersions());
        Iterator siteNodeVersionIterator = siteNodeVersions.iterator();
        boolean metaInfoContentDeleted = false;
        while (siteNodeVersionIterator.hasNext()) {
            SiteNodeVersion siteNodeVersion = (SiteNodeVersion)siteNodeVersionIterator.next();
            Collection serviceBindings = Collections.synchronizedCollection(siteNodeVersion.getServiceBindings());
            Iterator serviceBindingIterator = serviceBindings.iterator();
            while (serviceBindingIterator.hasNext()) {
                ServiceBinding serviceBinding = (ServiceBinding)serviceBindingIterator.next();
                if (serviceBinding.getAvailableServiceBinding().getName().equalsIgnoreCase("Meta information")) {
                    if (!metaInfoContentDeleted) {
                        try {
                            SiteNodeVersionController.deleteMetaInfoForSiteNodeVersion(db, serviceBinding, infoGluePrincipal);
                        }
                        catch (Exception e) {
                            logger.error((Object)"An error was thrown when we tried to delete the meta info for the version. Could be deleted allready");
                        }
                        metaInfoContentDeleted = true;
                    }
                    serviceBindingIterator.remove();
                    db.remove((Object)serviceBinding);
                    continue;
                }
                serviceBindingIterator.remove();
                db.remove((Object)serviceBinding);
            }
            logger.info((Object)("Deleting siteNodeVersion:" + siteNodeVersion.getSiteNodeVersionId()));
            siteNodeVersionIterator.remove();
            db.remove((Object)siteNodeVersion);
        }
    }

    private static void deleteMetaInfoForSiteNodeVersion(Database db, ServiceBinding serviceBinding, InfoGluePrincipal infoGluePrincipal) throws ConstraintException, SystemException, Bug, Exception {
        List boundContents = ContentController.getBoundContents(db, serviceBinding.getId());
        if (boundContents.size() > 0) {
            ContentVO contentVO = (ContentVO)boundContents.get(0);
            ContentController.getContentController().delete(contentVO, db, true, true, true, infoGluePrincipal);
        }
    }

    public static List getServiceBindningVOList(Integer siteNodeVersionId) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        List serviceBindningVOList = null;
        SiteNodeVersionController.beginTransaction(db);
        try {
            Collection serviceBindningList = SiteNodeVersionController.getServiceBindningList(siteNodeVersionId, db, true);
            serviceBindningVOList = SiteNodeVersionController.toVOList(serviceBindningList);
            ceb.throwIfNotEmpty();
            SiteNodeVersionController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            SiteNodeVersionController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            SiteNodeVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return serviceBindningVOList;
    }

    public static List getServiceBindningVOList(Integer siteNodeVersionId, Database db) throws ConstraintException, SystemException, Exception {
        List serviceBindningVOList = null;
        Collection serviceBindningList = SiteNodeVersionController.getServiceBindningList(siteNodeVersionId, db, true);
        serviceBindningVOList = SiteNodeVersionController.toVOList(serviceBindningList);
        return serviceBindningVOList;
    }

    public static Collection getServiceBindningList(Integer siteNodeVersionId, Database db, boolean readOnly) throws ConstraintException, SystemException, Exception {
        ArrayList<ServiceBinding> serviceBindings = new ArrayList<ServiceBinding>();
        OQLQuery oql = db.getOQLQuery("SELECT sb FROM org.infoglue.cms.entities.structure.impl.simple.ServiceBindingImpl sb WHERE sb.siteNodeVersion = $1 ORDER BY sb.serviceBindingId");
        oql.bind((Object)siteNodeVersionId);
        QueryResults results = null;
        results = readOnly ? oql.execute((short)0) : oql.execute();
        logger.info((Object)"Fetching entity in read/write mode");
        while (results.hasMore()) {
            serviceBindings.add((ServiceBinding)results.next());
        }
        results.close();
        oql.close();
        return serviceBindings;
    }

    public static SiteNodeVersion getLatestPublishedSiteNodeVersion(Integer siteNodeId) throws SystemException, Bug, Exception {
        SiteNodeVersion siteNodeVersion = null;
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNodeVersionController.beginTransaction(db);
        try {
            siteNodeVersion = SiteNodeVersionController.getLatestPublishedSiteNodeVersion(siteNodeId, db);
            SiteNodeVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            SiteNodeVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return siteNodeVersion;
    }

    public static SiteNodeVersion getLatestPublishedSiteNodeVersion(Integer siteNodeId, Database db) throws SystemException, Bug, Exception {
        SiteNodeVersion siteNodeVersion = null;
        OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.structure.impl.simple.SiteNodeVersionImpl cv WHERE cv.owningSiteNode.siteNodeId = $1  AND cv.stateId = $2 AND cv.isActive = $3 ORDER BY cv.siteNodeVersionId desc");
        oql.bind((Object)siteNodeId);
        oql.bind((Object)SiteNodeVersionVO.PUBLISHED_STATE);
        oql.bind(true);
        QueryResults results = oql.execute();
        logger.info((Object)"Fetching entity in read/write mode");
        if (results.hasMore()) {
            siteNodeVersion = (SiteNodeVersion)results.next();
        }
        results.close();
        oql.close();
        return siteNodeVersion;
    }

    public static SiteNodeVersionVO getLatestPublishedSiteNodeVersionVO(Integer siteNodeId) throws SystemException, Bug, Exception {
        SiteNodeVersionVO siteNodeVersion = null;
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNodeVersionController.beginTransaction(db);
        try {
            siteNodeVersion = SiteNodeVersionController.getLatestPublishedSiteNodeVersionVO(siteNodeId, db);
            SiteNodeVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            SiteNodeVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return siteNodeVersion;
    }

    public static SiteNodeVersionVO getLatestPublishedSiteNodeVersionVO(Integer siteNodeId, Database db) throws SystemException, Bug, Exception {
        SiteNodeVersion siteNodeVersion = null;
        OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.structure.impl.simple.SmallSiteNodeVersionImpl cv WHERE cv.siteNodeId = $1 AND cv.stateId = $2 AND cv.isActive = $3 ORDER BY cv.siteNodeVersionId desc");
        oql.bind((Object)siteNodeId);
        oql.bind((Object)SiteNodeVersionVO.PUBLISHED_STATE);
        oql.bind(true);
        QueryResults results = oql.execute((short)0);
        if (results.hasMore()) {
            siteNodeVersion = (SiteNodeVersion)results.next();
        }
        results.close();
        oql.close();
        if (siteNodeVersion != null) {
            return siteNodeVersion.getValueObject();
        }
        return null;
    }

    public static SiteNodeVersionVO getPreviousSiteNodeVersionVO(Integer siteNodeId, Integer siteNodeVersionId) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNodeVersionVO siteNodeVersionVO = null;
        SiteNodeVersionController.beginTransaction(db);
        try {
            OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.structure.impl.simple.SmallSiteNodeVersionImpl cv WHERE cv.siteNodeId = $1 AND cv.siteNodeVersionId < $2 ORDER BY cv.siteNodeVersionId desc");
            oql.bind((Object)siteNodeId);
            oql.bind((Object)siteNodeVersionId);
            QueryResults results = oql.execute((short)0);
            if (results.hasMore()) {
                SiteNodeVersion siteNodeVersion = (SiteNodeVersion)results.next();
                logger.info((Object)("found one:" + siteNodeVersion.getValueObject()));
                siteNodeVersionVO = siteNodeVersion.getValueObject();
            }
            results.close();
            oql.close();
            SiteNodeVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            SiteNodeVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return siteNodeVersionVO;
    }

    public SiteNodeVersionVO getPreviousActiveSiteNodeVersionVO(Integer siteNodeId, Integer siteNodeVersionId, Database db) throws SystemException, Bug, Exception {
        SiteNodeVersionVO siteNodeVersionVO = null;
        OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.structure.impl.simple.SmallSiteNodeVersionImpl cv WHERE cv.siteNodeId = $1 AND cv.isActive = $2 AND cv.siteNodeVersionId < $3 ORDER BY cv.siteNodeVersionId desc");
        oql.bind((Object)siteNodeId);
        oql.bind((Object)new Boolean(true));
        oql.bind((Object)siteNodeVersionId);
        QueryResults results = oql.execute((short)0);
        if (results.hasMore()) {
            SiteNodeVersion siteNodeVersion = (SiteNodeVersion)results.next();
            logger.info((Object)("found one:" + siteNodeVersion.getValueObject()));
            siteNodeVersionVO = siteNodeVersion.getValueObject();
        }
        results.close();
        oql.close();
        return siteNodeVersionVO;
    }

    public SiteNodeVersion getPreviousActiveSiteNodeVersion(Integer siteNodeId, Integer siteNodeVersionId, Database db) throws SystemException, Bug, Exception {
        SiteNodeVersion siteNodeVersion = null;
        OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.structure.impl.simple.SiteNodeVersionImpl cv WHERE cv.owningSiteNode.siteNodeId = $1 AND cv.isActive = $2 AND cv.siteNodeVersionId < $3 ORDER BY cv.siteNodeVersionId desc");
        oql.bind((Object)siteNodeId);
        oql.bind((Object)new Boolean(true));
        oql.bind((Object)siteNodeVersionId);
        QueryResults results = oql.execute((short)0);
        if (results.hasMore()) {
            siteNodeVersion = (SiteNodeVersion)results.next();
            logger.info((Object)("found one:" + siteNodeVersion.getValueObject()));
        }
        results.close();
        oql.close();
        return siteNodeVersion;
    }

    public List getSiteNodeVersionVOWithParentRecursive(Integer siteNodeId, Integer stateId) throws ConstraintException, SystemException {
        return this.getSiteNodeVersionVOWithParentRecursive(siteNodeId, stateId, new ArrayList());
    }

    private List getSiteNodeVersionVOWithParentRecursive(Integer siteNodeId, Integer stateId, List resultList) throws ConstraintException, SystemException {
        SiteNodeVersionVO siteNodeVersionVO = this.getLatestSiteNodeVersionVO(siteNodeId);
        if (siteNodeVersionVO.getStateId().intValue() == stateId.intValue()) {
            resultList.add(siteNodeVersionVO);
        }
        List childSiteNodeList = SiteNodeController.getController().getSiteNodeChildren(siteNodeId);
        for (SiteNodeVO siteNodeVO : childSiteNodeList) {
            this.getSiteNodeVersionVOWithParentRecursive(siteNodeVO.getId(), stateId, resultList);
        }
        return resultList;
    }

    public List getPublishedSiteNodeVersionVOWithParentRecursive(Integer siteNodeId) throws ConstraintException, SystemException {
        List publishedSiteNodeVersionVOList = new ArrayList();
        Database db = CastorDatabaseService.getDatabase();
        SiteNodeVersionController.beginTransaction(db);
        try {
            SiteNode siteNode = SiteNodeController.getController().getSiteNodeWithId(siteNodeId, db);
            ArrayList publishedSiteNodeVersions = new ArrayList();
            this.getPublishedSiteNodeVersionWithParentRecursive(siteNode, publishedSiteNodeVersions, db);
            publishedSiteNodeVersionVOList = SiteNodeVersionController.toVOList(publishedSiteNodeVersions);
            SiteNodeVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            SiteNodeVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return publishedSiteNodeVersionVOList;
    }

    private List getPublishedSiteNodeVersionWithParentRecursive(SiteNode siteNode, List resultList, Database db) throws ConstraintException, SystemException, Exception {
        SiteNodeVersion siteNodeVersion = SiteNodeVersionController.getLatestPublishedSiteNodeVersion(siteNode.getId(), db);
        if (siteNodeVersion != null) {
            resultList.add(siteNodeVersion);
        }
        Collection childSiteNodeList = siteNode.getChildSiteNodes();
        for (SiteNode childSiteNode : childSiteNodeList) {
            this.getPublishedSiteNodeVersionWithParentRecursive(childSiteNode, resultList, db);
        }
        return resultList;
    }

    public void getSiteNodeAndAffectedItemsRecursive(Integer siteNodeId, Integer stateId, Set siteNodeVersionVOList, Set contenteVersionVOList, boolean includeMetaInfo, InfoGluePrincipal principal) throws ConstraintException, SystemException {
        this.getSiteNodeAndAffectedItemsRecursive(siteNodeId, stateId, siteNodeVersionVOList, contenteVersionVOList, includeMetaInfo, true, principal);
    }

    public void getSiteNodeAndAffectedItemsRecursive(Integer siteNodeId, Integer stateId, Set siteNodeVersionVOList, Set contenteVersionVOList, boolean includeMetaInfo, boolean recurseSiteNodes, InfoGluePrincipal principal) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        SiteNodeVersionController.beginTransaction(db);
        try {
            SiteNode siteNode = SiteNodeController.getController().getSiteNodeWithId(siteNodeId, db);
            this.getSiteNodeAndAffectedItemsRecursive(siteNode, stateId, new ArrayList(), new ArrayList(), db, siteNodeVersionVOList, contenteVersionVOList, includeMetaInfo, recurseSiteNodes, principal);
            SiteNodeVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            SiteNodeVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    private void getSiteNodeAndAffectedItemsRecursive(SiteNode siteNode, Integer stateId, List checkedSiteNodes, List checkedContents, Database db, Set siteNodeVersionVOList, Set contentVersionVOList, boolean includeMetaInfo, InfoGluePrincipal principal) throws ConstraintException, SystemException, Exception {
        this.getSiteNodeAndAffectedItemsRecursive(siteNode, stateId, checkedSiteNodes, checkedContents, db, siteNodeVersionVOList, contentVersionVOList, includeMetaInfo, true, principal);
    }

    private void getSiteNodeAndAffectedItemsRecursive(SiteNode siteNode, Integer stateId, List checkedSiteNodes, List checkedContents, Database db, Set siteNodeVersionVOList, Set contentVersionVOList, boolean includeMetaInfo, boolean recurseSiteNodes, InfoGluePrincipal principal) throws ConstraintException, SystemException, Exception {
        checkedSiteNodes.add(siteNode.getId());
        SiteNodeVersion siteNodeVersion = this.getLatestActiveSiteNodeVersion(db, siteNode.getId());
        if (siteNodeVersion != null && siteNodeVersion.getStateId().intValue() == stateId.intValue()) {
            siteNodeVersionVOList.add(siteNodeVersion.getValueObject());
        }
        List relatedEntities = RegistryController.getController().getMatchingRegistryVOListForReferencingEntity(SiteNodeVersion.class.getName(), siteNodeVersion.getId().toString(), db);
        for (RegistryVO registryVO : relatedEntities) {
            if (registryVO.getEntityName().equals(SiteNode.class.getName()) && !checkedSiteNodes.contains(new Integer(registryVO.getEntityId()))) {
                try {
                    Integer protectedSiteNodeVersionId;
                    boolean allowedSiteNodeVersion;
                    SiteNodeController.getController();
                    SiteNodeVO relatedSiteNodeVO = SiteNodeController.getSiteNodeVOWithId(new Integer(registryVO.getEntityId()), db);
                    SiteNodeVersion relatedSiteNodeVersion = this.getLatestActiveSiteNodeVersion(db, new Integer(registryVO.getEntityId()));
                    Integer repositoryId = relatedSiteNodeVO.getRepositoryId();
                    Integer siteNodeRepositoryId = siteNode.getRepository().getId();
                    boolean bl = allowedSiteNodeVersion = repositoryId.intValue() == siteNodeRepositoryId.intValue();
                    if (CmsPropertyHandler.getAllowCrossSiteSubmitToPublish().equalsIgnoreCase("true") && AccessRightController.getController().getIsPrincipalAuthorized(db, principal, "Repository.Read", "" + repositoryId) && ((protectedSiteNodeVersionId = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getProtectedSiteNodeVersionId(relatedSiteNodeVersion.getId(), db)) == null || AccessRightController.getController().getIsPrincipalAuthorized(principal, "SiteNodeVersion.SubmitToPublish", protectedSiteNodeVersionId.toString()))) {
                        allowedSiteNodeVersion = true;
                    }
                    if (relatedSiteNodeVersion != null && allowedSiteNodeVersion && relatedSiteNodeVersion.getStateId().intValue() == stateId.intValue()) {
                        siteNodeVersionVOList.add(relatedSiteNodeVersion.getValueObject());
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("A siteNode referenced by ID:" + registryVO.getEntityId() + " was not found - must be a invalid reference from " + siteNode.getName() + "[" + siteNode.getId() + "]."), (Throwable)e);
                }
                checkedSiteNodes.add(new Integer(registryVO.getEntityId()));
                continue;
            }
            if (!registryVO.getEntityName().equals(Content.class.getName()) || checkedContents.contains(new Integer(registryVO.getEntityId()))) continue;
            try {
                Content relatedContent = ContentController.getContentController().getContentWithId(new Integer(registryVO.getEntityId()), db);
                if (includeMetaInfo || !includeMetaInfo && (relatedContent.getContentTypeDefinition() == null || !relatedContent.getContentTypeDefinition().getName().equalsIgnoreCase("Meta info"))) {
                    Integer protectedContentId;
                    boolean allowedContent;
                    Integer repositoryId = relatedContent.getRepository().getId();
                    Integer siteNodeRepositoryId = siteNode.getRepository().getId();
                    boolean bl = allowedContent = repositoryId.intValue() == siteNodeRepositoryId.intValue();
                    if (CmsPropertyHandler.getAllowCrossSiteSubmitToPublish().equalsIgnoreCase("true") && AccessRightController.getController().getIsPrincipalAuthorized(db, principal, "Repository.Read", "" + repositoryId) && ((protectedContentId = ContentControllerProxy.getController().getProtectedContentId(relatedContent.getId(), db)) == null || AccessRightController.getController().getIsPrincipalAuthorized(db, principal, "Content.SubmitToPublish", protectedContentId.toString()))) {
                        allowedContent = true;
                    }
                    List relatedContentVersions = ContentVersionController.getContentVersionController().getLatestActiveContentVersionIfInState(relatedContent, stateId, db);
                    for (ContentVersion relatedContentVersion : relatedContentVersions) {
                        if (relatedContentVersion == null || !allowedContent) continue;
                        contentVersionVOList.add(relatedContentVersion.getValueObject());
                    }
                }
            }
            catch (Exception e) {
                logger.warn((Object)("A content referenced by ID:" + registryVO.getEntityId() + " was not found - must be a invalid reference from " + siteNode.getName() + "[" + siteNode.getId() + "]."), (Throwable)e);
            }
            checkedContents.add(new Integer(registryVO.getEntityId()));
        }
        if (recurseSiteNodes) {
            Collection childSiteNodeList = siteNode.getChildSiteNodes();
            for (SiteNode childSiteNode : childSiteNodeList) {
                this.getSiteNodeAndAffectedItemsRecursive(childSiteNode, stateId, checkedSiteNodes, checkedContents, db, siteNodeVersionVOList, contentVersionVOList, includeMetaInfo, principal);
            }
        }
    }

    public SiteNodeVersion getLatestActiveSiteNodeVersionIfInState(SiteNode siteNode, Integer stateId, Database db) throws SystemException, Exception {
        SiteNodeVersion siteNodeVersion = null;
        Collection siteNodeVersions = siteNode.getSiteNodeVersions();
        IBaseEntity latestSiteNodeVersion = null;
        for (SiteNodeVersion siteNodeVersionCandidate : siteNodeVersions) {
            if (latestSiteNodeVersion == null || latestSiteNodeVersion.getId() < siteNodeVersionCandidate.getId() && siteNodeVersionCandidate.getIsActive().booleanValue()) {
                latestSiteNodeVersion = siteNodeVersionCandidate;
            }
            if (!siteNodeVersionCandidate.getIsActive().booleanValue() || siteNodeVersionCandidate.getStateId().intValue() != stateId.intValue() || siteNodeVersionCandidate.getOwningSiteNode().getSiteNodeId().intValue() != siteNode.getId().intValue() || siteNodeVersion != null && siteNodeVersion.getSiteNodeVersionId() >= siteNodeVersionCandidate.getId()) continue;
            siteNodeVersion = siteNodeVersionCandidate;
        }
        if (siteNodeVersion != latestSiteNodeVersion) {
            siteNodeVersion = null;
        }
        return siteNodeVersion;
    }

    public List getMetaInfoContentVersionVOList(Integer siteNodeVersionId, InfoGluePrincipal infoGluePrincipal) throws ConstraintException, SystemException, Exception {
        List contentVersionVOList = new ArrayList();
        Database db = CastorDatabaseService.getDatabase();
        SiteNodeVersionController.beginTransaction(db);
        try {
            SiteNodeVersion siteNodeVersion = SiteNodeVersionController.getController().getSiteNodeVersionWithId(siteNodeVersionId, db);
            List contentVersions = this.getMetaInfoContentVersions(db, siteNodeVersion, infoGluePrincipal);
            contentVersionVOList = SiteNodeVersionController.toVOList(contentVersions);
            SiteNodeVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            SiteNodeVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contentVersionVOList;
    }

    private List getMetaInfoContentVersions(Database db, SiteNodeVersion siteNodeVersion, InfoGluePrincipal infoGluePrincipal) throws ConstraintException, SystemException, Exception {
        List boundContents;
        ArrayList<ContentVersion> contentVersions = new ArrayList<ContentVersion>();
        List languages = LanguageController.getController().getLanguageList(siteNodeVersion.getOwningSiteNode().getRepository().getId(), db);
        Language masterLanguage = LanguageController.getController().getMasterLanguage(db, siteNodeVersion.getOwningSiteNode().getRepository().getId());
        Integer metaInfoAvailableServiceBindingId = null;
        Integer serviceBindingId = null;
        AvailableServiceBindingVO availableServiceBindingVO = AvailableServiceBindingController.getController().getAvailableServiceBindingVOWithName("Meta information", db);
        if (availableServiceBindingVO != null) {
            metaInfoAvailableServiceBindingId = availableServiceBindingVO.getAvailableServiceBindingId();
        }
        Collection serviceBindings = siteNodeVersion.getServiceBindings();
        for (ServiceBinding serviceBinding : serviceBindings) {
            if (serviceBinding.getAvailableServiceBinding().getId().intValue() != metaInfoAvailableServiceBindingId.intValue()) continue;
            serviceBindingId = serviceBinding.getId();
            break;
        }
        if (serviceBindingId != null && (boundContents = ContentController.getBoundContents(serviceBindingId)).size() > 0) {
            ContentVO contentVO = (ContentVO)boundContents.get(0);
            for (Language language : languages) {
                ContentVersion contentVersion = ContentVersionController.getContentVersionController().getLatestActiveContentVersion(contentVO.getId(), language.getId(), db);
                if (contentVersion == null) continue;
                contentVersions.add(contentVersion);
            }
        }
        return contentVersions;
    }

    public SiteNodeVersionVO update(SiteNodeVersionVO siteNodeVersionVO) throws ConstraintException, SystemException {
        this.registryController.updateSiteNodeVersion(siteNodeVersionVO);
        return (SiteNodeVersionVO)SiteNodeVersionController.updateEntity(SiteNodeVersionImpl.class, siteNodeVersionVO);
    }

    public SiteNodeVersionVO update(SiteNodeVersionVO siteNodeVersionVO, Database db) throws ConstraintException, SystemException, Exception {
        SiteNodeVersion siteNodeVersion = this.getSiteNodeVersionWithId(siteNodeVersionVO.getId(), db);
        this.registryController.updateSiteNodeVersion(siteNodeVersion, db);
        siteNodeVersion.setValueObject(siteNodeVersionVO);
        return siteNodeVersionVO;
    }

    public List getPublishedActiveSiteNodeVersionVOList(Integer siteNodeId) throws SystemException, Bug, Exception {
        List siteNodeVersionVOList = new ArrayList();
        Database db = CastorDatabaseService.getDatabase();
        SiteNodeVersionController.beginTransaction(db);
        try {
            List siteNodeVersionList = this.getPublishedActiveSiteNodeVersionVOList(siteNodeId, db);
            siteNodeVersionVOList = SiteNodeVersionController.toVOList(siteNodeVersionList);
            SiteNodeVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            SiteNodeVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return siteNodeVersionVOList;
    }

    public List getPublishedActiveFullSiteNodeVersionVOList(Integer siteNodeId) throws SystemException, Bug, Exception {
        List siteNodeVersionVOList = new ArrayList();
        Database db = CastorDatabaseService.getDatabase();
        SiteNodeVersionController.beginTransaction(db);
        try {
            List siteNodeVersionList = this.getPublishedActiveFullSiteNodeVersionVOList(siteNodeId, db);
            siteNodeVersionVOList = SiteNodeVersionController.toVOList(siteNodeVersionList);
            SiteNodeVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            SiteNodeVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return siteNodeVersionVOList;
    }

    public List getPublishedActiveSiteNodeVersionVOList(Integer siteNodeId, Database db) throws SystemException, Bug, Exception {
        ArrayList<SiteNodeVersion> siteNodeVersionList = new ArrayList<SiteNodeVersion>();
        OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.structure.impl.simple.SmallSiteNodeVersionImpl cv WHERE cv.siteNodeId = $1  AND cv.stateId = $2 AND cv.isActive = $3 ORDER BY cv.siteNodeVersionId desc");
        oql.bind((Object)siteNodeId);
        oql.bind((Object)SiteNodeVersionVO.PUBLISHED_STATE);
        oql.bind(true);
        QueryResults results = oql.execute((short)0);
        while (results.hasMore()) {
            SiteNodeVersion siteNodeVersion = (SiteNodeVersion)results.next();
            siteNodeVersionList.add(siteNodeVersion);
        }
        results.close();
        oql.close();
        return siteNodeVersionList;
    }

    public List getPublishedActiveFullSiteNodeVersionVOList(Integer siteNodeId, Database db) throws SystemException, Bug, Exception {
        ArrayList<SiteNodeVersion> siteNodeVersionList = new ArrayList<SiteNodeVersion>();
        OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.structure.impl.simple.SiteNodeVersionImpl cv WHERE cv.owningSiteNode.siteNodeId = $1  AND cv.stateId = $2 AND cv.isActive = $3 ORDER BY cv.siteNodeVersionId desc");
        oql.bind((Object)siteNodeId);
        oql.bind((Object)SiteNodeVersionVO.PUBLISHED_STATE);
        oql.bind(true);
        QueryResults results = oql.execute((short)0);
        while (results.hasMore()) {
            SiteNodeVersion siteNodeVersion = (SiteNodeVersion)results.next();
            siteNodeVersionList.add(siteNodeVersion);
        }
        results.close();
        oql.close();
        return siteNodeVersionList;
    }

    public BaseEntityVO getNewVO() {
        return new SiteNodeVersionVO();
    }
}

