/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.AvailableServiceBindingController;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentStateController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.EventController;
import org.infoglue.cms.controllers.kernel.impl.simple.InterceptionPointController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.PublicationController;
import org.infoglue.cms.controllers.kernel.impl.simple.RegistryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ServiceBindingController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.AccessRight;
import org.infoglue.cms.entities.management.AccessRightGroup;
import org.infoglue.cms.entities.management.AccessRightGroupVO;
import org.infoglue.cms.entities.management.AccessRightRole;
import org.infoglue.cms.entities.management.AccessRightRoleVO;
import org.infoglue.cms.entities.management.AccessRightUser;
import org.infoglue.cms.entities.management.AccessRightUserVO;
import org.infoglue.cms.entities.management.AccessRightVO;
import org.infoglue.cms.entities.management.AvailableServiceBindingVO;
import org.infoglue.cms.entities.management.InterceptionPoint;
import org.infoglue.cms.entities.management.Language;
import org.infoglue.cms.entities.structure.Qualifyer;
import org.infoglue.cms.entities.structure.QualifyerVO;
import org.infoglue.cms.entities.structure.ServiceBinding;
import org.infoglue.cms.entities.structure.ServiceBindingVO;
import org.infoglue.cms.entities.structure.SiteNodeVersion;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.entities.structure.impl.simple.QualifyerImpl;
import org.infoglue.cms.entities.structure.impl.simple.ServiceBindingImpl;
import org.infoglue.cms.entities.workflow.EventVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.DateHelper;

public class SiteNodeStateController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)SiteNodeStateController.class.getName());

    public static SiteNodeStateController getController() {
        return new SiteNodeStateController();
    }

    public SiteNodeVersion changeState(Integer oldSiteNodeVersionId, Integer stateId, String versionComment, boolean overrideVersionModifyer, InfoGluePrincipal infoGluePrincipal, Integer siteNodeId, List resultingEvents) throws ConstraintException, SystemException {
        return this.changeState(oldSiteNodeVersionId, stateId, versionComment, overrideVersionModifyer, null, infoGluePrincipal, siteNodeId, resultingEvents);
    }

    public SiteNodeVersion changeState(Integer oldSiteNodeVersionId, Integer stateId, String versionComment, boolean overrideVersionModifyer, String recipientFilter, InfoGluePrincipal infoGluePrincipal, Integer siteNodeId, List resultingEvents) throws ConstraintException, SystemException {
        SiteNodeVersion newSiteNodeVersion = null;
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNodeStateController.beginTransaction(db);
        try {
            SiteNodeVersion siteNodeVersion = SiteNodeVersionController.getSiteNodeVersionWithIdAsReadOnly(oldSiteNodeVersionId, db);
            logger.info((Object)("siteNodeVersion:" + siteNodeVersion.getId() + ":" + siteNodeVersion.getStateId()));
            newSiteNodeVersion = this.changeState(oldSiteNodeVersionId, stateId, versionComment, overrideVersionModifyer, recipientFilter, infoGluePrincipal, siteNodeId, db, resultingEvents);
            SiteNodeStateController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            SiteNodeStateController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return newSiteNodeVersion;
    }

    public SiteNodeVersion changeState(Integer oldSiteNodeVersionId, Integer stateId, String versionComment, boolean overrideVersionModifyer, InfoGluePrincipal infoGluePrincipal, Integer siteNodeId, Database db, List resultingEvents) throws ConstraintException, SystemException {
        return this.changeState(oldSiteNodeVersionId, stateId, versionComment, overrideVersionModifyer, null, infoGluePrincipal, siteNodeId, db, resultingEvents);
    }

    public SiteNodeVersion changeState(Integer oldSiteNodeVersionId, Integer stateId, String versionComment, boolean overrideVersionModifyer, String recipientFilter, InfoGluePrincipal infoGluePrincipal, Integer siteNodeId, Database db, List resultingEvents) throws ConstraintException, SystemException {
        SiteNodeVersion newSiteNodeVersion = null;
        try {
            SiteNodeVersion oldSiteNodeVersion = SiteNodeVersionController.getController().getSiteNodeVersionWithId(oldSiteNodeVersionId, db);
            if (stateId.intValue() == SiteNodeVersionVO.WORKING_STATE.intValue()) {
                logger.info((Object)"About to create a new working version");
                if (siteNodeId == null) {
                    siteNodeId = new Integer(oldSiteNodeVersion.getOwningSiteNode().getId());
                }
                SiteNodeVersionVO newSiteNodeVersionVO = new SiteNodeVersionVO();
                newSiteNodeVersionVO.setStateId(stateId);
                newSiteNodeVersionVO.setVersionComment("New working version");
                newSiteNodeVersionVO.setModifiedDateTime(DateHelper.getSecondPreciseDate());
                if (overrideVersionModifyer) {
                    newSiteNodeVersionVO.setVersionModifier(infoGluePrincipal.getName());
                } else {
                    newSiteNodeVersionVO.setVersionModifier(oldSiteNodeVersion.getVersionModifier());
                }
                newSiteNodeVersionVO.setContentType(oldSiteNodeVersion.getContentType());
                newSiteNodeVersionVO.setPageCacheKey(oldSiteNodeVersion.getPageCacheKey());
                newSiteNodeVersionVO.setPageCacheTimeout(oldSiteNodeVersion.getPageCacheTimeout());
                newSiteNodeVersionVO.setDisableEditOnSight(oldSiteNodeVersion.getDisableEditOnSight());
                newSiteNodeVersionVO.setDisableLanguages(oldSiteNodeVersion.getDisableLanguages());
                newSiteNodeVersionVO.setDisablePageCache(oldSiteNodeVersion.getDisablePageCache());
                newSiteNodeVersionVO.setIsProtected(oldSiteNodeVersion.getIsProtected());
                newSiteNodeVersionVO.setDisableForceIdentityCheck(oldSiteNodeVersion.getDisableForceIdentityCheck());
                newSiteNodeVersion = SiteNodeVersionController.create(siteNodeId, infoGluePrincipal, newSiteNodeVersionVO, db);
                SiteNodeStateController.copyServiceBindings(oldSiteNodeVersion, newSiteNodeVersion, db);
                SiteNodeStateController.copyAccessRights(oldSiteNodeVersion, newSiteNodeVersion, db);
            }
            if (stateId.intValue() == SiteNodeVersionVO.PUBLISH_STATE.intValue()) {
                logger.info((Object)"About to copy the working copy to a publish-one");
                if (siteNodeId == null) {
                    siteNodeId = new Integer(oldSiteNodeVersion.getOwningSiteNode().getId());
                }
                SiteNodeVersionVO oldSiteNodeVersionVO = oldSiteNodeVersion.getValueObject();
                oldSiteNodeVersion.setVersionComment(versionComment);
                SiteNodeVersionVO newSiteNodeVersionVO = new SiteNodeVersionVO();
                newSiteNodeVersionVO.setStateId(stateId);
                newSiteNodeVersionVO.setVersionComment(versionComment);
                if (overrideVersionModifyer) {
                    newSiteNodeVersionVO.setVersionModifier(infoGluePrincipal.getName());
                } else {
                    newSiteNodeVersionVO.setVersionModifier(oldSiteNodeVersion.getVersionModifier());
                }
                newSiteNodeVersionVO.setModifiedDateTime(DateHelper.getSecondPreciseDate());
                newSiteNodeVersionVO.setContentType(oldSiteNodeVersion.getContentType());
                newSiteNodeVersionVO.setPageCacheKey(oldSiteNodeVersion.getPageCacheKey());
                newSiteNodeVersionVO.setPageCacheTimeout(oldSiteNodeVersion.getPageCacheTimeout());
                newSiteNodeVersionVO.setDisableEditOnSight(oldSiteNodeVersion.getDisableEditOnSight());
                newSiteNodeVersionVO.setDisableLanguages(oldSiteNodeVersion.getDisableLanguages());
                newSiteNodeVersionVO.setDisablePageCache(oldSiteNodeVersion.getDisablePageCache());
                newSiteNodeVersionVO.setIsProtected(oldSiteNodeVersion.getIsProtected());
                newSiteNodeVersionVO.setDisableForceIdentityCheck(oldSiteNodeVersion.getDisableForceIdentityCheck());
                newSiteNodeVersion = SiteNodeVersionController.create(siteNodeId, infoGluePrincipal, newSiteNodeVersionVO, db);
                SiteNodeStateController.copyServiceBindings(oldSiteNodeVersion, newSiteNodeVersion, db);
                SiteNodeStateController.copyAccessRights(oldSiteNodeVersion, newSiteNodeVersion, db);
                EventVO eventVO = new EventVO();
                eventVO.setDescription(newSiteNodeVersion.getVersionComment());
                eventVO.setEntityClass(SiteNodeVersion.class.getName());
                eventVO.setEntityId(new Integer(newSiteNodeVersion.getId()));
                eventVO.setName(newSiteNodeVersion.getOwningSiteNode().getName());
                eventVO.setTypeId(EventVO.PUBLISH);
                eventVO = EventController.create(eventVO, newSiteNodeVersion.getOwningSiteNode().getRepository().getId(), infoGluePrincipal, db);
                resultingEvents.add(eventVO);
                if (recipientFilter != null && !recipientFilter.equals("")) {
                    PublicationController.mailPublishNotification(resultingEvents, newSiteNodeVersion.getOwningSiteNode().getRepository().getId(), infoGluePrincipal, recipientFilter, db);
                }
            }
            if (stateId.intValue() == SiteNodeVersionVO.PUBLISHED_STATE.intValue()) {
                logger.info((Object)"About to publish an existing version");
                oldSiteNodeVersion.setStateId(stateId);
                oldSiteNodeVersion.setIsActive(new Boolean(true));
                newSiteNodeVersion = oldSiteNodeVersion;
            }
            this.changeStateOnMetaInfo(db, newSiteNodeVersion, stateId, versionComment, overrideVersionModifyer, infoGluePrincipal, resultingEvents);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        return newSiteNodeVersion;
    }

    public void changeStateOnMetaInfo(Database db, SiteNodeVersion siteNodeVersion, Integer stateId, String versionComment, boolean overrideVersionModifyer, InfoGluePrincipal infoGluePrincipal, List events) throws ConstraintException, SystemException, Exception {
        logger.info((Object)"start changeStateOnMetaInfo");
        List languages = LanguageController.getController().getLanguageList(siteNodeVersion.getOwningSiteNode().getRepository().getId(), db);
        Language masterLanguage = LanguageController.getController().getMasterLanguage(db, siteNodeVersion.getOwningSiteNode().getRepository().getId());
        logger.info((Object)"after languages");
        ContentVO contentVO = null;
        if (siteNodeVersion.getOwningSiteNode().getMetaInfoContentId() != null) {
            contentVO = ContentController.getContentController().getContentVOWithId(siteNodeVersion.getOwningSiteNode().getMetaInfoContentId(), db);
        } else {
            logger.warn((Object)"There was no metaInfoContentId on the siteNode... run validation to improve performance..");
            Integer metaInfoAvailableServiceBindingId = null;
            Integer serviceBindingId = null;
            AvailableServiceBindingVO availableServiceBindingVO = AvailableServiceBindingController.getController().getAvailableServiceBindingVOWithName("Meta information", db);
            if (availableServiceBindingVO != null) {
                metaInfoAvailableServiceBindingId = availableServiceBindingVO.getAvailableServiceBindingId();
            }
            logger.info((Object)"after loading service binding for meta info");
            Collection serviceBindings = siteNodeVersion.getServiceBindings();
            for (ServiceBinding serviceBinding : serviceBindings) {
                if (serviceBinding.getAvailableServiceBinding().getId().intValue() != metaInfoAvailableServiceBindingId.intValue()) continue;
                serviceBindingId = serviceBinding.getId();
                break;
            }
            if (serviceBindingId != null) {
                List boundContents = ContentController.getBoundContents(db, serviceBindingId);
                logger.info((Object)("boundContents:" + boundContents.size()));
                if (boundContents.size() > 0) {
                    contentVO = (ContentVO)boundContents.get(0);
                    logger.info((Object)("contentVO:" + contentVO.getId()));
                }
            }
        }
        if (contentVO != null) {
            for (Language language : languages) {
                ContentVersion contentVersion = ContentVersionController.getContentVersionController().getLatestActiveContentVersion(contentVO.getId(), language.getId(), db);
                logger.info((Object)("language:" + language.getId()));
                if (contentVersion != null) {
                    logger.info((Object)("contentVersion:" + contentVersion.getId() + ":" + contentVersion.getStateId()));
                    logger.info((Object)("State wanted:" + stateId));
                }
                if (contentVersion != null && contentVersion.getStateId().intValue() != stateId.intValue()) {
                    logger.info((Object)("State on current:" + contentVersion.getStateId()));
                    logger.info((Object)("changing state on contentVersion:" + contentVersion.getId()));
                    contentVersion = ContentStateController.changeState(contentVersion.getId(), stateId, versionComment, overrideVersionModifyer, null, infoGluePrincipal, contentVO.getId(), db, events);
                }
                if (!language.getId().equals(masterLanguage.getId()) || contentVersion == null) continue;
                RegistryController.getController().updateContentVersion(contentVersion, siteNodeVersion, db);
            }
        }
    }

    private static void copyServiceBindings(SiteNodeVersion originalSiteNodeVersion, SiteNodeVersion newSiteNodeVersion, Database db) throws ConstraintException, SystemException, Exception {
        Collection serviceBindings = originalSiteNodeVersion.getServiceBindings();
        for (ServiceBinding serviceBinding : serviceBindings) {
            ServiceBindingVO serviceBindingVO = serviceBinding.getValueObject();
            ServiceBindingVO newServiceBindingVO = new ServiceBindingVO();
            newServiceBindingVO.setBindingTypeId(serviceBindingVO.getBindingTypeId());
            newServiceBindingVO.setName(serviceBindingVO.getName());
            newServiceBindingVO.setPath(serviceBindingVO.getPath());
            ServiceBinding newServiceBinding = ServiceBindingController.create(newServiceBindingVO, serviceBinding.getAvailableServiceBinding().getAvailableServiceBindingId(), newSiteNodeVersion.getSiteNodeVersionId(), serviceBinding.getServiceDefinition().getServiceDefinitionId(), db);
            newSiteNodeVersion.getServiceBindings().add(newServiceBinding);
            SiteNodeStateController.copyQualifyers(serviceBinding, newServiceBinding, db);
        }
    }

    private static void copyQualifyers(ServiceBinding originalServiceBinding, ServiceBinding newServiceBinding, Database db) throws ConstraintException, SystemException, Exception {
        Collection qualifyers = originalServiceBinding.getBindingQualifyers();
        ArrayList<QualifyerImpl> newBindingQualifyers = new ArrayList<QualifyerImpl>();
        for (Qualifyer qualifyer : qualifyers) {
            QualifyerVO qualifyerVO = qualifyer.getValueObject();
            QualifyerImpl newQualifyer = new QualifyerImpl();
            newQualifyer.setValueObject(qualifyerVO);
            newQualifyer.setServiceBinding((ServiceBindingImpl)newServiceBinding);
            newBindingQualifyers.add(newQualifyer);
        }
        newServiceBinding.setBindingQualifyers(newBindingQualifyers);
    }

    private static void copyAccessRights(SiteNodeVersion originalSiteNodeVersion, SiteNodeVersion newSiteNodeVersion, Database db) throws ConstraintException, SystemException, Exception {
        List interceptionPointList = InterceptionPointController.getController().getInterceptionPointList("SiteNodeVersion", db);
        logger.info((Object)("interceptionPointList:" + interceptionPointList.size()));
        for (InterceptionPoint interceptionPoint : interceptionPointList) {
            List accessRightList = AccessRightController.getController().getAccessRightListForEntity(interceptionPoint.getId(), originalSiteNodeVersion.getId().toString(), db);
            logger.info((Object)("accessRightList:" + accessRightList.size()));
            for (AccessRight accessRight : accessRightList) {
                logger.info((Object)("accessRight:" + accessRight.getId()));
                AccessRightVO copiedAccessRight = accessRight.getValueObject().createCopy();
                copiedAccessRight.setParameters(newSiteNodeVersion.getId().toString());
                AccessRight newAccessRight = AccessRightController.getController().create(copiedAccessRight, interceptionPoint, db);
                for (AccessRightGroup accessRightGroup : accessRight.getGroups()) {
                    AccessRightGroupVO newAccessRightGroupVO = new AccessRightGroupVO();
                    newAccessRightGroupVO.setGroupName(accessRightGroup.getGroupName());
                    AccessRightGroup newAccessRightGroup = AccessRightController.getController().createAccessRightGroup(db, newAccessRightGroupVO, newAccessRight);
                    newAccessRight.getGroups().add(newAccessRightGroup);
                }
                for (AccessRightRole accessRightRole : accessRight.getRoles()) {
                    AccessRightRoleVO newAccessRightRoleVO = new AccessRightRoleVO();
                    newAccessRightRoleVO.setRoleName(accessRightRole.getRoleName());
                    AccessRightRole newAccessRightRole = AccessRightController.getController().createAccessRightRole(db, newAccessRightRoleVO, newAccessRight);
                    newAccessRight.getRoles().add(newAccessRightRole);
                }
                for (AccessRightUser accessRightUser : accessRight.getUsers()) {
                    AccessRightUserVO newAccessRightUserVO = new AccessRightUserVO();
                    newAccessRightUserVO.setUserName(accessRightUser.getUserName());
                    AccessRightUser newAccessRightUser = AccessRightController.getController().createAccessRightUser(db, newAccessRightUserVO, newAccessRight);
                    newAccessRight.getUsers().add(newAccessRightUser);
                }
            }
        }
    }

    public BaseEntityVO getNewVO() {
        return null;
    }
}

