/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xpath.XPathAPI;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.AvailableServiceBindingController;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ComponentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.RegistryController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ServiceBindingController;
import org.infoglue.cms.controllers.kernel.impl.simple.ServiceDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.impl.simple.ContentImpl;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.Language;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.Repository;
import org.infoglue.cms.entities.management.ServiceDefinition;
import org.infoglue.cms.entities.management.ServiceDefinitionVO;
import org.infoglue.cms.entities.management.SiteNodeTypeDefinition;
import org.infoglue.cms.entities.management.impl.simple.RepositoryImpl;
import org.infoglue.cms.entities.management.impl.simple.SiteNodeTypeDefinitionImpl;
import org.infoglue.cms.entities.structure.ServiceBindingVO;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.entities.structure.SiteNodeVersion;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.entities.structure.impl.simple.SiteNodeImpl;
import org.infoglue.cms.entities.structure.impl.simple.SmallSiteNodeImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteNodeController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)SiteNodeController.class.getName());
    protected static final Integer NO = new Integer(0);
    protected static final Integer YES = new Integer(1);
    protected static final Integer INHERITED = new Integer(2);

    public static SiteNodeController getController() {
        return new SiteNodeController();
    }

    public SiteNodeVO getSiteNodeVOWithId(Integer siteNodeId) throws SystemException, Bug {
        return (SiteNodeVO)SiteNodeController.getVOWithId(SiteNodeImpl.class, siteNodeId);
    }

    public static SiteNodeVO getSiteNodeVOWithId(Integer siteNodeId, Database db) throws SystemException, Bug {
        return (SiteNodeVO)SiteNodeController.getVOWithId(SiteNodeImpl.class, siteNodeId, db);
    }

    public static SiteNodeVO getSmallSiteNodeVOWithId(Integer siteNodeId, Database db) throws SystemException, Bug {
        return (SiteNodeVO)SiteNodeController.getVOWithId(SmallSiteNodeImpl.class, siteNodeId, db);
    }

    public SiteNode getSiteNodeWithId(Integer siteNodeId, Database db) throws SystemException, Bug {
        return SiteNodeController.getSiteNodeWithId(siteNodeId, db, false);
    }

    public static SiteNode getSiteNodeWithId(Integer siteNodeId, Database db, boolean readOnly) throws SystemException, Bug {
        SiteNode siteNode = null;
        try {
            if (readOnly) {
                siteNode = (SiteNode)db.load(SiteNodeImpl.class, (Object)siteNodeId, (short)0);
            } else {
                logger.info((Object)("Loading " + siteNodeId + " in read/write mode."));
                siteNode = (SiteNode)db.load(SiteNodeImpl.class, (Object)siteNodeId);
            }
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch the SiteNode. Reason:" + e.getMessage(), e);
        }
        if (siteNode == null) {
            throw new Bug("The SiteNode with id [" + siteNodeId + "] was not found in SiteNodeHelper.getSiteNodeWithId. This should never happen.");
        }
        return siteNode;
    }

    public void delete(SiteNodeVO siteNodeVO, InfoGluePrincipal infogluePrincipal) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        SiteNodeController.beginTransaction(db);
        try {
            this.delete(siteNodeVO, db, infogluePrincipal);
            SiteNodeController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            SiteNodeController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            SiteNodeController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void delete(SiteNodeVO siteNodeVO, Database db, InfoGluePrincipal infogluePrincipal) throws ConstraintException, SystemException, Exception {
        this.delete(siteNodeVO, db, false, infogluePrincipal);
    }

    public void delete(SiteNodeVO siteNodeVO, Database db, boolean forceDelete, InfoGluePrincipal infogluePrincipal) throws ConstraintException, SystemException, Exception {
        SiteNode siteNode = this.getSiteNodeWithId(siteNodeVO.getSiteNodeId(), db);
        SiteNodeImpl parent = siteNode.getParentSiteNode();
        if (parent != null) {
            Iterator childSiteNodeIterator = parent.getChildSiteNodes().iterator();
            while (childSiteNodeIterator.hasNext()) {
                SiteNode candidate = (SiteNode)childSiteNodeIterator.next();
                if (!candidate.getId().equals(siteNodeVO.getSiteNodeId())) continue;
                SiteNodeController.deleteRecursive(siteNode, childSiteNodeIterator, db, forceDelete, infogluePrincipal);
            }
        } else {
            SiteNodeController.deleteRecursive(siteNode, null, db, forceDelete, infogluePrincipal);
        }
    }

    private static void deleteRecursive(SiteNode siteNode, Iterator parentIterator, Database db, boolean forceDelete, InfoGluePrincipal infoGluePrincipal) throws ConstraintException, SystemException, Exception {
        List referenceBeanList = RegistryController.getController().getReferencingObjectsForSiteNode(siteNode.getId(), -1, db);
        if (referenceBeanList != null && referenceBeanList.size() > 0 && !forceDelete) {
            throw new ConstraintException("SiteNode.stateId", "3405");
        }
        Collection children = siteNode.getChildSiteNodes();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            SiteNode childSiteNode = (SiteNode)i.next();
            SiteNodeController.deleteRecursive(childSiteNode, i, db, forceDelete, infoGluePrincipal);
        }
        siteNode.setChildSiteNodes(new ArrayList());
        if (forceDelete || SiteNodeController.getIsDeletable(siteNode, infoGluePrincipal, db)) {
            SiteNodeVersionController.deleteVersionsForSiteNode(siteNode, db, infoGluePrincipal);
            ServiceBindingController.deleteServiceBindingsReferencingSiteNode(siteNode, db);
            if (parentIterator != null) {
                parentIterator.remove();
            }
        } else {
            throw new ConstraintException("SiteNodeVersion.stateId", "3400");
        }
        db.remove((Object)siteNode);
    }

    private static boolean getIsDeletable(SiteNode siteNode, InfoGluePrincipal infogluePrincipal, Database db) throws SystemException, Exception {
        boolean hasAccess;
        boolean isDeletable = true;
        SiteNodeVersion latestSiteNodeVersion = SiteNodeVersionController.getController().getLatestActiveSiteNodeVersion(db, siteNode.getId());
        if (latestSiteNodeVersion.getIsProtected().equals(SiteNodeVersionVO.YES) && !(hasAccess = AccessRightController.getController().getIsPrincipalAuthorized(db, infogluePrincipal, "SiteNodeVersion.DeleteSiteNode", "" + latestSiteNodeVersion.getId()))) {
            return false;
        }
        Collection siteNodeVersions = siteNode.getSiteNodeVersions();
        for (SiteNodeVersion siteNodeVersion : siteNodeVersions) {
            if (siteNodeVersion.getStateId().intValue() != SiteNodeVersionVO.PUBLISHED_STATE.intValue() || !siteNodeVersion.getIsActive().booleanValue()) continue;
            logger.warn((Object)"The siteNode had a published version so we cannot delete it..");
            isDeletable = false;
            break;
        }
        return isDeletable;
    }

    public SiteNodeVO create(Integer parentSiteNodeId, Integer siteNodeTypeDefinitionId, InfoGluePrincipal infoGluePrincipal, Integer repositoryId, SiteNodeVO siteNodeVO) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNode siteNode = null;
        SiteNodeController.beginTransaction(db);
        try {
            siteNode = this.create(db, parentSiteNodeId, siteNodeTypeDefinitionId, infoGluePrincipal, repositoryId, siteNodeVO);
            ceb.throwIfNotEmpty();
            SiteNodeController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        return siteNode.getValueObject();
    }

    public SiteNode create(Database db, Integer parentSiteNodeId, Integer siteNodeTypeDefinitionId, InfoGluePrincipal infoGluePrincipal, Integer repositoryId, SiteNodeVO siteNodeVO) throws SystemException, Exception {
        SiteNodeImpl siteNode = null;
        logger.info((Object)"******************************************");
        logger.info((Object)("parentSiteNode:" + parentSiteNodeId));
        logger.info((Object)("siteNodeTypeDefinition:" + siteNodeTypeDefinitionId));
        logger.info((Object)("repository:" + repositoryId));
        logger.info((Object)"******************************************");
        SiteNode parentSiteNode = null;
        SiteNodeTypeDefinition siteNodeTypeDefinition = null;
        if (parentSiteNodeId != null) {
            parentSiteNode = this.getSiteNodeWithId(parentSiteNodeId, db);
            if (repositoryId == null) {
                repositoryId = parentSiteNode.getRepository().getRepositoryId();
            }
        }
        if (siteNodeTypeDefinitionId != null) {
            siteNodeTypeDefinition = SiteNodeTypeDefinitionController.getController().getSiteNodeTypeDefinitionWithId(siteNodeTypeDefinitionId, db);
        }
        Repository repository = RepositoryController.getController().getRepositoryWithId(repositoryId, db);
        siteNode = new SiteNodeImpl();
        siteNode.setValueObject(siteNodeVO);
        siteNode.setParentSiteNode((SiteNodeImpl)parentSiteNode);
        siteNode.setRepository((RepositoryImpl)repository);
        siteNode.setSiteNodeTypeDefinition((SiteNodeTypeDefinitionImpl)siteNodeTypeDefinition);
        siteNode.setCreator(infoGluePrincipal.getName());
        db.create((Object)siteNode);
        if (parentSiteNode != null) {
            parentSiteNode.getChildSiteNodes().add(siteNode);
        }
        SiteNodeVersionController.createInitialSiteNodeVersion(db, siteNode, infoGluePrincipal);
        return siteNode;
    }

    public SiteNode createNewSiteNode(Database db, Integer parentSiteNodeId, Integer siteNodeTypeDefinitionId, InfoGluePrincipal infoGluePrincipal, Integer repositoryId, SiteNodeVO siteNodeVO) throws SystemException {
        SiteNodeImpl siteNode = null;
        try {
            logger.info((Object)"******************************************");
            logger.info((Object)("parentSiteNode:" + parentSiteNodeId));
            logger.info((Object)("siteNodeTypeDefinition:" + siteNodeTypeDefinitionId));
            logger.info((Object)("repository:" + repositoryId));
            logger.info((Object)"******************************************");
            SiteNode parentSiteNode = null;
            SiteNodeTypeDefinition siteNodeTypeDefinition = null;
            if (parentSiteNodeId != null) {
                parentSiteNode = this.getSiteNodeWithId(parentSiteNodeId, db);
                if (repositoryId == null) {
                    repositoryId = parentSiteNode.getRepository().getRepositoryId();
                }
            }
            if (siteNodeTypeDefinitionId != null) {
                siteNodeTypeDefinition = SiteNodeTypeDefinitionController.getController().getSiteNodeTypeDefinitionWithId(siteNodeTypeDefinitionId, db);
            }
            Repository repository = RepositoryController.getController().getRepositoryWithId(repositoryId, db);
            siteNode = new SiteNodeImpl();
            siteNode.setValueObject(siteNodeVO);
            siteNode.setParentSiteNode((SiteNodeImpl)parentSiteNode);
            siteNode.setRepository((RepositoryImpl)repository);
            siteNode.setSiteNodeTypeDefinition((SiteNodeTypeDefinitionImpl)siteNodeTypeDefinition);
            siteNode.setCreator(infoGluePrincipal.getName());
            db.create((Object)siteNode);
            SiteNodeVersion siteNodeVersion = SiteNodeVersionController.createInitialSiteNodeVersion(db, siteNode, infoGluePrincipal);
            ArrayList<SiteNodeVersion> siteNodeVersions = new ArrayList<SiteNodeVersion>();
            siteNodeVersions.add(siteNodeVersion);
            siteNode.setSiteNodeVersions(siteNodeVersions);
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to create the SiteNode in the database. Reason:" + e.getMessage(), e);
        }
        return siteNode;
    }

    public static SiteNodeVO getParentSiteNode(Integer siteNodeId) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNodeVO parentSiteNodeVO = null;
        SiteNodeController.beginTransaction(db);
        try {
            SiteNode parent = SiteNodeController.getParentSiteNode(siteNodeId, db);
            if (parent != null) {
                parentSiteNodeVO = parent.getValueObject();
            }
            SiteNodeController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            SiteNodeController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return parentSiteNodeVO;
    }

    public static SiteNode getParentSiteNode(Integer siteNodeId, Database db) throws SystemException, Bug {
        SiteNode siteNode = (SiteNode)SiteNodeController.getObjectWithId(SiteNodeImpl.class, siteNodeId, db);
        SiteNodeImpl parent = siteNode.getParentSiteNode();
        return parent;
    }

    public List getSiteNodeChildren(Integer parentSiteNodeId) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        List childrenVOList = null;
        SiteNodeController.beginTransaction(db);
        try {
            SiteNode siteNode = this.getSiteNodeWithId(parentSiteNodeId, db);
            Collection children = siteNode.getChildSiteNodes();
            childrenVOList = SiteNodeController.toVOList(children);
            ceb.throwIfNotEmpty();
            SiteNodeController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            SiteNodeController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            SiteNodeController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return childrenVOList;
    }

    public List getSiteNodeVOList(HashMap argumentHashMap) throws SystemException, Bug {
        ArrayList<SiteNodeVO> siteNodes = null;
        String method = (String)argumentHashMap.get("method");
        logger.info((Object)("method:" + method));
        if (method.equalsIgnoreCase("selectSiteNodeListOnIdList")) {
            siteNodes = new ArrayList<SiteNodeVO>();
            List arguments = (List)argumentHashMap.get("arguments");
            logger.info((Object)("Arguments:" + arguments.size()));
            for (HashMap argument : arguments) {
                logger.info((Object)("argument:" + argument.size()));
                Iterator iterator = argument.keySet().iterator();
                while (iterator.hasNext()) {
                    logger.info((Object)("   " + iterator.next()));
                }
                Integer siteNodeId = new Integer((String)argument.get("siteNodeId"));
                logger.info((Object)("Getting the siteNode with Id:" + siteNodeId));
                siteNodes.add(this.getSiteNodeVOWithId(siteNodeId));
            }
        }
        return siteNodes;
    }

    public static List getSiteNodeVOList(HashMap argumentHashMap, Database db) throws SystemException, Bug {
        ArrayList<SiteNodeVO> siteNodes = null;
        String method = (String)argumentHashMap.get("method");
        logger.info((Object)("method:" + method));
        if (method.equalsIgnoreCase("selectSiteNodeListOnIdList")) {
            siteNodes = new ArrayList<SiteNodeVO>();
            List arguments = (List)argumentHashMap.get("arguments");
            logger.info((Object)("Arguments:" + arguments.size()));
            for (HashMap argument : arguments) {
                logger.info((Object)("argument:" + argument.size()));
                Iterator iterator = argument.keySet().iterator();
                while (iterator.hasNext()) {
                    logger.info((Object)("   " + iterator.next()));
                }
                Integer siteNodeId = new Integer((String)argument.get("siteNodeId"));
                logger.info((Object)("Getting the siteNode with Id:" + siteNodeId));
                siteNodes.add(SiteNodeController.getSmallSiteNodeVOWithId(siteNodeId, db));
            }
        }
        return siteNodes;
    }

    public SiteNodeVO getRootSiteNodeVO(Integer repositoryId) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNode siteNode = null;
        SiteNodeController.beginTransaction(db);
        try {
            siteNode = this.getRootSiteNode(repositoryId, db);
            SiteNodeController.commitTransaction(db);
            ceb.throwIfNotEmpty();
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            SiteNodeController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return siteNode == null ? null : siteNode.getValueObject();
    }

    public SiteNode getRootSiteNode(Integer repositoryId, Database db) throws ConstraintException, SystemException, Exception {
        SiteNode siteNode = null;
        OQLQuery oql = db.getOQLQuery("SELECT s FROM org.infoglue.cms.entities.structure.impl.simple.SiteNodeImpl s WHERE is_undefined(s.parentSiteNode) AND s.repository.repositoryId = $1");
        oql.bind((Object)repositoryId);
        QueryResults results = oql.execute();
        logger.info((Object)("Fetching entity in read/write mode" + repositoryId));
        if (results.hasMore()) {
            siteNode = (SiteNode)results.next();
        }
        results.close();
        oql.close();
        return siteNode;
    }

    public void moveSiteNode(SiteNodeVO siteNodeVO, Integer newParentSiteNodeId) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNode siteNode = null;
        SiteNode newParentSiteNode = null;
        SiteNodeImpl oldParentSiteNode = null;
        SiteNodeController.beginTransaction(db);
        try {
            siteNodeVO.validate();
            if (newParentSiteNodeId == null) {
                logger.warn((Object)"You must specify the new parent-siteNode......");
                throw new ConstraintException("SiteNode.parentSiteNodeId", "3403");
            }
            if (siteNodeVO.getId().intValue() == newParentSiteNodeId.intValue()) {
                logger.warn((Object)"You cannot have the siteNode as it's own parent......");
                throw new ConstraintException("SiteNode.parentSiteNodeId", "3401");
            }
            siteNode = this.getSiteNodeWithId(siteNodeVO.getSiteNodeId(), db);
            oldParentSiteNode = siteNode.getParentSiteNode();
            newParentSiteNode = this.getSiteNodeWithId(newParentSiteNodeId, db);
            if (oldParentSiteNode.getId().intValue() == newParentSiteNodeId.intValue()) {
                logger.warn((Object)"You cannot specify the same node as it originally was located in......");
                throw new ConstraintException("SiteNode.parentSiteNodeId", "3404");
            }
            SiteNodeImpl tempSiteNode = newParentSiteNode.getParentSiteNode();
            while (tempSiteNode != null) {
                if (tempSiteNode.getId().intValue() == siteNode.getId().intValue()) {
                    logger.warn((Object)"You cannot move the node to a child under it......");
                    throw new ConstraintException("SiteNode.parentSiteNodeId", "3402");
                }
                tempSiteNode = tempSiteNode.getParentSiteNode();
            }
            logger.info((Object)("Setting the new Parent siteNode:" + siteNode.getSiteNodeId() + " " + newParentSiteNode.getSiteNodeId()));
            siteNode.setParentSiteNode((SiteNodeImpl)newParentSiteNode);
            this.changeRepositoryRecursive(siteNode, newParentSiteNode.getRepository());
            newParentSiteNode.getChildSiteNodes().add(siteNode);
            oldParentSiteNode.getChildSiteNodes().remove(siteNode);
            ceb.throwIfNotEmpty();
            SiteNodeController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            SiteNodeController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            SiteNodeController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    private void changeRepositoryRecursive(SiteNode siteNode, Repository newRepository) {
        if (siteNode.getRepository().getId().intValue() != newRepository.getId().intValue()) {
            siteNode.setRepository((RepositoryImpl)newRepository);
            for (SiteNode childSiteNode : siteNode.getChildSiteNodes()) {
                this.changeRepositoryRecursive(childSiteNode, newRepository);
            }
        }
    }

    @Override
    public BaseEntityVO getNewVO() {
        return new SiteNodeVO();
    }

    public List getRepositorySiteNodes(Integer repositoryId, Database db) throws SystemException, Exception {
        ArrayList<SiteNodeImpl> siteNodes = new ArrayList<SiteNodeImpl>();
        OQLQuery oql = db.getOQLQuery("SELECT sn FROM org.infoglue.cms.entities.structure.impl.simple.SiteNodeImpl sn WHERE sn.repository.repositoryId = $1");
        oql.bind((Object)repositoryId);
        QueryResults results = oql.execute((short)0);
        while (results.hasMore()) {
            SiteNodeImpl siteNode = (SiteNodeImpl)results.next();
            siteNodes.add(siteNode);
        }
        results.close();
        oql.close();
        return siteNodes;
    }

    public Content createSiteNodeMetaInfoContent(Database db, SiteNode newSiteNode, Integer repositoryId, InfoGluePrincipal principal, Integer pageTemplateContentId) throws SystemException, Bug, Exception, ConstraintException {
        Content content = null;
        String basePath = "Meta info folder";
        String path = "";
        SiteNodeImpl parentSiteNode = newSiteNode.getParentSiteNode();
        while (parentSiteNode != null) {
            path = "/" + parentSiteNode.getName() + path;
            parentSiteNode = parentSiteNode.getParentSiteNode();
        }
        path = String.valueOf(basePath) + path;
        SiteNodeVersion siteNodeVersion = SiteNodeVersionController.getController().getLatestSiteNodeVersion(db, newSiteNode.getId(), false);
        Language masterLanguage = LanguageController.getController().getMasterLanguage(db, repositoryId);
        ServiceDefinitionVO singleServiceDefinitionVO = null;
        Integer metaInfoContentTypeDefinitionId = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithName("Meta info", db).getId();
        Integer availableServiceBindingId = AvailableServiceBindingController.getController().getAvailableServiceBindingVOWithName("Meta information", db).getId();
        List serviceDefinitions = AvailableServiceBindingController.getController().getServiceDefinitionVOList(db, availableServiceBindingId);
        if (serviceDefinitions == null || serviceDefinitions.size() == 0) {
            ServiceDefinition serviceDefinition = ServiceDefinitionController.getController().getServiceDefinitionWithName("Core content service", db, false);
            String[] values = new String[]{serviceDefinition.getId().toString()};
            AvailableServiceBindingController.getController().update(availableServiceBindingId, values, db);
            singleServiceDefinitionVO = serviceDefinition.getValueObject();
        } else if (serviceDefinitions.size() == 1) {
            singleServiceDefinitionVO = (ServiceDefinitionVO)serviceDefinitions.get(0);
        }
        Object parentFolderContentVO = null;
        Content rootContent = ContentControllerProxy.getController().getRootContent(db, repositoryId, principal.getName(), true);
        if (rootContent != null) {
            ContentVersionVO contentVersionVO;
            ContentVO parentFolderContent = ContentController.getContentController().getContentVOWithPath(repositoryId, path, true, principal, db);
            ContentVO contentVO = new ContentVO();
            contentVO.setCreatorName(principal.getName());
            contentVO.setIsBranch(new Boolean(false));
            contentVO.setName(String.valueOf(newSiteNode.getName()) + " Metainfo");
            contentVO.setRepositoryId(repositoryId);
            content = ContentControllerProxy.getController().create(db, parentFolderContent.getId(), metaInfoContentTypeDefinitionId, repositoryId, contentVO);
            newSiteNode.setMetaInfoContentId(contentVO.getId());
            String componentStructure = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><components></components>";
            if (pageTemplateContentId != null) {
                Integer masterLanguageId = LanguageController.getController().getMasterLanguage(db, repositoryId).getId();
                contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(pageTemplateContentId, masterLanguageId, db);
                componentStructure = ContentVersionController.getContentVersionController().getAttributeValue(contentVersionVO, "ComponentStructure", false);
                Document document = XMLHelper.readDocumentFromByteArray(componentStructure.getBytes("UTF-8"));
                String componentXPath = "//component";
                NodeList componentNodes = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentXPath);
                int i = 0;
                while (i < componentNodes.getLength()) {
                    Element element = (Element)componentNodes.item(i);
                    String componentId = element.getAttribute("id");
                    String componentContentId = element.getAttribute("contentId");
                    ComponentController.getController().checkAndAutoCreateContents(db, newSiteNode.getId(), masterLanguageId, masterLanguageId, null, new Integer(componentId), document, new Integer(componentContentId), principal);
                    componentStructure = XMLHelper.serializeDom(document, new StringBuffer()).toString();
                    ++i;
                }
            }
            String versionValue = "<?xml version='1.0' encoding='UTF-8'?><article xmlns=\"x-schema:ArticleSchema.xml\"><attributes><Title><![CDATA[" + newSiteNode.getName() + "]]></Title><NavigationTitle><![CDATA[" + newSiteNode.getName() + "]]></NavigationTitle><NiceURIName><![CDATA[" + new VisualFormatter().replaceNiceURINonAsciiWithSpecifiedChars(newSiteNode.getName(), '_') + "]]></NiceURIName><Description><![CDATA[" + newSiteNode.getName() + "]]></Description><MetaInfo><![CDATA[" + newSiteNode.getName() + "]]></MetaInfo><ComponentStructure><![CDATA[" + componentStructure + "]]></ComponentStructure></attributes></article>";
            contentVersionVO = new ContentVersionVO();
            contentVersionVO.setVersionComment("Autogenerated version");
            contentVersionVO.setVersionModifier(principal.getName());
            contentVersionVO.setVersionValue(versionValue);
            ContentVersionController.getContentVersionController().create(contentVO.getId(), masterLanguage.getId(), contentVersionVO, null, db);
            LanguageVO localMasterLanguageVO = this.getInitialLanguageVO(db, parentFolderContent.getId(), repositoryId);
            if (localMasterLanguageVO.getId().intValue() != masterLanguage.getId().intValue()) {
                String versionValueLocalMaster = "<?xml version='1.0' encoding='UTF-8'?><article xmlns=\"x-schema:ArticleSchema.xml\"><attributes><Title><![CDATA[" + newSiteNode.getName() + "]]></Title><NavigationTitle><![CDATA[" + newSiteNode.getName() + "]]></NavigationTitle><NiceURIName><![CDATA[" + new VisualFormatter().replaceNiceURINonAsciiWithSpecifiedChars(newSiteNode.getName(), '_') + "]]></NiceURIName><Description><![CDATA[" + newSiteNode.getName() + "]]></Description><MetaInfo><![CDATA[" + newSiteNode.getName() + "]]></MetaInfo><ComponentStructure><![CDATA[]]></ComponentStructure></attributes></article>";
                ContentVersionVO contentVersionVOLocalMaster = new ContentVersionVO();
                contentVersionVOLocalMaster.setVersionComment("Autogenerated version");
                contentVersionVOLocalMaster.setVersionModifier(principal.getName());
                contentVersionVOLocalMaster.setVersionValue(versionValueLocalMaster);
                ContentVersionController.getContentVersionController().create(contentVO.getId(), localMasterLanguageVO.getId(), contentVersionVOLocalMaster, null, db);
            }
            ServiceBindingVO serviceBindingVO = new ServiceBindingVO();
            serviceBindingVO.setName(String.valueOf(newSiteNode.getName()) + " Metainfo");
            serviceBindingVO.setPath("/None specified/");
            String qualifyerXML = "<?xml version='1.0' encoding='UTF-8'?><qualifyer><contentId>" + contentVO.getId() + "</contentId></qualifyer>";
            ServiceBindingController.getController().create(db, serviceBindingVO, qualifyerXML, availableServiceBindingId, siteNodeVersion.getId(), singleServiceDefinitionVO.getId());
        }
        return content;
    }

    public LanguageVO getInitialLanguageVO(Database db, Integer contentId, Integer repositoryId) throws Exception {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        String initialLanguageId = ps.getString("content_" + contentId + "_initialLanguageId");
        Content content = ContentController.getContentController().getContentWithId(contentId, db);
        ContentImpl parentContent = content.getParentContent();
        while ((initialLanguageId == null || initialLanguageId.equalsIgnoreCase("-1")) && parentContent != null) {
            initialLanguageId = ps.getString("content_" + parentContent.getId() + "_initialLanguageId");
            parentContent = parentContent.getParentContent();
        }
        if (initialLanguageId != null && !initialLanguageId.equals("") && !initialLanguageId.equals("-1")) {
            return LanguageController.getController().getLanguageVOWithId(new Integer(initialLanguageId));
        }
        return LanguageController.getController().getMasterLanguage(repositoryId);
    }

    public List getSiteNodeVOWithParentRecursive(Integer siteNodeId) throws ConstraintException, SystemException {
        return this.getSiteNodeVOWithParentRecursive(siteNodeId, new ArrayList());
    }

    private List getSiteNodeVOWithParentRecursive(Integer siteNodeId, List resultList) throws ConstraintException, SystemException {
        resultList.add(this.getSiteNodeVOWithId(siteNodeId));
        List childSiteNodeList = SiteNodeController.getController().getSiteNodeChildren(siteNodeId);
        for (SiteNodeVO siteNodeVO : childSiteNodeList) {
            this.getSiteNodeVOWithParentRecursive(siteNodeVO.getId(), resultList);
        }
        return resultList;
    }

    public void setMetaInfoContentId(Integer siteNodeId, Integer metaInfoContentId) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNodeController.beginTransaction(db);
        try {
            this.setMetaInfoContentId(siteNodeId, metaInfoContentId, db);
            SiteNodeController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            SiteNodeController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void setMetaInfoContentId(Integer siteNodeId, Integer metaInfoContentId, Database db) throws ConstraintException, SystemException {
        SiteNode siteNode = this.getSiteNodeWithId(siteNodeId, db);
        siteNode.setMetaInfoContentId(metaInfoContentId);
    }

    public List getSiteNodeVOListWithoutMetaInfoContentId() throws ConstraintException, SystemException {
        List siteNodeVOList = new ArrayList();
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNodeController.beginTransaction(db);
        try {
            List siteNodes = this.getSiteNodesWithoutMetaInfoContentId(db);
            siteNodeVOList = SiteNodeController.toVOList(siteNodes);
            SiteNodeController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            SiteNodeController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return siteNodeVOList;
    }

    public List getSiteNodesWithoutMetaInfoContentId(Database db) throws ConstraintException, SystemException, Exception {
        ArrayList<SiteNodeImpl> siteNodes = new ArrayList<SiteNodeImpl>();
        OQLQuery oql = db.getOQLQuery("SELECT sn FROM org.infoglue.cms.entities.structure.impl.simple.SiteNodeImpl sn WHERE sn.metaInfoContentId = $1");
        oql.bind((Object)new Integer(-1));
        QueryResults results = oql.execute();
        while (results.hasMore()) {
            SiteNodeImpl siteNode = (SiteNodeImpl)results.next();
            siteNodes.add(siteNode);
        }
        results.close();
        oql.close();
        return siteNodes;
    }

    public SiteNodeVO getSiteNodeVOWithMetaInfoContentId(Integer contentId) throws ConstraintException, SystemException {
        SiteNodeVO siteNodeVO = null;
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNodeController.beginTransaction(db);
        try {
            SiteNode siteNode = this.getSiteNodeWithMetaInfoContentId(db, contentId);
            siteNodeVO = siteNode.getValueObject();
            SiteNodeController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            SiteNodeController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return siteNodeVO;
    }

    public SiteNode getSiteNodeWithMetaInfoContentId(Database db, Integer contentId) throws ConstraintException, SystemException, Exception {
        SiteNodeImpl siteNode = null;
        OQLQuery oql = db.getOQLQuery("SELECT sn FROM org.infoglue.cms.entities.structure.impl.simple.SiteNodeImpl sn WHERE sn.metaInfoContentId = $1");
        oql.bind((Object)contentId);
        QueryResults results = oql.execute();
        if (results.hasMore()) {
            siteNode = (SiteNodeImpl)results.next();
        }
        results.close();
        oql.close();
        return siteNode;
    }

    public Integer getProtectedSiteNodeVersionId(Integer siteNodeId) {
        Integer protectedSiteNodeVersionId = null;
        try {
            SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionController.getController().getLatestSiteNodeVersionVO(siteNodeId);
            if (siteNodeVersionVO.getIsProtected() != null) {
                SiteNodeVO parentSiteNodeVO;
                if (siteNodeVersionVO.getIsProtected().intValue() == NO.intValue()) {
                    protectedSiteNodeVersionId = null;
                } else if (siteNodeVersionVO.getIsProtected().intValue() == YES.intValue()) {
                    protectedSiteNodeVersionId = siteNodeVersionVO.getId();
                } else if (siteNodeVersionVO.getIsProtected().intValue() == INHERITED.intValue() && (parentSiteNodeVO = SiteNodeController.getParentSiteNode(siteNodeId)) != null) {
                    protectedSiteNodeVersionId = this.getProtectedSiteNodeVersionId(parentSiteNodeVO.getId());
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get which (if any) site node is protected:" + e.getMessage()), (Throwable)e);
        }
        return protectedSiteNodeVersionId;
    }

    public String getSiteNodePath(Integer siteNodeId, Database db) throws Exception {
        StringBuffer sb = new StringBuffer();
        SiteNodeVO siteNodeVO = SiteNodeController.getSiteNodeVOWithId(siteNodeId, db);
        while (siteNodeVO != null) {
            sb.insert(0, "/" + siteNodeVO.getName());
            siteNodeVO = siteNodeVO.getParentSiteNodeId() != null ? SiteNodeController.getSiteNodeVOWithId(siteNodeVO.getParentSiteNodeId(), db) : null;
        }
        return sb.toString();
    }

    public List<SiteNodeVO> getUpcomingExpiringSiteNodes(int numberOfWeeks) throws Exception {
        ArrayList<SiteNodeVO> siteNodeVOList = new ArrayList<SiteNodeVO>();
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        SiteNodeController.beginTransaction(db);
        try {
            OQLQuery oql = db.getOQLQuery("SELECT sn FROM org.infoglue.cms.entities.structure.impl.simple.SiteNodeImpl sn WHERE sn.expireDateTime > $1 AND sn.expireDateTime < $2 AND sn.publishDateTime < $3");
            Calendar now = Calendar.getInstance();
            Date currentDate = now.getTime();
            oql.bind((Object)currentDate);
            now.add(6, numberOfWeeks);
            Date futureDate = now.getTime();
            oql.bind((Object)futureDate);
            oql.bind((Object)currentDate);
            QueryResults results = oql.execute();
            while (results.hasMore()) {
                SiteNodeImpl siteNode = (SiteNodeImpl)results.next();
                siteNodeVOList.add(siteNode.getValueObject());
            }
            results.close();
            oql.close();
            SiteNodeController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            SiteNodeController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return siteNodeVOList;
    }
}

