/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Node;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.mydesktop.ShortcutVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.dom.DOMBuilder;

public class ShortcutController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)ShortcutController.class.getName());
    private static final ShortcutController controller = new ShortcutController();

    public static ShortcutController getController() {
        return controller;
    }

    private ShortcutController() {
    }

    public List getAvailableShortcutVOList(InfoGluePrincipal userPrincipal) throws SystemException {
        ArrayList<ShortcutVO> availableShortcutVOList = new ArrayList<ShortcutVO>();
        try {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("globalKey", "infoglue");
            PropertySet propertySet = PropertySetManager.getInstance((String)"jdbc", args);
            String xml = this.getDataPropertyValue(propertySet, "serverNode_-1_shortcuts");
            logger.info((Object)("xml:" + xml));
            if (xml != null) {
                DOMBuilder domBuilder = new DOMBuilder();
                Document document = domBuilder.getDocument(xml);
                List nodes = document.getRootElement().selectNodes("shortcut");
                logger.info((Object)("nodes:" + nodes.size()));
                for (Node node : nodes) {
                    logger.info((Object)("Node:" + node.asXML()));
                    Node nameNode = node.selectSingleNode("name");
                    Node urlNode = node.selectSingleNode("url");
                    Node popupNode = node.selectSingleNode("popup");
                    String name = nameNode.getStringValue();
                    String url = urlNode.getStringValue();
                    String popup = popupNode.getStringValue();
                    ShortcutVO shortcut = new ShortcutVO(name, url, Boolean.valueOf(popup));
                    availableShortcutVOList.add(shortcut);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when reading shortcuts:" + e.getMessage()), (Throwable)e);
        }
        return availableShortcutVOList;
    }

    public String getDataPropertyValue(PropertySet propertySet, String key) throws Exception {
        byte[] valueBytes = propertySet.getData(key);
        if (valueBytes != null) {
            return new String(valueBytes, "utf-8");
        }
        return null;
    }

    public BaseEntityVO getNewVO() {
        return null;
    }
}

